/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.TransformTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class TranslateTask
extends TransformTask {
    private final UnitPoint3D d_offset;

    public TranslateTask(PyroMod pyroMod, Collection<? extends FDSObject> collection, int n, int n2, UnitPoint3D unitPoint3D) {
        super(pyroMod, collection, n, n2);
        this.d_offset = (UnitPoint3D)unitPoint3D.clone();
    }

    @Override
    protected Object getXFormForIteration(int n) {
        Point3d point3d = this.d_offset.getValue(SI.METER).getP3d();
        point3d.scale(n);
        Transform transform = new Transform();
        transform.d_offset = new UnitPoint3D(point3d, (Unit)SI.METER);
        return transform;
    }

    @Override
    protected Task taskTransformObject(FDSObject fDSObject, Object object) {
        assert (object instanceof Transform);
        return fDSObject.taskTranslateObject(((Transform)object).d_offset);
    }

    private static class Transform {
        private UnitPoint3D d_offset;

        private Transform() {
        }
    }
}

