/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Collection;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.SelectTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public abstract class TransformTask
extends CompositeTask<PyroMod> {
    public static final int MODE_MOVE = 0;
    public static final int MODE_COPY = 1;
    private final PyroMod d_mediator;
    private final Collection<? extends FDSObject> d_objs;
    private final int d_n;
    private final int d_mode;

    protected abstract Object getXFormForIteration(int var1);

    protected abstract Task taskTransformObject(FDSObject var1, Object var2);

    public TransformTask(PyroMod pyroMod, Collection<? extends FDSObject> collection, int n, int n2) {
        super(pyroMod);
        this.d_mediator = pyroMod;
        this.d_objs = collection;
        this.d_n = n2;
        this.d_mode = n;
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    public void queueBeginRuntimeTasks() {
        switch (this.d_mode) {
            case 0: {
                this.queueMoveTasks();
                break;
            }
            case 1: {
                this.queueCopyTasks();
            }
        }
    }

    private void queueCopyTasks() {
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(this.d_mediator);
        ArrayList<? extends FDSObject> arrayList = new ArrayList<FDSObject>();
        arrayList.addAll(this.d_objs);
        for (int i = 0; i < this.d_n; ++i) {
            Object object = this.getXFormForIteration(i + 1);
            for (FDSObject fDSObject : this.d_objs) {
                FDSObject fDSObject2 = (FDSObject)fDSObject.clone();
                fDSObject2.taskSetName(fDSObject.getName() + "[" + (i + 1) + "]").run();
                this.taskTransformObject(fDSObject2, object).run();
                FDSComposite fDSComposite = fDSObject.getParent();
                if (fDSComposite == null) {
                    fDSComposite = this.d_mediator.getObstructions();
                }
                compositeTask.addTask(fDSComposite.taskAdd(fDSObject2));
                arrayList.add(fDSObject2);
            }
        }
        SelectTask selectTask = new SelectTask(this.d_mediator, arrayList);
        selectTask.addTask(compositeTask);
        this.addTask(selectTask);
    }

    private void queueMoveTasks() {
        Object object = this.getXFormForIteration(1);
        for (FDSObject fDSObject : this.d_objs) {
            this.addTask(this.taskTransformObject(fDSObject, object));
        }
    }
}

