/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AAddTask;
import pyrosim.legacy_2006_2.domain.ARemoveTask;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.TimeActivationEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class TimeActivationEventList
extends AbstractActivationEventList
implements ActivationEventList {
    static final long serialVersionUID = 1L;
    private TreeMap<Object, ActivationEvent> d_mEvents = new TreeMap();

    public TimeActivationEventList(Set<PyroMod> set) {
        super(0, set);
    }

    private boolean addEvent(ActivationEvent activationEvent) {
        ADomainObject.addDomains(activationEvent, this.getDomains());
        return this.d_mEvents.put(activationEvent.getCriteria(), activationEvent) != null;
    }

    private boolean removeEvent(ActivationEvent activationEvent) {
        ADomainObject.removeDomains(activationEvent, this.getDomains());
        return this.d_mEvents.remove(activationEvent.getCriteria()) != null;
    }

    public Collection getAllEvents() {
        return this.d_mEvents.values();
    }

    @Override
    public int size() {
        return this.d_mEvents.size();
    }

    @Override
    public Collection getInputRecords(FDSInputRecord fDSInputRecord, Map map) {
        int n;
        Serializable serializable;
        Collection collection = this.getAllEvents();
        Iterator iterator = collection.iterator();
        Vector<ActivateSequence> vector = new Vector<ActivateSequence>();
        ActivateSequence activateSequence = new ActivateSequence();
        int n2 = 0;
        while (iterator.hasNext()) {
            serializable = (TimeActivationEvent)iterator.next();
            n = ((TimeActivationEvent)serializable).getAction();
            if (n == 0) {
                activateSequence.setActivate((TimeActivationEvent)serializable);
            } else {
                activateSequence.setDeactivate((TimeActivationEvent)serializable);
            }
            if (n2 == 0 && activateSequence.isFinished() || activateSequence.isComplete() || n2 == collection.size() - 1 && activateSequence.isStarted()) {
                vector.add(activateSequence);
                activateSequence = new ActivateSequence();
            }
            ++n2;
        }
        Vector<Serializable> vector2 = new Vector<Serializable>();
        serializable = fDSInputRecord.getValue("T_OPEN") != null || fDSInputRecord.getValue("T_CLOSE") != null || fDSInputRecord.getValue("T_ACTIVATE") != null || fDSInputRecord.getValue("T_DEACTIVATE") != null || fDSInputRecord.getValue("HEAT_ACTIVATE") != null || fDSInputRecord.getValue("HEAT_DEACTIVATE") != null || fDSInputRecord.getValue("T_CREATE") != null || fDSInputRecord.getValue("T_REMOVE") != null || fDSInputRecord.getValue("HEAT_CREATE") != null || fDSInputRecord.getValue("HEAT_REMOVE") != null ? (FDSInputRecord)fDSInputRecord.clone() : fDSInputRecord;
        for (n = 0; n < vector.size(); ++n) {
            ActivateSequence activateSequence2 = (ActivateSequence)vector.get(n);
            activateSequence2.fillRecord((FDSInputRecord)serializable, map);
            vector2.add(serializable);
            serializable = (FDSInputRecord)((FDSInputRecord)serializable).clone();
            ((FDSInputRecord)serializable).removeValue("T_OPEN");
            ((FDSInputRecord)serializable).removeValue("T_CLOSE");
            ((FDSInputRecord)serializable).removeValue("T_ACTIVATE");
            ((FDSInputRecord)serializable).removeValue("T_DEACTIVATE");
            ((FDSInputRecord)serializable).removeValue("HEAT_ACTIVATE");
            ((FDSInputRecord)serializable).removeValue("HEAT_DEACTIVATE");
            ((FDSInputRecord)serializable).removeValue("T_CREATE");
            ((FDSInputRecord)serializable).removeValue("T_REMOVE");
            ((FDSInputRecord)serializable).removeValue("HEAT_CREATE");
            ((FDSInputRecord)serializable).removeValue("HEAT_REMOVE");
        }
        return vector2;
    }

    @Override
    public Object clone() {
        TimeActivationEventList timeActivationEventList = (TimeActivationEventList)super.clone();
        timeActivationEventList.d_mEvents = new TreeMap();
        Collection collection = this.getAllEvents();
        for (ActivationEvent activationEvent : collection) {
            timeActivationEventList.addEvent((ActivationEvent)activationEvent.clone());
        }
        return timeActivationEventList;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TimeActivationEventList)) {
            return false;
        }
        TimeActivationEventList timeActivationEventList = (TimeActivationEventList)object;
        if (timeActivationEventList.d_mEvents.size() != this.d_mEvents.size()) {
            return false;
        }
        Iterator<ActivationEvent> iterator = this.d_mEvents.values().iterator();
        Iterator<ActivationEvent> iterator2 = timeActivationEventList.d_mEvents.values().iterator();
        while (iterator.hasNext()) {
            if (((Object)iterator.next()).equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Task taskRemoveEvent(ActivationEvent activationEvent) {
        return new ARemoveTask<TimeActivationEvent>(this.getDomains(), new VectorFromArray<TimeActivationEvent>((TimeActivationEvent)activationEvent)){

            @Override
            protected boolean remove(TimeActivationEvent timeActivationEvent) {
                return TimeActivationEventList.this.removeEvent(timeActivationEvent);
            }

            @Override
            protected boolean add(TimeActivationEvent timeActivationEvent) {
                return TimeActivationEventList.this.addEvent(timeActivationEvent);
            }
        };
    }

    @Override
    public Task taskAddEvent(ActivationEvent activationEvent) {
        return new AAddTask<TimeActivationEvent>(this.getDomains(), new VectorFromArray<TimeActivationEvent>((TimeActivationEvent)activationEvent)){

            @Override
            protected boolean remove(TimeActivationEvent timeActivationEvent) {
                return TimeActivationEventList.this.removeEvent(timeActivationEvent);
            }

            @Override
            protected boolean add(TimeActivationEvent timeActivationEvent) {
                return TimeActivationEventList.this.addEvent(timeActivationEvent);
            }
        };
    }

    private class ActivateSequence {
        private TimeActivationEvent d_Act = null;
        private TimeActivationEvent d_Deact = null;
        private Unit seconds = SI.SECOND;

        private ActivateSequence() {
        }

        public boolean isFinished() {
            return this.d_Deact != null;
        }

        public boolean isStarted() {
            return this.d_Act != null;
        }

        public boolean isComplete() {
            return this.d_Act != null && this.d_Deact != null;
        }

        public void setActivate(TimeActivationEvent timeActivationEvent) {
            if (this.d_Deact != null) {
                double d;
                double d2 = ((UnitDouble)timeActivationEvent.getCriteria()).getValue(this.seconds);
                if (d2 < (d = ((UnitDouble)this.d_Deact.getCriteria()).getValue(this.seconds))) {
                    this.d_Act = timeActivationEvent;
                } else {
                    this.d_Deact = null;
                    this.d_Act = timeActivationEvent;
                }
            } else {
                this.d_Act = timeActivationEvent;
            }
        }

        public void setDeactivate(TimeActivationEvent timeActivationEvent) {
            if (this.d_Act != null) {
                double d;
                double d2 = ((UnitDouble)this.d_Act.getCriteria()).getValue(this.seconds);
                if (d2 < (d = ((UnitDouble)timeActivationEvent.getCriteria()).getValue(this.seconds))) {
                    this.d_Deact = timeActivationEvent;
                } else {
                    this.d_Act = null;
                    this.d_Deact = timeActivationEvent;
                }
            } else {
                this.d_Deact = timeActivationEvent;
            }
        }

        public void fillRecord(FDSInputRecord fDSInputRecord, Map map) {
            if (this.d_Act != null) {
                fDSInputRecord.setValue((String)map.get(new Integer(this.d_Act.getAction())), new Double(((UnitDouble)this.d_Act.getCriteria()).getValue(this.seconds)));
            }
            if (this.d_Deact != null) {
                fDSInputRecord.setValue((String)map.get(new Integer(this.d_Deact.getAction())), new Double(((UnitDouble)this.d_Deact.getCriteria()).getValue(this.seconds)));
            }
        }
    }
}

