/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitBox3D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class ThcpRecord
extends ADomainObject<PyroMod>
implements Serializable,
DisplayablePointObject,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    public UnitPoint3D d_location = null;
    public String d_gasPhaseQuantity = null;
    public String d_label = null;
    public UnitDouble d_dtsam = null;
    private static final Hashtable<String, ValueRange> d_ranges;
    public transient UnitBox3D d_xb = null;
    public transient UnitDouble d_depth = null;
    public transient UnitDouble d_diameter = null;
    public transient UnitDouble d_emissivity = null;
    public transient Integer d_ior = null;
    public transient Integer d_kHigh = null;
    public transient Integer d_kLow = null;

    public static ValueRange getValueRange(String string) {
        return d_ranges.get(string);
    }

    public ThcpRecord() {
    }

    public ThcpRecord(UnitPoint3D unitPoint3D, String string, String string2, UnitDouble unitDouble) {
        this();
        this.d_location = unitPoint3D;
        this.d_gasPhaseQuantity = string;
        this.d_label = string2;
        this.d_dtsam = unitDouble;
    }

    @Override
    public Object clone() {
        UnitPoint3D unitPoint3D = this.d_location != null ? (UnitPoint3D)this.d_location.clone() : null;
        UnitDouble unitDouble = this.d_dtsam != null ? (UnitDouble)this.d_dtsam.clone() : null;
        return new ThcpRecord(unitPoint3D, this.d_gasPhaseQuantity, this.d_label, unitDouble);
    }

    private void setLabel(String string) {
        this.d_label = string;
        this.fireDomainEvent(new PyroDomainEvent(this, ThcpRecord.class, 5));
    }

    public Task taskSetLabel(String string) {
        return new ASetNameTask(string){

            @Override
            public void setName(String string) {
                ThcpRecord.this.setLabel(string);
            }

            @Override
            protected String getName() {
                return ThcpRecord.this.getLabel();
            }
        };
    }

    @Override
    public UnitPoint3D getLocation() {
        return this.d_location;
    }

    @Override
    public Color getColor() {
        return Color.yellow;
    }

    public String getGasPhaseQuantity() {
        return this.d_gasPhaseQuantity;
    }

    @Override
    public int getPointSize() {
        return 8;
    }

    public String getLabel() {
        return this.d_label;
    }

    public UnitDouble getDtsam() {
        return this.d_dtsam;
    }

    @Override
    public String getFDSType() {
        return "THCP";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("THCP");
        Unit unit = FdsSISystem.getInstance().getLengthUnit();
        Vector<Double> vector = new Vector<Double>(3);
        vector.add(new Double(this.d_location.x(unit)));
        vector.add(new Double(this.d_location.y(unit)));
        vector.add(new Double(this.d_location.z(unit)));
        fDSInputRecord.setValue("XYZ", vector);
        String string = this.getGasPhaseQuantity();
        fDSInputRecord.setValue("QUANTITY", string);
        String string2 = this.getLabel();
        fDSInputRecord.setValue("LABEL", string2);
        if (this.getDtsam() != null) {
            UnitDouble unitDouble = this.getDtsam();
            Unit unit2 = FdsSISystem.getInstance().getTimeUnit();
            fDSInputRecord.setValue("DTSAM", new Double(unitDouble.getValue(unit2)));
        }
        collection.add(fDSInputRecord);
    }

    public boolean isDuplicate(ThcpRecord thcpRecord) {
        if (thcpRecord.d_location == null || thcpRecord.d_gasPhaseQuantity == null) {
            return false;
        }
        return thcpRecord.d_location.equals(this.d_location) && thcpRecord.d_gasPhaseQuantity.equals(this.d_gasPhaseQuantity);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ThcpRecord) {
            ThcpRecord thcpRecord = (ThcpRecord)object;
            boolean bl = thcpRecord.d_location.equals(this.d_location) && thcpRecord.d_gasPhaseQuantity.equals(this.d_gasPhaseQuantity) && thcpRecord.d_label.equals(this.d_label) && (this.d_dtsam == null ? thcpRecord.d_dtsam == null : this.d_dtsam.equals(thcpRecord.d_dtsam));
            return bl;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if ((!(objectInputStream instanceof PyroSimObjectInputStream) || objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 13) && this.d_dtsam != null && !ThcpRecord.getValueRange("DTSAM").checkValue(this.d_dtsam)) {
            this.d_dtsam = null;
        }
    }

    @Override
    public String getTypeDescription() {
        return "Thermocouple";
    }

    static {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        d_ranges = new Hashtable(2);
        d_ranges.put("DTSAM", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), false));
    }
}

