/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManClearTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class ThcpList
extends APyroDomainManager<Integer, ThcpRecord>
implements Serializable {
    static final long serialVersionUID = 1L;
    private Vector<ThcpRecord> d_thcpList = new Vector();

    @Override
    public Collection<? extends ThcpRecord> toCollection() {
        return new PyroCollection<Integer, ThcpRecord>(this);
    }

    @Override
    public ThcpRecord get(Integer n) {
        return this.d_thcpList.elementAt(n);
    }

    @Override
    public int size() {
        return this.d_thcpList.size();
    }

    public ThcpRecord[] toArray() {
        return this.d_thcpList.toArray(new ThcpRecord[this.d_thcpList.size()]);
    }

    @Override
    protected boolean add(ThcpRecord thcpRecord) {
        for (ThcpRecord thcpRecord2 : this.d_thcpList) {
            if (!thcpRecord2.isDuplicate(thcpRecord) && !thcpRecord2.getLabel().equals(thcpRecord.getLabel())) continue;
            return false;
        }
        super.add(thcpRecord);
        this.d_thcpList.add(thcpRecord);
        this.fireDomainEvent(new PyroDomainEvent<ThcpList, ThcpRecord>(this, thcpRecord, ThcpRecord.class, 3));
        return true;
    }

    private boolean addAll(Collection<? extends ThcpRecord> collection) {
        this.pauseUpdates();
        boolean bl = true;
        for (ThcpRecord thcpRecord : collection) {
            if (this.add(thcpRecord)) continue;
            bl = false;
        }
        this.resumeUpdates();
        return bl;
    }

    @Override
    protected boolean remove(ThcpRecord thcpRecord) {
        super.remove(thcpRecord);
        this.d_thcpList.remove(thcpRecord);
        this.fireDomainEvent(new PyroDomainEvent<ThcpList, ThcpRecord>(this, thcpRecord, ThcpRecord.class, 4));
        return true;
    }

    private boolean removeAll(Collection<? extends ThcpRecord> collection) {
        this.pauseUpdates();
        boolean bl = true;
        for (ThcpRecord thcpRecord : collection) {
            if (this.remove(thcpRecord)) continue;
            bl = false;
        }
        this.resumeUpdates();
        return bl;
    }

    public ThcpRecord getDuplicate(ThcpRecord thcpRecord) {
        for (ThcpRecord thcpRecord2 : this.d_thcpList) {
            if (!thcpRecord.isDuplicate(thcpRecord2)) continue;
            return thcpRecord2;
        }
        return null;
    }

    public boolean containsDuplicate(ThcpRecord thcpRecord) {
        return this.getDuplicate(thcpRecord) != null;
    }

    @Override
    public ThcpRecord get(String string) {
        for (ThcpRecord thcpRecord : this.d_thcpList) {
            if (!thcpRecord.getLabel().equals(string)) continue;
            return thcpRecord;
        }
        return null;
    }

    @Override
    public boolean contains(String string) {
        return this.get(string) != null;
    }

    @Override
    public boolean contains(Integer n) {
        return n < this.d_thcpList.size() && n >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.d_thcpList.isEmpty();
    }

    public ThcpRecord[] toArray(ThcpRecord[] thcpRecordArray) {
        return this.d_thcpList.toArray(thcpRecordArray);
    }

    @Override
    public Iterator<ThcpRecord> iterator() {
        return this.d_thcpList.iterator();
    }

    @Override
    public Class<ThcpRecord> getVClass() {
        return ThcpRecord.class;
    }

    @Override
    public Class<Integer> getKClass() {
        return Integer.class;
    }

    @Override
    public boolean canMakeUnique(ThcpRecord thcpRecord) {
        return !this.containsDuplicate(thcpRecord);
    }

    @Override
    public String describeObject(ThcpRecord thcpRecord) {
        return thcpRecord.getLabel();
    }

    @Override
    public ThcpRecord get(ThcpRecord thcpRecord) {
        ThcpRecord thcpRecord2 = this.getDuplicate(thcpRecord);
        if (thcpRecord2 != null) {
            return thcpRecord2;
        }
        return this.get(thcpRecord.getLabel());
    }

    @Override
    public Task taskMakeUnique(ThcpRecord thcpRecord) {
        if (this.containsDuplicate(thcpRecord)) {
            return new EmptyTask();
        }
        return new AMakeUniqueNameTask<ThcpRecord>(this.getDomains(), thcpRecord){

            @Override
            protected Task taskMakeUnique(ThcpRecord thcpRecord) {
                if (!ThcpList.this.contains(thcpRecord.getLabel())) {
                    return new EmptyTask();
                }
                int n = 1;
                String string = thcpRecord.getLabel() + " #" + n++;
                while (ThcpList.this.contains(string)) {
                    string = thcpRecord.getLabel() + " #" + n++;
                }
                return thcpRecord.taskSetLabel(string);
            }
        };
    }

    @Override
    public Task taskAddAll(Collection<? extends ThcpRecord> collection) {
        return new APyroManAddTask<Integer, ThcpRecord>((IPyroManager)this, collection){

            @Override
            public boolean add(ThcpRecord thcpRecord) {
                return ThcpList.this.add(thcpRecord);
            }

            @Override
            public boolean remove(ThcpRecord thcpRecord) {
                return ThcpList.this.remove(thcpRecord);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<ThcpRecord> list, List<ThcpRecord> list2) {
        return new APyroManReplaceTask<Integer, ThcpRecord>((IPyroManager)this, list, list2){

            @Override
            public boolean add(ThcpRecord thcpRecord) {
                return ThcpList.this.add(thcpRecord);
            }

            @Override
            public boolean remove(ThcpRecord thcpRecord) {
                return ThcpList.this.remove(thcpRecord);
            }
        };
    }

    public Task taskClear() {
        return new APyroManClearTask<Integer, ThcpRecord>((IPyroManager)this){

            @Override
            public void addAll(Collection<ThcpRecord> collection) {
                ThcpList.this.addAll(collection);
            }

            @Override
            public void removeAll(Collection<ThcpRecord> collection) {
                ThcpList.this.removeAll(collection);
            }
        };
    }
}

