/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.DirectionVector;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.ActivatableObject;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.PyroResourceFinder;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class SprkRecord
extends ActivatableObject
implements Serializable,
Cloneable,
DisplayablePointObject,
IDependent,
IFDSRenderable,
IPyroObject {
    private static final long serialVersionUID = 1L;
    public static final String NO_PART = "";
    private String d_label;
    private String d_make;
    private String d_partID;
    private DirectionVector d_orientation;
    private UnitPoint3D d_xyz;
    private UnitDouble d_rotation;
    private Vector d_activate;
    private Vector d_deactivate;

    public SprkRecord() {
        this(NO_PART);
    }

    public SprkRecord(String string) {
        this(string, NO_PART, NO_PART, 0.0, 0.0, -1.0, new UnitDouble(0.0, FdsSISystem.getInstance().getAngleUnit()), new UnitPoint3D(0.0, 0.0, 0.0, FdsSISystem.getInstance().getLengthUnit()));
    }

    public SprkRecord(String string, String string2, String string3, double d, double d2, double d3, UnitDouble unitDouble, UnitPoint3D unitPoint3D) {
        this.d_label = string;
        this.d_make = string2;
        this.d_partID = string3;
        this.d_orientation = new DirectionVector(d, d2, d3);
        this.d_rotation = unitDouble;
        this.d_xyz = unitPoint3D;
    }

    @Override
    public Object clone() {
        SprkRecord sprkRecord = (SprkRecord)super.clone();
        sprkRecord.d_xyz = this.d_xyz != null ? (UnitPoint3D)this.d_xyz.clone() : null;
        sprkRecord.d_rotation = this.d_rotation != null ? (UnitDouble)this.d_rotation.clone() : null;
        return sprkRecord;
    }

    public void reset() {
        this.d_label = NO_PART;
        this.d_make = NO_PART;
        this.d_partID = NO_PART;
        this.d_orientation = new DirectionVector(0.0, 0.0, -1.0);
        this.d_rotation = new UnitDouble(0.0, FdsSISystem.getInstance().getAngleUnit());
        this.d_xyz = new UnitPoint3D(0.0, 0.0, 0.0, FdsSISystem.getInstance().getLengthUnit());
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fixSerializable();
    }

    private void setName(String string) {
        this.d_label = string;
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public Task taskSetName(String string) {
        return new ASetNameTask(string){

            @Override
            public void setName(String string) {
                SprkRecord.this.setName(string);
            }

            @Override
            protected String getName() {
                return SprkRecord.this.getLabel();
            }
        };
    }

    public void setMake(String string) {
        this.d_make = string;
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    private void setPartID(String string) {
        this.d_partID = string;
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public void setOrientation(double d, double d2, double d3) {
        this.d_orientation.x = d;
        this.d_orientation.y = d2;
        this.d_orientation.z = d3;
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public void setRotation(double d, Unit unit) {
        this.d_rotation = new UnitDouble(d, unit);
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public void setXYZ(double d, double d2, double d3, Unit unit) {
        this.d_xyz.set(d, d2, d3, unit);
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public String getLabel() {
        return this.d_label;
    }

    public String getMake() {
        return this.d_make;
    }

    public String getPartID() {
        return this.d_partID;
    }

    public DirectionVector getOrientation() {
        return this.d_orientation;
    }

    public UnitDouble getRotation() {
        return this.d_rotation;
    }

    public UnitPoint3D getXYZ() {
        return this.d_xyz;
    }

    @Override
    public Map getEventInputRecordMap(int n) {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        treeMap.put(new Integer(0), "T_ACTIVATE");
        treeMap.put(new Integer(1), "T_DEACTIVATE");
        return treeMap;
    }

    @Override
    public String getPropertyHashString() {
        Unit unit = FdsSISystem.getInstance().getAngleUnit();
        Unit unit2 = FdsSISystem.getInstance().getLengthUnit();
        return "LABEL=" + this.d_label + ";" + "MAKE" + "=" + this.d_make + ";" + "ORIENTATION" + "=" + this.d_orientation.x + "," + this.d_orientation.y + "," + this.d_orientation.z + ";" + "ROTATION" + "=" + this.d_rotation.getValue(unit) + ";" + "XYZ" + "=" + this.d_xyz.x(unit2) + ";" + this.d_xyz.y(unit2) + ";" + this.d_xyz.z(unit2);
    }

    @Override
    public String getFDSType() {
        return "SPRK";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        Object object;
        Serializable serializable;
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("SPRK");
        fDSInputRecord.setValue("LABEL", this.getLabel());
        assert (this.getMake() != null);
        fDSInputRecord.setValue("MAKE", this.getMake());
        if (this.getOrientation().x != 0.0 || this.getOrientation().y != 0.0 || this.getOrientation().z != -1.0) {
            serializable = new Vector<Double>();
            ((Vector)serializable).add(new Double(this.getOrientation().x));
            ((Vector)serializable).add(new Double(this.getOrientation().y));
            ((Vector)serializable).add(new Double(this.getOrientation().z));
            fDSInputRecord.setValue("ORIENTATION", serializable);
        }
        if (!this.getPartID().equals(NO_PART)) {
            fDSInputRecord.setValue("PART_ID", this.getPartID());
        }
        serializable = FdsSISystem.getInstance().getAngleUnit();
        if (this.getRotation() != null && this.getRotation().getValue((Unit)serializable) != 0.0) {
            fDSInputRecord.setValue("ROTATION", new Double(this.getRotation().getValue((Unit)serializable)));
        }
        if (this.getXYZ() != null) {
            object = FdsSISystem.getInstance().getLengthUnit();
            Vector<Double> vector = new Vector<Double>();
            vector.add(new Double(this.getXYZ().x((Unit)object)));
            vector.add(new Double(this.getXYZ().y((Unit)object)));
            vector.add(new Double(this.getXYZ().z((Unit)object)));
            fDSInputRecord.setValue("XYZ", vector);
        }
        if ((object = this.getEventInputRecords(fDSInputRecord)).size() != 0) {
            collection.addAll((Collection<FDSInputRecord>)object);
        } else {
            collection.add(fDSInputRecord);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SprkRecord) {
            return ((SprkRecord)object).d_label.equals(this.d_label) && ((SprkRecord)object).d_make.equals(this.d_make) && ((SprkRecord)object).d_orientation.equals(this.d_orientation) && ((SprkRecord)object).d_partID.equals(this.d_partID) && ((SprkRecord)object).d_rotation.equals(this.d_rotation) && ((SprkRecord)object).d_xyz.equals(this.d_xyz) && super.equals(object);
        }
        return false;
    }

    @Override
    public UnitPoint3D getLocation() {
        return this.d_xyz;
    }

    @Override
    public Color getColor() {
        return Color.blue;
    }

    @Override
    public int getPointSize() {
        return 8;
    }

    @Override
    public String getTypeDescription() {
        return "Sprinkler";
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> set, Class<IDependedOn> clazz) {
        PartRecord partRecord;
        if (clazz.isAssignableFrom(PartRecord.class) && this.d_partID != null && this.d_partID.length() > 0 && (partRecord = (PartRecord)PyroResourceFinder.find(clazz, this.d_partID, this.getDomains())) != null) {
            set.add(partRecord);
        }
    }

    @Override
    public boolean dependsOnObject(IDependedOn iDependedOn) {
        return iDependedOn instanceof PartRecord && this.d_partID != null && this.d_partID.equals(((PartRecord)iDependedOn).getID());
    }

    public Task getSetParticleTask(String string) {
        return new SetParticleTask(this, string);
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn iDependedOn, IDependedOn iDependedOn2) {
        assert (iDependedOn instanceof PartRecord);
        PartRecord partRecord = (PartRecord)iDependedOn;
        PartRecord partRecord2 = (PartRecord)iDependedOn2;
        assert (partRecord == null ? this.getPartID().equals(NO_PART) : partRecord.getID().equals(this.getPartID()));
        return new SetParticleTask(this, partRecord2 != null ? partRecord2.getID() : NO_PART);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn iDependedOn, String string) {
        assert (iDependedOn instanceof PartRecord);
        PartRecord partRecord = (PartRecord)iDependedOn;
        assert (partRecord == null ? this.getPartID().equals(NO_PART) : partRecord.getID().equals(this.getPartID()));
        return new SetParticleTask(this, string);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn iDependedOn, Object object) {
        return null;
    }

    private static class SetParticleTask
    implements Task {
        private final SprkRecord d_owner;
        private final String d_old;
        private final String d_replacement;

        public SetParticleTask(SprkRecord sprkRecord, String string) {
            this.d_owner = sprkRecord;
            this.d_old = sprkRecord.getPartID();
            this.d_replacement = string;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void undo() {
            this.d_owner.setPartID(this.d_old);
        }

        @Override
        public void run() {
            this.d_owner.setPartID(this.d_replacement);
        }
    }
}

