/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManClearTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SprkList
extends APyroDomainManager<String, SprkRecord>
implements Serializable,
Cloneable,
IPyroManager<String, SprkRecord> {
    static final long serialVersionUID = 1L;
    private Vector<SprkRecord> d_sprkList = new Vector();

    @Override
    public Collection<? extends SprkRecord> toCollection() {
        return new PyroCollection<String, SprkRecord>(this);
    }

    @Override
    public Object clone() {
        SprkList sprkList = new SprkList();
        for (int i = 0; i < this.d_sprkList.size(); ++i) {
            SprkRecord sprkRecord = this.d_sprkList.elementAt(i);
            sprkList.d_sprkList.add((SprkRecord)sprkRecord.clone());
        }
        return sprkList;
    }

    @Override
    public SprkRecord get(int n) {
        return this.d_sprkList.elementAt(n);
    }

    @Override
    public SprkRecord get(String string) {
        for (int i = 0; i < this.d_sprkList.size(); ++i) {
            SprkRecord sprkRecord = this.d_sprkList.get(i);
            if (!sprkRecord.getLabel().equals(string)) continue;
            return sprkRecord;
        }
        return null;
    }

    @Override
    public boolean contains(String string) {
        for (int i = 0; i < this.d_sprkList.size(); ++i) {
            SprkRecord sprkRecord = this.d_sprkList.get(i);
            if (!sprkRecord.getLabel().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.d_sprkList.size();
    }

    public SprkRecord[] toArray() {
        return this.d_sprkList.toArray(new SprkRecord[this.d_sprkList.size()]);
    }

    @Override
    protected boolean add(SprkRecord sprkRecord) {
        SprkRecord sprkRecord2 = this.get(sprkRecord.getLabel());
        if (sprkRecord2 != null) {
            return false;
        }
        super.add(sprkRecord);
        boolean bl = this.d_sprkList.add(sprkRecord);
        this.fireDomainEvent(new PyroDomainEvent<SprkList, SprkRecord>(this, sprkRecord, SprkRecord.class, 3));
        return bl;
    }

    private boolean addAll(Collection<? extends SprkRecord> collection) {
        this.pauseUpdates();
        boolean bl = true;
        for (SprkRecord sprkRecord : collection) {
            if (this.add(sprkRecord)) continue;
            bl = false;
        }
        this.resumeUpdates();
        return bl;
    }

    public JList getAllLabels() {
        JList jList;
        Vector<String> vector = new Vector<String>();
        if (this.size() != 0) {
            for (int i = 0; i < this.size(); ++i) {
                vector.add(this.get(i).getLabel());
            }
            jList = new JList(vector);
        } else {
            jList = new JList();
        }
        return jList;
    }

    public Vector getAllNames() {
        Vector<String> vector = new Vector<String>();
        if (this.size() != 0) {
            for (int i = 0; i < this.size(); ++i) {
                vector.add(this.get(i).getLabel());
            }
        }
        return vector;
    }

    @Override
    protected boolean remove(SprkRecord sprkRecord) {
        boolean bl = this.d_sprkList.remove(sprkRecord);
        super.remove(sprkRecord);
        this.fireDomainEvent(new PyroDomainEvent<SprkList, SprkRecord>(this, sprkRecord, SprkRecord.class, 4));
        return bl;
    }

    private boolean removeAll(Collection<? extends SprkRecord> collection) {
        this.pauseUpdates();
        boolean bl = true;
        for (SprkRecord sprkRecord : collection) {
            if (this.remove(sprkRecord)) continue;
            bl = false;
        }
        this.resumeUpdates();
        return bl;
    }

    @Override
    public boolean isEmpty() {
        return this.d_sprkList.isEmpty();
    }

    public SprkRecord[] toArray(SprkRecord[] sprkRecordArray) {
        return this.d_sprkList.toArray(sprkRecordArray);
    }

    @Override
    public Iterator<SprkRecord> iterator() {
        return this.d_sprkList.iterator();
    }

    @Override
    public Class<SprkRecord> getVClass() {
        return SprkRecord.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(SprkRecord sprkRecord) {
        return true;
    }

    @Override
    public Task taskMakeUnique(SprkRecord sprkRecord) {
        return new AMakeUniqueNameTask<SprkRecord>(this.getDomains(), sprkRecord){

            @Override
            protected Task taskMakeUnique(SprkRecord sprkRecord) {
                return sprkRecord.taskSetName(APyroDomainManager.getUniqueName(SprkList.this, sprkRecord.getLabel()));
            }
        };
    }

    public static String[] getAvailable(PyroMod pyroMod) {
        File file = pyroMod.getDBDir();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith("spk");
            }
        };
        List<String> list = IOUtil.listFilenames(file, filenameFilter);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, list.get(i).substring(0, list.get(i).lastIndexOf(46)));
        }
        return theUtil.toArray(list, String.class);
    }

    @Override
    public String describeObject(SprkRecord sprkRecord) {
        return sprkRecord.getLabel();
    }

    @Override
    public SprkRecord get(SprkRecord sprkRecord) {
        return this.get(sprkRecord.getLabel());
    }

    @Override
    public Task taskAddAll(Collection<? extends SprkRecord> collection) {
        return new APyroManAddTask<String, SprkRecord>((IPyroManager)this, collection){

            @Override
            public boolean add(SprkRecord sprkRecord) {
                return SprkList.this.add(sprkRecord);
            }

            @Override
            public boolean remove(SprkRecord sprkRecord) {
                return SprkList.this.remove(sprkRecord);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<SprkRecord> list, List<SprkRecord> list2) {
        return new APyroManReplaceTask<String, SprkRecord>((IPyroManager)this, list, list2){

            @Override
            public boolean add(SprkRecord sprkRecord) {
                return SprkList.this.add(sprkRecord);
            }

            @Override
            public boolean remove(SprkRecord sprkRecord) {
                return SprkList.this.remove(sprkRecord);
            }
        };
    }

    public Task taskClear() {
        return new APyroManClearTask<String, SprkRecord>((IPyroManager)this){

            @Override
            public void addAll(Collection<SprkRecord> collection) {
                SprkList.this.addAll(collection);
            }

            @Override
            public void removeAll(Collection<SprkRecord> collection) {
                SprkList.this.removeAll(collection);
            }
        };
    }
}

