/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class SmodRecord
extends ADomainObject<PyroMod>
implements Serializable,
DisplayablePointObject,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_pLocation;
    private UnitDouble d_actObscure;
    private String d_label;
    public static final int TYPE_HESKESTAD = 0;
    public static final int TYPE_CLEARY = 1;
    private int d_type;
    private UnitDouble d_hLength;
    private UnitDouble d_cAlphaC;
    private UnitDouble d_cBetaC;
    private UnitDouble d_cAlphaE;
    private UnitDouble d_cBetaE;

    public SmodRecord(SmodList smodList) {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        this.d_pLocation = new UnitPoint3D(0.0, 0.0, 0.0, fdsSISystem.getLengthUnit());
        this.d_label = APyroDomainManager.getUniqueName(smodList, "SMOD");
        this.d_actObscure = new UnitDouble(1.0, fdsSISystem.getObscurationUnit());
        this.d_type = 0;
        this.d_hLength = new UnitDouble(1.8, SI.METER);
        this.d_cAlphaC = new UnitDouble(0.8, fdsSISystem.getUnitlessUnit());
        this.d_cBetaC = new UnitDouble(-0.9, fdsSISystem.getUnitlessUnit());
        this.d_cAlphaE = new UnitDouble(2.5, fdsSISystem.getUnitlessUnit());
        this.d_cBetaE = new UnitDouble(-0.7, fdsSISystem.getUnitlessUnit());
    }

    public String getLabel() {
        return this.getUniqueID();
    }

    @Override
    public UnitPoint3D getLocation() {
        return this.d_pLocation;
    }

    @Override
    public Color getColor() {
        return Color.white;
    }

    @Override
    public int getPointSize() {
        return 8;
    }

    @Override
    public String getUniqueID() {
        return this.d_label;
    }

    @Override
    public String getTypeDescription() {
        return "Smoke Detector";
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        collection.add(this.toRecord());
    }

    public FDSInputRecord toRecord() {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("SMOD");
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        Vector<Double> vector = new Vector<Double>(3);
        vector.add(new Double(this.d_pLocation.x(fdsSISystem.getLengthUnit())));
        vector.add(new Double(this.d_pLocation.y(fdsSISystem.getLengthUnit())));
        vector.add(new Double(this.d_pLocation.z(fdsSISystem.getLengthUnit())));
        fDSInputRecord.setValue("XYZ", vector);
        assert (this.d_type == 0 || this.d_type == 1);
        if (this.d_type == 0) {
            fDSInputRecord.setValue("LENGTH", this.d_hLength.getValue(fdsSISystem.getLengthUnit()));
        } else if (this.d_type == 1) {
            fDSInputRecord.setValue("ALPHA_C", this.d_cAlphaC.getValue(fdsSISystem.getUnitlessUnit()));
            fDSInputRecord.setValue("BETA_C", this.d_cBetaC.getValue(fdsSISystem.getUnitlessUnit()));
            fDSInputRecord.setValue("ALPHA_E", this.d_cAlphaE.getValue(fdsSISystem.getUnitlessUnit()));
            fDSInputRecord.setValue("BETA_E", this.d_cBetaE.getValue(fdsSISystem.getUnitlessUnit()));
        }
        fDSInputRecord.setValue("ACTIVATION_OBSCURATION", this.d_actObscure.getValue(fdsSISystem.getObscurationUnit()));
        fDSInputRecord.setValue("LABEL", this.d_label);
        return fDSInputRecord;
    }

    @Override
    public String getFDSType() {
        return "SMOD";
    }

    public boolean fireDomainEvent(IDomainEvent iDomainEvent, boolean bl) {
        this.pauseUpdates();
        boolean bl2 = super.fireDomainEvent(iDomainEvent);
        if (bl) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return bl2;
    }

    private void changed() {
        this.fireDomainEvent(new PyroDomainEvent(this, SmodRecord.class, 5), false);
    }

    public void setLabel(String string) {
        this.d_label = string;
        this.changed();
    }

    public void setLocation(UnitPoint3D unitPoint3D) {
        this.d_pLocation = unitPoint3D;
        this.changed();
    }

    public void setHLength(UnitDouble unitDouble) {
        this.d_hLength = unitDouble;
        this.changed();
    }

    public void setCAlphaC(UnitDouble unitDouble) {
        this.d_cAlphaC = unitDouble;
        this.changed();
    }

    public void setCBetaC(UnitDouble unitDouble) {
        this.d_cBetaC = unitDouble;
        this.changed();
    }

    public void setCAlphaE(UnitDouble unitDouble) {
        this.d_cAlphaE = unitDouble;
        this.changed();
    }

    public void setCBetaE(UnitDouble unitDouble) {
        this.d_cBetaE = unitDouble;
        this.changed();
    }

    public void setObscuration(UnitDouble unitDouble) {
        this.d_actObscure = unitDouble;
        this.changed();
    }

    public UnitDouble getObscuration() {
        return this.d_actObscure;
    }

    public void setType(int n) {
        this.d_type = n;
        this.changed();
    }

    public int getType() {
        return this.d_type;
    }

    public UnitDouble getLength() {
        return this.d_hLength;
    }

    public UnitDouble getCAlphaC() {
        return this.d_cAlphaC;
    }

    public UnitDouble getCBetaC() {
        return this.d_cBetaC;
    }

    public UnitDouble getCAlphaE() {
        return this.d_cAlphaE;
    }

    public UnitDouble getCBetaE() {
        return this.d_cBetaE;
    }

    public Task taskSetLabel(String string) {
        return new AChangePyroDepOnIDTask(this, string, this.getDomains()){

            @Override
            public void setID(String string) {
                SmodRecord.this.setLabel(string);
            }
        };
    }
}

