/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.domain.dependencies.APyroManReplaceDepOnTask;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class SmodList
extends APyroDomainManager<String, SmodRecord>
implements Serializable {
    static final long serialVersionUID = 1698158972204305638L;
    private final List<SmodRecord> d_recs = new ArrayList<SmodRecord>();

    @Override
    public boolean add(SmodRecord smodRecord) {
        if (this.contains(smodRecord.getLabel())) {
            return false;
        }
        boolean bl = this.d_recs.add(smodRecord) && super.add(smodRecord);
        this.fireDomainEvent(new PyroDomainEvent<SmodList, SmodRecord>(this, smodRecord, SmodRecord.class, 3));
        return bl;
    }

    @Override
    public boolean remove(SmodRecord smodRecord) {
        boolean bl = this.d_recs.remove(smodRecord) && super.remove(smodRecord);
        this.fireDomainEvent(new PyroDomainEvent<SmodList, SmodRecord>(this, smodRecord, SmodRecord.class, 4));
        return bl;
    }

    public int indexOf(String string) {
        for (int i = 0; i < this.d_recs.size(); ++i) {
            if (!this.d_recs.get(i).getLabel().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Task taskAddAll(Collection<? extends SmodRecord> collection) {
        return new APyroManAddTask<String, SmodRecord>((IPyroManager)this, collection){

            @Override
            public boolean add(SmodRecord smodRecord) {
                return SmodList.this.add(smodRecord);
            }

            @Override
            public boolean remove(SmodRecord smodRecord) {
                return SmodList.this.remove(smodRecord);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<SmodRecord> list, List<SmodRecord> list2) {
        return new APyroManReplaceDepOnTask<String, SmodRecord>((IPyroManager)this, list, list2, this.getDomains()){

            @Override
            public boolean add(SmodRecord smodRecord) {
                return SmodList.this.add(smodRecord);
            }

            @Override
            public boolean remove(SmodRecord smodRecord) {
                return SmodList.this.remove(smodRecord);
            }
        };
    }

    @Override
    public boolean contains(String string) {
        return this.indexOf(string) >= 0;
    }

    @Override
    public SmodRecord get(String string) {
        int n = this.indexOf(string);
        if (n >= 0) {
            return this.d_recs.get(this.indexOf(string));
        }
        return null;
    }

    @Override
    public SmodRecord get(SmodRecord smodRecord) {
        return this.get(smodRecord.getLabel());
    }

    @Override
    public boolean canMakeUnique(SmodRecord smodRecord) {
        return true;
    }

    @Override
    public Task taskMakeUnique(SmodRecord smodRecord) {
        return new AMakeUniqueNameTask<SmodRecord>(this.getDomains(), smodRecord){

            @Override
            protected Task taskMakeUnique(SmodRecord smodRecord) {
                return smodRecord.taskSetLabel(APyroDomainManager.getUniqueName(SmodList.this, smodRecord.getLabel()));
            }
        };
    }

    @Override
    public String describeObject(SmodRecord smodRecord) {
        return smodRecord.getLabel();
    }

    @Override
    public int size() {
        return this.d_recs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d_recs.isEmpty();
    }

    public SmodRecord[] toArray() {
        return this.d_recs.toArray(new SmodRecord[this.size()]);
    }

    public SmodRecord[] toArray(SmodRecord[] smodRecordArray) {
        return this.d_recs.toArray(smodRecordArray);
    }

    @Override
    public Class<SmodRecord> getVClass() {
        return SmodRecord.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public Collection<? extends SmodRecord> toCollection() {
        return new PyroCollection<String, SmodRecord>(this);
    }

    @Override
    public Iterator<SmodRecord> iterator() {
        return this.d_recs.iterator();
    }
}

