/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class SlcfRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    private String d_xyzPlane;
    private UnitDouble d_udXYZValue;
    private String d_gasPhaseQuantity;
    private boolean d_useVector;
    private UnitDouble d_dtsam;
    private static final Hashtable<String, ValueRange> d_ranges;

    public static ValueRange getValueRange(String string) {
        return d_ranges.get(string);
    }

    public SlcfRecord(String string, UnitDouble unitDouble, String string2, boolean bl, UnitDouble unitDouble2) {
        this.d_xyzPlane = string;
        this.d_udXYZValue = unitDouble;
        this.d_gasPhaseQuantity = string2;
        this.d_useVector = bl;
        this.d_dtsam = unitDouble2;
    }

    @Override
    public Object clone() {
        SlcfRecord slcfRecord = (SlcfRecord)super.clone();
        slcfRecord.d_dtsam = this.d_dtsam != null ? (UnitDouble)this.d_dtsam.clone() : null;
        slcfRecord.d_udXYZValue = this.d_udXYZValue != null ? (UnitDouble)this.d_udXYZValue.clone() : null;
        return slcfRecord;
    }

    public String getPlane() {
        return this.d_xyzPlane;
    }

    public UnitDouble getValue() {
        return this.d_udXYZValue;
    }

    public String getGasPhaseQuantity() {
        return this.d_gasPhaseQuantity;
    }

    public boolean getUseVector() {
        return this.d_useVector;
    }

    public UnitDouble getDtsam() {
        return this.d_dtsam;
    }

    @Override
    public String getFDSType() {
        return "SLCF";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        UnitDouble unitDouble;
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("SLCF");
        fDSInputRecord.setValue(this.getPlane(), new Double(this.getValue().getValue(FdsSISystem.getInstance().getLengthUnit())));
        String string = this.getGasPhaseQuantity();
        fDSInputRecord.setValue("QUANTITY", string);
        if (this.getUseVector()) {
            fDSInputRecord.setValue("VECTOR", Boolean.TRUE);
        }
        if ((unitDouble = this.getDtsam()) != null) {
            Unit unit = FdsSISystem.getInstance().getTimeUnit();
            fDSInputRecord.setValue("DTSAM", new Double(unitDouble.getValue(unit)));
        }
        collection.add(fDSInputRecord);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SlcfRecord) {
            SlcfRecord slcfRecord = (SlcfRecord)object;
            return slcfRecord.d_xyzPlane.equals(this.d_xyzPlane) && slcfRecord.d_udXYZValue.equals(this.d_udXYZValue) && slcfRecord.d_gasPhaseQuantity.equals(this.d_gasPhaseQuantity) && slcfRecord.d_useVector == this.d_useVector && (this.d_dtsam == null ? slcfRecord.d_dtsam == null : this.d_dtsam.equals(slcfRecord.d_dtsam));
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.d_xyzPlane = (String)getField.get("d_xyzPlane", null);
        this.d_udXYZValue = (UnitDouble)getField.get("d_udXYZValue", null);
        this.d_gasPhaseQuantity = (String)getField.get("d_gasPhaseQuantity", null);
        this.d_useVector = getField.get("d_useVector", false);
        if (this.d_udXYZValue == null) {
            double d = getField.get("d_xyzValue", 0.0);
            this.d_udXYZValue = new UnitDouble(d, SI.METER);
        }
        if ((!(objectInputStream instanceof PyroSimObjectInputStream) || objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 13) && this.d_dtsam != null && !SlcfRecord.getValueRange("DTSAM").checkValue(this.d_dtsam)) {
            this.d_dtsam = null;
        }
    }

    @Override
    public String getTypeDescription() {
        return "Planar Slice";
    }

    static {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        d_ranges = new Hashtable(2);
        d_ranges.put("DTSAM", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), false));
    }
}

