/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AFDSFaceProps;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.BlockFragGenerator;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.geom.Triangle;
import pyrosim.legacy_2006_2.geom.Util;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Slab
extends AbstractFDSObject {
    static final long serialVersionUID = 1L;
    public static final int NUM_FACES = 5;
    private static final String[] FDS_FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    private static final int FACE_POINTS = 0;
    private static final int FACE_POINTS_EXTRUDED = 1;
    private static final int FACE_P1_P2 = 2;
    private static final int FACE_P2_P3 = 3;
    private static final int FACE_P3_P1 = 4;
    private transient boolean d_selected;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = false;
    private UnitDouble d_thickness;
    private UnitPoint3D d_pt1;
    private UnitPoint3D d_pt2;
    private UnitPoint3D d_pt3;

    public Slab(Material material) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, SI.METER), new UnitPoint3D(1.0, 0.0, 0.0, SI.METER), new UnitPoint3D(0.0, 1.0, 0.0, SI.METER), material);
    }

    public Slab(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, UnitPoint3D unitPoint3D3, Material material) {
        this(unitPoint3D, unitPoint3D2, unitPoint3D3, new UnitDouble(0.2, SI.METER), material);
    }

    public Slab(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, UnitPoint3D unitPoint3D3, UnitDouble unitDouble, Material material) {
        this.d_faces = new Vector(5);
        for (int i = 0; i < 5; ++i) {
            this.d_faces.add(new SlabFace(this, i));
        }
        this.setPoints(unitPoint3D, unitPoint3D2, unitPoint3D3);
        this.setThickness(unitDouble);
        this.setMaterial(material);
    }

    public void setIsSawtoothed(boolean bl) {
        this.d_sawtooth = bl;
        this.changed();
    }

    public void setIsThickened(boolean bl) {
        this.d_thicken = bl;
        this.changed();
    }

    public void setPermitsHole(boolean bl) {
        this.d_permitHole = bl;
        this.changed();
    }

    public void setPoints(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, UnitPoint3D unitPoint3D3) {
        this.d_pt1 = unitPoint3D;
        this.d_pt2 = unitPoint3D2;
        this.d_pt3 = unitPoint3D3;
        this.changed();
    }

    public void setPoint(int n, UnitPoint3D unitPoint3D) {
        switch (n) {
            case 0: {
                this.d_pt1 = unitPoint3D;
                break;
            }
            case 1: {
                this.d_pt2 = unitPoint3D;
                break;
            }
            case 2: {
                this.d_pt3 = unitPoint3D;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.changed();
    }

    public void setThickness(UnitDouble unitDouble) {
        this.d_thickness = unitDouble;
        this.changed();
    }

    @Override
    protected void imprint(Object object) {
        if (!(object instanceof Slab)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        Slab slab = (Slab)object;
        Iterator<IFace> iterator = this.getFaceIterator();
        while (iterator.hasNext()) {
            ((SlabFace)iterator.next()).d_slab = this;
        }
        this.d_thickness = (UnitDouble)slab.d_thickness.clone();
        this.d_pt1 = (UnitPoint3D)slab.d_pt1.clone();
        this.d_pt2 = (UnitPoint3D)slab.d_pt2.clone();
        this.d_pt3 = (UnitPoint3D)slab.d_pt3.clone();
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    protected void fillExtraRecords(FDSInputRecord fDSInputRecord) {
        fDSInputRecord.setValue("PERMIT_HOLE", new Boolean(this.d_permitHole));
        fDSInputRecord.setValue("SAWTOOTH", new Boolean(this.d_sawtooth));
        fDSInputRecord.setValue("THICKEN", new Boolean(this.d_thicken));
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
    }

    @Override
    public int getNumFaces() {
        return 5;
    }

    @Override
    public String getTypeDescription() {
        return "Slab";
    }

    public UnitPoint3D[] getPoints() {
        UnitPoint3D[] unitPoint3DArray = new UnitPoint3D[]{this.d_pt1, this.d_pt2, this.d_pt3};
        return unitPoint3DArray;
    }

    public UnitDouble getThickness() {
        return this.d_thickness;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    @Override
    public boolean isRasterizable() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    @Override
    public void setMaterial(int n, Material material) {
        if (n < this.getNumFaces()) {
            for (IFace iFace : this.d_faces) {
                iFace.setMaterial(material);
            }
            this.changed();
        }
    }

    @Override
    public Material getMaterial(int n) {
        if (n < this.getNumFaces()) {
            return ((IFace)this.d_faces.get(n)).getMaterial();
        }
        return null;
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void rotate(UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        Matrix3d matrix3d = Slab.getRotateMat(vector3d, unitDouble);
        Point3d point3d2 = this.d_pt1.getPoint3dValue(unit);
        Point3d point3d3 = this.d_pt2.getPoint3dValue(unit);
        Point3d point3d4 = this.d_pt3.getPoint3dValue(unit);
        Slab.rotatePoint(point3d2, point3d, matrix3d);
        Slab.rotatePoint(point3d3, point3d, matrix3d);
        Slab.rotatePoint(point3d4, point3d, matrix3d);
        this.setPoints(new UnitPoint3D(point3d2, unit), new UnitPoint3D(point3d3, unit), new UnitPoint3D(point3d4, unit));
    }

    @Override
    protected void mirror(int n, UnitDouble unitDouble) {
    }

    @Override
    protected void scale(UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        assert (tuple3d.x >= 0.0 && tuple3d.y >= 0.0 && tuple3d.z >= 0.0);
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        Point3d point3d2 = this.d_pt1.getPoint3dValue(unit);
        Point3d point3d3 = this.d_pt2.getPoint3dValue(unit);
        Point3d point3d4 = this.d_pt3.getPoint3dValue(unit);
        double d = this.d_thickness.getValue(unit);
        Slab.scalePoint(point3d2, point3d, tuple3d);
        Slab.scalePoint(point3d3, point3d, tuple3d);
        Slab.scalePoint(point3d4, point3d, tuple3d);
        d = this.scaleThickness(d, point3d, tuple3d, point3d2, point3d3, point3d4);
        ADomainObject.pauseUpdates(this, false);
        this.setPoints(new UnitPoint3D(point3d2, unit), new UnitPoint3D(point3d3, unit), new UnitPoint3D(point3d4, unit));
        this.setThickness(new UnitDouble(d, unit));
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    private double scaleThickness(double d, Point3d point3d, Tuple3d tuple3d, Point3d ... point3dArray) {
        Vector3d vector3d = Slab.getExtrusionVec(d, point3dArray);
        Slab.scaleVector(vector3d, point3d, tuple3d);
        if (d < 0.0) {
            return -vector3d.length();
        }
        return vector3d.length();
    }

    @Override
    protected void translate(UnitPoint3D unitPoint3D) {
        this.d_pt1.add(unitPoint3D);
        this.d_pt2.add(unitPoint3D);
        this.d_pt3.add(unitPoint3D);
        this.changed();
    }

    private void changed() {
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    private static Vector3d getExtrusionVec(double d, Point3d ... point3dArray) {
        Vector3d vector3d = Slab.getNormal(point3dArray);
        vector3d.scale(-d);
        return vector3d;
    }

    private static Vector3d getNormal(Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3dArray[1], point3dArray[0]);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(point3dArray[2], point3dArray[0]);
        vector3d.cross(vector3d2, vector3d3);
        vector3d.normalize();
        return vector3d;
    }

    private static class SlabFace
    implements IFace,
    Serializable {
        static final long serialVersionUID = 1L;
        public Slab d_slab;
        public final int d_faceIndex;
        private Material d_material;

        public SlabFace(Slab slab, int n) {
            this.d_slab = slab;
            this.d_faceIndex = n;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        @Override
        public String getName() {
            return FDS_FACE_NAMES[this.d_faceIndex];
        }

        @Override
        public Material getMaterial() {
            return this.d_material;
        }

        @Override
        public void setMaterial(Material material) {
            this.d_material = material;
        }

        @Override
        public void getGeometry(Geometry geometry) {
            Point3d[] point3dArray = this.getGeomVerts();
            PrimProps primProps = new PrimProps(this.getMaterial(), this.d_slab.getColor());
            if (point3dArray.length == 3) {
                geometry.addTriangle(new Triangle(point3dArray, primProps));
            } else {
                geometry.addQuad(new Quad(point3dArray, primProps));
            }
        }

        private Point3d[] getGeomVerts() {
            Point3d[] point3dArray;
            Unit unit = Geometry.GEOM_LENGTH_UNIT;
            double d = this.d_slab.d_thickness.getValue(unit);
            Point3d[] point3dArray2 = Util.convertArray(unit, this.d_slab.d_pt1, this.d_slab.d_pt2, this.d_slab.d_pt3);
            if (d < 0.0) {
                d = -d;
                point3dArray2 = new Point3d[]{point3dArray2[2], point3dArray2[1], point3dArray2[0]};
            }
            switch (this.d_faceIndex) {
                case 0: {
                    point3dArray = new Point3d[]{point3dArray2[0], point3dArray2[1], point3dArray2[2]};
                    break;
                }
                case 1: {
                    Vector3d vector3d = Slab.getExtrusionVec(d, point3dArray2);
                    point3dArray = new Point3d[3];
                    point3dArray[0] = point3dArray2[2];
                    point3dArray[0].add(vector3d);
                    point3dArray[1] = point3dArray2[1];
                    point3dArray[1].add(vector3d);
                    point3dArray[2] = point3dArray2[0];
                    point3dArray[2].add(vector3d);
                    break;
                }
                case 2: {
                    Vector3d vector3d = Slab.getExtrusionVec(d, point3dArray2);
                    point3dArray = new Point3d[4];
                    point3dArray[0] = point3dArray2[0];
                    point3dArray[1] = new Point3d(point3dArray2[0]);
                    point3dArray[1].add(vector3d);
                    point3dArray[2] = new Point3d(point3dArray2[1]);
                    point3dArray[2].add(vector3d);
                    point3dArray[3] = point3dArray2[1];
                    break;
                }
                case 3: {
                    Vector3d vector3d = Slab.getExtrusionVec(d, point3dArray2);
                    point3dArray = new Point3d[4];
                    point3dArray[0] = point3dArray2[1];
                    point3dArray[1] = new Point3d(point3dArray2[1]);
                    point3dArray[1].add(vector3d);
                    point3dArray[2] = new Point3d(point3dArray2[2]);
                    point3dArray[2].add(vector3d);
                    point3dArray[3] = point3dArray2[2];
                    break;
                }
                case 4: {
                    Vector3d vector3d = Slab.getExtrusionVec(d, point3dArray2);
                    point3dArray = new Point3d[4];
                    point3dArray[0] = point3dArray2[2];
                    point3dArray[1] = new Point3d(point3dArray2[2]);
                    point3dArray[1].add(vector3d);
                    point3dArray[2] = new Point3d(point3dArray2[0]);
                    point3dArray[2].add(vector3d);
                    point3dArray[3] = point3dArray2[0];
                    break;
                }
                default: {
                    point3dArray = null;
                    assert (false);
                    break;
                }
            }
            return point3dArray;
        }

        @Override
        public Iterator getVentIterator() {
            return null;
        }

        @Override
        public boolean isSelected() {
            return this.d_slab.isSelected();
        }

        @Override
        public void setSelected(boolean bl) {
            this.d_slab.setSelected(bl);
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_slab;
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return Util.convertArray(Geometry.GEOM_LENGTH_UNIT, this.getGeomVerts());
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return new BlockFragGenerator(new AFDSFaceProps(this){

                @Override
                public boolean isThickened() {
                    return d_slab.isThickened();
                }

                @Override
                public boolean permitsHoles() {
                    return d_slab.permitsHole();
                }

                @Override
                public boolean isSawtoothed() {
                    return d_slab.isSawtoothed();
                }
            }, FDSRasterization.getCellPriority(false, true, this.d_slab.permitsHole()));
        }
    }

    private class SaveGeomTask
    extends ATask {
        private UnitDouble d_thickness;
        private UnitPoint3D d_pt1;
        private UnitPoint3D d_pt2;
        private UnitPoint3D d_pt3;

        public SaveGeomTask(int n) {
            super(n, true);
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(Slab.this, false);
            Slab.this.setThickness(this.d_thickness);
            Slab.this.setPoints(this.d_pt1, this.d_pt2, this.d_pt3);
            ADomainObject.resumeUpdates(Slab.this, new FDSObjectDomainEvent(Slab.this, 5));
        }

        @Override
        public void run() {
            this.d_thickness = (UnitDouble)Slab.this.d_thickness.clone();
            this.d_pt1 = (UnitPoint3D)Slab.this.d_pt1.clone();
            this.d_pt2 = (UnitPoint3D)Slab.this.d_pt2.clone();
            this.d_pt3 = (UnitPoint3D)Slab.this.d_pt3.clone();
        }
    }
}

