/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.TransformTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class ScaleTask
extends TransformTask {
    private final UnitPoint3D d_base;
    private final Tuple3d d_scale;

    public ScaleTask(PyroMod pyroMod, Collection<? extends FDSObject> collection, int n, int n2, UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        super(pyroMod, collection, n, n2);
        this.d_base = (UnitPoint3D)unitPoint3D.clone();
        this.d_scale = new Vector3d(tuple3d);
    }

    @Override
    protected Object getXFormForIteration(int n) {
        Transform transform = new Transform();
        transform.d_scale = new Vector3d();
        ((Transform)transform).d_scale.x = Math.pow(this.d_scale.x, n);
        ((Transform)transform).d_scale.y = Math.pow(this.d_scale.y, n);
        ((Transform)transform).d_scale.z = Math.pow(this.d_scale.z, n);
        return transform;
    }

    @Override
    protected Task taskTransformObject(FDSObject fDSObject, Object object) {
        assert (object instanceof Transform);
        return fDSObject.taskScaleObject(this.d_base, ((Transform)object).d_scale);
    }

    private static class Transform {
        private Tuple3d d_scale;

        private Transform() {
        }
    }
}

