/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.TransformTask;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class RotateTask
extends TransformTask {
    private final UnitPoint3D d_base;
    private final Vector3d d_rotateAxis;
    private final Unit d_angleUnit = SI.RADIAN;
    private final double d_angle;

    public RotateTask(PyroMod pyroMod, Collection<? extends FDSObject> collection, int n, int n2, UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        super(pyroMod, collection, n, n2);
        this.d_base = (UnitPoint3D)unitPoint3D.clone();
        this.d_rotateAxis = new Vector3d(vector3d);
        this.d_angle = unitDouble.getValue(this.d_angleUnit);
    }

    @Override
    protected Object getXFormForIteration(int n) {
        Transform transform = new Transform();
        transform.d_angle = new UnitDouble(this.d_angle * (double)n, this.d_angleUnit);
        return transform;
    }

    @Override
    protected Task taskTransformObject(FDSObject fDSObject, Object object) {
        assert (object instanceof Transform);
        return fDSObject.taskRotateObject(this.d_base, this.d_rotateAxis, ((Transform)object).d_angle);
    }

    private static class Transform {
        private UnitDouble d_angle;

        private Transform() {
        }
    }
}

