/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddAtIndexTask;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManOpTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.APyroManReplaceDepOnTask;
import pyrosim.legacy_2006_2.events.ReactionDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class ReactionList
extends APyroDomainManager<String, Reaction>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SortedSet<Reaction> d_reacs = new TreeSet<Reaction>(new LinOrd());

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Object object = getField.get("d_reacs", null);
        if (object instanceof List) {
            this.d_reacs = new TreeSet<Reaction>(new LinOrd());
            this.d_reacs.addAll((List)object);
        } else {
            this.d_reacs = (SortedSet)object;
        }
    }

    @Override
    public Collection<? extends Reaction> toCollection() {
        return new PyroCollection<String, Reaction>(this);
    }

    public static ReactionList fromLegacy(pyrosim.legacy_2006_2.legacy.ReactionList reactionList) {
        ReactionList reactionList2 = new ReactionList();
        Reaction[] reactionArray = reactionList.getAllReactions();
        for (int i = 0; i < reactionArray.length; ++i) {
            reactionList2.add(reactionArray[i]);
        }
        return reactionList2;
    }

    @Override
    public int size() {
        return this.d_reacs.size();
    }

    @Override
    public boolean contains(String string) {
        return this.get(string) != null;
    }

    public Reaction[] toArray() {
        return this.d_reacs.toArray(new Reaction[this.d_reacs.size()]);
    }

    public int indexOf(Reaction reaction) {
        Iterator iterator = this.d_reacs.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (iterator.next() == reaction) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean add(Reaction reaction, int n) {
        return this.add(reaction);
    }

    @Override
    protected boolean add(Reaction reaction) {
        Reaction reaction2 = this.get(reaction.getName());
        if (reaction2 != null) {
            return false;
        }
        super.add(reaction);
        this.d_reacs.add(reaction);
        this.fireDomainEvent(new ReactionDomainEvent(this, reaction, 3));
        return true;
    }

    @Override
    public Reaction get(String string) {
        for (Reaction reaction : this.d_reacs) {
            if (!reaction.getName().equals(string)) continue;
            return reaction;
        }
        return null;
    }

    @Override
    public Reaction get(int n) {
        return (Reaction)this.d_reacs.toArray()[n];
    }

    @Override
    protected boolean remove(Reaction reaction) {
        boolean bl = this.d_reacs.remove(reaction);
        super.remove(reaction);
        this.fireDomainEvent(new ReactionDomainEvent(this, reaction, 4));
        return bl;
    }

    private boolean removeAll(Collection<? extends Reaction> collection) {
        this.pauseUpdates();
        boolean bl = true;
        for (Reaction reaction : collection) {
            if (this.remove(reaction)) continue;
            bl = false;
        }
        this.resumeUpdates();
        return bl;
    }

    @Override
    public Object clone() {
        ReactionList reactionList = new ReactionList();
        for (Reaction reaction : this.d_reacs) {
            Reaction reaction2 = (Reaction)reaction.clone();
            reactionList.add(reaction2);
        }
        return reactionList;
    }

    @Override
    public boolean isEmpty() {
        return this.d_reacs.isEmpty();
    }

    public Reaction[] toArray(Reaction[] reactionArray) {
        return this.d_reacs.toArray(reactionArray);
    }

    @Override
    public Iterator<Reaction> iterator() {
        return this.d_reacs.iterator();
    }

    @Override
    public Class<Reaction> getVClass() {
        return Reaction.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(Reaction reaction) {
        return true;
    }

    @Override
    public Task taskMakeUnique(Reaction reaction) {
        return new AMakeUniqueNameTask<Reaction>(this.getDomains(), reaction){

            @Override
            protected Task taskMakeUnique(Reaction reaction) {
                return reaction.taskSetName(APyroDomainManager.getUniqueName(ReactionList.this, reaction.getName()));
            }
        };
    }

    public Task taskSetMatName(final Reaction reaction, String string) {
        return new AChangePyroDepOnIDTask(reaction, string, this.getDomains()){

            @Override
            public void setID(String string) {
                this.pauseUpdates();
                ReactionList.this.d_reacs.remove(reaction);
                reaction.setName(string);
                ReactionList.this.d_reacs.add(reaction);
                ReactionList.this.fireDomainEvent(new ReactionDomainEvent(ReactionList.this.toCollection(), 2));
                this.resumeUpdates();
            }
        };
    }

    @Override
    public Reaction get(Reaction reaction) {
        return this.get(reaction.getName());
    }

    @Override
    public String describeObject(Reaction reaction) {
        return reaction.getName();
    }

    public Task taskAdd(Reaction reaction, int n) {
        return this.taskAddAll(Arrays.asList(reaction), n);
    }

    public Task taskAddAll(Collection<Reaction> collection, int n) {
        APyroManAddAtIndexTask<String, Reaction> aPyroManAddAtIndexTask = new APyroManAddAtIndexTask<String, Reaction>((IPyroManager)this, collection, n){

            @Override
            public void removeAll(Collection<? extends Reaction> collection) {
                ReactionList.this.removeAll(collection);
            }

            @Override
            public boolean add(Reaction reaction, int n) {
                return ReactionList.this.add(reaction, n);
            }
        };
        return new AddTask(this, aPyroManAddAtIndexTask);
    }

    @Override
    public Task taskAddAll(Collection<? extends Reaction> collection) {
        APyroManAddTask<String, Reaction> aPyroManAddTask = new APyroManAddTask<String, Reaction>((IPyroManager)this, collection){

            @Override
            public boolean add(Reaction reaction) {
                return ReactionList.this.add(reaction);
            }

            @Override
            public boolean remove(Reaction reaction) {
                return ReactionList.this.remove(reaction);
            }
        };
        return new AddTask(this, aPyroManAddTask);
    }

    @Override
    public Task taskRemoveAll(List<Reaction> list, List<Reaction> list2) {
        return new APyroManReplaceDepOnTask<String, Reaction>((IPyroManager)this, list, list2, this.getDomains()){

            @Override
            public boolean add(Reaction reaction) {
                return ReactionList.this.add(reaction);
            }

            @Override
            public boolean remove(Reaction reaction) {
                return ReactionList.this.remove(reaction);
            }
        };
    }

    private static class LinOrd
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 8666170485159989321L;

        private LinOrd() {
        }

        public int compare(Object object, Object object2) {
            Reaction reaction = (Reaction)object;
            Reaction reaction2 = (Reaction)object2;
            return reaction.getName().compareToIgnoreCase(reaction2.getName());
        }
    }

    private static class AddTask
    extends CompositeTask<PyroMod> {
        private final ReactionList d_parent;
        private final APyroManOpTask d_mainAddTask;

        public AddTask(ReactionList reactionList, APyroManOpTask aPyroManOpTask) {
            super(reactionList.getDomains());
            this.d_parent = reactionList;
            this.d_mainAddTask = aPyroManOpTask;
        }

        @Override
        protected void queueBeginRuntimeTasks() {
            Collection collection = this.d_mainAddTask.getObjects();
            if (collection.isEmpty()) {
                return;
            }
            this.addTask(this.d_mainAddTask);
            if (this.d_parent.isEmpty()) {
                Reaction reaction = (Reaction)collection.iterator().next();
                PyroMod.MiscRecord miscRecord = ((PyroMod)this.getDomains().iterator().next()).getMiscManager().getMiscRecord();
                this.addTask(miscRecord.taskSetReaction(reaction.getName()));
            }
        }
    }
}

