/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitSystem;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.ReactionDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Reaction
extends ADomainObject<PyroMod>
implements Serializable,
Cloneable,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    public static final String NAME = "ID";
    public static final String NU_O2 = "NU_O2";
    public static final String NU_H2O = "NU_H2O";
    public static final String NU_FUEL = "NU_FUEL";
    public static final String NU_CO2 = "NU_CO2";
    public static final String MW_FUEL = "MW_FUEL";
    public static final String SOOT_YIELD = "SOOT_YIELD";
    public static final String CO_YIELD = "CO_YIELD";
    public static final String EPUMO2 = "EPUMO2";
    public static final String RADIATIVE_FRACTION = "RADIATIVE_FRACTION";
    public static final String FUEL_N2 = "FUEL_N2";
    public static final String Z_CONSTANT = "Z_CONSTANT";
    public static final String X_O2_LL = "X_O2_LL";
    public static final String CRITICAL_FLAME_TEMPERATURE = "CRITICAL_FLAME_TEMPERATURE";
    public static final String MASS_EXTINCTION_COEFFICIENT = "MASS_EXTINCTION_COEFFICIENT";
    public static final String VISIBILITY_FACTOR = "VISIBILITY_FACTOR";
    public static final String BOF = "BOF";
    public static final String DELTAH = "DELTAH";
    public static final String E = "E";
    public static final String FUEL = "FUEL";
    public static final String MAXIMUM_VISIBILITY = "MAXIMUM_VISIBILITY";
    public static final String XNO = "XNO";
    public static final String XNF = "XNF";
    public static final String Y_F_INLET = "Y_F_INLET";
    public static final String Y_O2_INFTY = "Y_O2_INFTY";
    public static final String DEF_NAME = "PROPANE";
    private static final Hashtable s_valueInfo = new Hashtable(24);
    private String d_name;
    private Hashtable d_table;
    public static String DEFAULT_NAME = "Unnamed Reaction";

    private static DoubleValueRange dmr(double d, boolean bl) {
        return DoubleValueRange.createCheckedMin(d, bl);
    }

    private static DoubleValueRange dMr(double d, boolean bl) {
        return DoubleValueRange.createCheckedMax(d, bl);
    }

    private static DoubleValueRange dmMr(double d, double d2, boolean bl, boolean bl2) {
        return DoubleValueRange.createCheckedMinAndMax(d, d2, bl, bl2);
    }

    private static DoubleValueRange dur() {
        return DoubleValueRange.createUncheckedRange();
    }

    public Reaction(String string) {
        this.d_name = string == null || string.equals("") ? DEFAULT_NAME : string;
        this.d_table = new Hashtable();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        Object object3;
        Iterator<Object> iterator;
        Object object4;
        objectInputStream.defaultReadObject();
        if (this.d_table == null) {
            this.d_table = new Hashtable();
        } else {
            object4 = FdsSISystem.getInstance();
            iterator = this.d_table.keySet().iterator();
            object3 = this.d_table.values().iterator();
            while (iterator.hasNext()) {
                ValueInfo valueInfo;
                object2 = (String)iterator.next();
                object = object3.next();
                if (!(object instanceof Double) || (valueInfo = (ValueInfo)s_valueInfo.get(object2)) == null) continue;
                Unit unit = object4.getUnit(valueInfo.d_unitType);
                UnitDouble unitDouble = new UnitDouble((Double)object, unit);
                this.d_table.put(object2, unitDouble);
            }
        }
        if (!(objectInputStream instanceof PyroSimObjectInputStream) || objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 13) {
            object4 = this.d_table.keySet().iterator();
            iterator = this.d_table.values().iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object2 = iterator.next();
                if (!(object2 instanceof UnitDouble) || (object = (ValueInfo)s_valueInfo.get(object3)) == null) continue;
                this.setValue(object3, ((ValueInfo)object).d_valueRange.clampValue((UnitDouble)object2));
            }
        }
    }

    @Override
    public Object clone() {
        Reaction reaction = new Reaction(this.d_name);
        reaction.imprint(this, false);
        return reaction;
    }

    public static ValueInfo getValueInfo(String string) {
        return (ValueInfo)s_valueInfo.get(string);
    }

    public static DoubleValueRange getDoubleVR(String string, UnitSystem unitSystem) {
        ValueInfo valueInfo = Reaction.getValueInfo(string);
        return valueInfo.d_valueRange.getDoubleRange(unitSystem.getUnit(valueInfo.d_unitType));
    }

    public static Collection getOptionalKeySet() {
        return s_valueInfo.keySet();
    }

    public static String[] getOptionalKeys() {
        return s_valueInfo.keySet().toArray(new String[s_valueInfo.size()]);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Reaction)) {
            return false;
        }
        Reaction reaction = (Reaction)object;
        return this.d_name.equals(reaction.d_name) && this.d_table.equals(reaction.d_table);
    }

    @Override
    public String getFDSType() {
        return "REAC";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("REAC");
        Vector<String> vector = new Vector<String>(1);
        vector.add(this.getName());
        fDSInputRecord.setValue(NAME, vector);
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        String[] stringArray = Reaction.getOptionalKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            ValueInfo valueInfo;
            Object object = this.getValue(stringArray[i]);
            if (object == null) continue;
            if (object instanceof UnitDouble && (valueInfo = Reaction.getValueInfo(stringArray[i])) != null) {
                Unit unit = fdsSISystem.getUnit(valueInfo.d_unitType);
                double d = ((UnitDouble)object).getValue(unit);
                object = new Double(d);
            }
            fDSInputRecord.setValue(stringArray[i], object);
        }
        collection.add(fDSInputRecord);
    }

    public String getName() {
        return this.d_name;
    }

    public Task taskSetName(String string) {
        return new AChangePyroDepOnIDTask(this, string, this.getDomains()){

            @Override
            public void setID(String string) {
                Reaction.this.setName(string);
            }
        };
    }

    protected void setName(String string) {
        this.d_name = string;
        this.fireDomainEvent(new ReactionDomainEvent(this, 5), false);
    }

    public Object getValue(Object object) {
        return this.d_table.get(object);
    }

    public void setValue(Object object, Object object2) {
        if (object2 != null) {
            this.d_table.put(object, object2);
            this.fireDomainEvent(new ReactionDomainEvent(this, 5), true);
        }
    }

    public boolean isDefined(Object object) {
        return this.d_table.containsKey(object);
    }

    public void imprint(Reaction reaction) {
        this.imprint(reaction, true);
    }

    public Task taskImprint(Reaction reaction, boolean bl) {
        return new ImprintTask(this, reaction, bl);
    }

    public void imprint(Reaction reaction, boolean bl) {
        this.pauseUpdates(false);
        String[] stringArray = Reaction.getOptionalKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            if (reaction.isDefined(stringArray[i])) {
                this.d_table.put(stringArray[i], reaction.getValue(stringArray[i]));
                continue;
            }
            if (!bl) continue;
            this.d_table.remove(stringArray[i]);
        }
        this.resumeUpdates(new ReactionDomainEvent(this, 5));
    }

    public static Reaction getDefaultReaction() {
        Reaction reaction = new Reaction(DEF_NAME);
        Iterator iterator = s_valueInfo.keySet().iterator();
        Iterator iterator2 = s_valueInfo.values().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ValueInfo valueInfo = (ValueInfo)iterator2.next();
            reaction.setValue(string, valueInfo.d_defaultValue);
        }
        return reaction;
    }

    @Override
    public String getUniqueID() {
        return this.getName();
    }

    @Override
    public String getTypeDescription() {
        return "Reaction";
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    public boolean fireDomainEvent(IDomainEvent iDomainEvent, boolean bl) {
        this.pauseUpdates();
        boolean bl2 = super.fireDomainEvent(iDomainEvent);
        if (bl) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return bl2;
    }

    public void resumeUpdates(IDomainEvent iDomainEvent, boolean bl) {
        super.resumeUpdates(iDomainEvent);
        if (bl) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
    }

    static {
        s_valueInfo.put(NU_O2, new ValueInfo(28, 5.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(NU_H2O, new ValueInfo(28, 4.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(NU_FUEL, new ValueInfo(28, 1.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(NU_CO2, new ValueInfo(28, 3.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(MW_FUEL, new ValueInfo(17, 44.0, Reaction.dmr(0.0, false), Double.class));
        s_valueInfo.put(SOOT_YIELD, new ValueInfo(28, 0.01, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
        s_valueInfo.put(CO_YIELD, new ValueInfo(28, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
        s_valueInfo.put(EPUMO2, new ValueInfo(10, 13100.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(RADIATIVE_FRACTION, new ValueInfo(28, 0.35, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
        s_valueInfo.put(FUEL_N2, new ValueInfo(28, 0.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(Z_CONSTANT, new ValueInfo(28, 1.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(X_O2_LL, new ValueInfo(28, 0.15, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(CRITICAL_FLAME_TEMPERATURE, new ValueInfo(1, 1427.0, Reaction.dur(), Double.class));
        s_valueInfo.put(MASS_EXTINCTION_COEFFICIENT, new ValueInfo(16, 7600.0, Reaction.dmr(0.0, false), Double.class));
        s_valueInfo.put(VISIBILITY_FACTOR, new ValueInfo(28, 3.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(BOF, new ValueInfo(14, Reaction.dur(), Double.class));
        s_valueInfo.put(DELTAH, new ValueInfo(10, 40000.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(E, new ValueInfo(15, Reaction.dur(), Double.class));
        s_valueInfo.put(FUEL, new ValueInfo(28, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(MAXIMUM_VISIBILITY, new ValueInfo(0, 30.0, Reaction.dmr(0.0, true), Double.class));
        s_valueInfo.put(XNO, new ValueInfo(28, 1.0, Reaction.dur(), Double.class));
        s_valueInfo.put(XNF, new ValueInfo(28, 1.0, Reaction.dur(), Double.class));
        s_valueInfo.put(Y_F_INLET, new ValueInfo(28, 1.0, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
        s_valueInfo.put(Y_O2_INFTY, new ValueInfo(28, 0.23, Reaction.dmMr(0.0, 1.0, true, true), Double.class));
    }

    private static class ImprintTask
    implements Task {
        private final Reaction d_target;
        private final Reaction d_holder;
        private final Reaction d_newData;
        private final boolean d_purify;

        public ImprintTask(Reaction reaction, Reaction reaction2, boolean bl) {
            this.d_target = reaction;
            this.d_newData = reaction2;
            this.d_holder = new Reaction(this.d_target.getName());
            this.d_holder.imprint(this.d_target);
            this.d_purify = bl;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            this.d_target.imprint(this.d_holder, true);
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void run() {
            this.d_target.imprint(this.d_newData, this.d_purify);
        }
    }

    public static class ValueInfo {
        public int d_unitType;
        public UnitDouble d_defaultValue;
        public UnitDoubleValueRange d_valueRange;
        public Class d_fdsParsingDataType;

        public ValueInfo(int n, double d, DoubleValueRange doubleValueRange, Class clazz) {
            Unit unit = FdsSISystem.getInstance().getUnit(n);
            this.d_unitType = n;
            this.d_defaultValue = new UnitDouble(d, unit);
            this.d_valueRange = UnitDoubleValueRange.createCheckedRange(doubleValueRange, unit);
            this.d_fdsParsingDataType = clazz;
        }

        public ValueInfo(int n, DoubleValueRange doubleValueRange, Class clazz) {
            Unit unit = FdsSISystem.getInstance().getUnit(n);
            this.d_unitType = n;
            this.d_valueRange = UnitDoubleValueRange.createCheckedRange(doubleValueRange, unit);
            this.d_fdsParsingDataType = clazz;
        }
    }
}

