/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectCollection;
import pyrosim.legacy_2006_2.domain.RasterizationProps;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;

public class RasterizeTask
extends CompositeTask<PyroMod> {
    private final PyroMod d_pyMod;
    private final RasterizationProps d_props;
    private final Collection<? extends FDSObject> d_objs;

    public RasterizeTask(PyroMod pyroMod, Collection<? extends FDSObject> collection, RasterizationProps rasterizationProps) {
        super(pyroMod);
        this.d_pyMod = pyroMod;
        this.d_objs = new Vector<FDSObject>(collection);
        this.d_props = rasterizationProps;
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        if (this.d_props.d_allowDuplicates) {
            this.queueSeparateRast();
        } else {
            this.queueTogetherRast();
        }
    }

    private void queueTogetherRast() {
        FDSRasterization fDSRasterization = new FDSRasterization(null);
        FDSObjectCollection<FDSObject> fDSObjectCollection = new FDSObjectCollection<FDSObject>(this.d_objs, true, FDSObject.class);
        fDSRasterization.addRasters(this.d_pyMod.getGridManager().toCollection());
        fDSRasterization.addObjects(fDSObjectCollection);
        fDSRasterization.rasterizeObjects();
        if (this.d_props.d_keepHierarchy) {
            for (FDSObject fDSObject : fDSObjectCollection) {
                this.queueReplaceWithFrags(fDSObject, fDSRasterization);
            }
        } else {
            ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>(fDSObjectCollection.size());
            for (FDSObject fDSObject : fDSObjectCollection) {
                if (fDSRasterization.getRasterization(fDSObject) == null) continue;
                arrayList.add(fDSObject);
            }
            this.queueReplaceWithFrags(fDSRasterization.getFrags(this.d_props.d_mergeBlocks), arrayList);
        }
    }

    private void queueSeparateRast() {
        FDSRasterization fDSRasterization = new FDSRasterization(null);
        FDSObjectCollection<FDSObject> fDSObjectCollection = new FDSObjectCollection<FDSObject>(this.d_objs, true, FDSObject.class);
        fDSRasterization.addRasters(this.d_pyMod.getGridManager().toCollection());
        if (this.d_props.d_keepHierarchy) {
            for (FDSObject fDSObject : fDSObjectCollection) {
                fDSRasterization.addObject(fDSObject);
                fDSRasterization.rasterizeObjects();
                this.queueReplaceWithFrags(fDSObject, fDSRasterization);
                fDSRasterization.clearObjs();
            }
        } else {
            ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>();
            ArrayList<FDSObject> arrayList2 = new ArrayList<FDSObject>(fDSObjectCollection.size());
            for (FDSObject fDSObject : fDSObjectCollection) {
                if (!fDSRasterization.addObject(fDSObject)) continue;
                arrayList2.add(fDSObject);
                fDSRasterization.rasterizeObjects();
                arrayList.addAll(fDSRasterization.getFrags(this.d_props.d_mergeBlocks));
                fDSRasterization.clearObjs();
            }
            this.queueReplaceWithFrags(arrayList, arrayList2);
        }
    }

    private void queueReplaceWithFrags(Collection<FDSObject> collection, Collection<FDSObject> collection2) {
        FDSComposite fDSComposite = new FDSComposite(this.d_props.d_newParentName);
        FDSComposite fDSComposite2 = FDSComposite.getCommonParentFromRoot(this.d_objs, this.d_pyMod.getObstructions());
        for (FDSObject fDSObject : collection2) {
            FDSComposite fDSComposite3 = fDSObject.getParent();
            this.addTask(fDSComposite3.taskRemove(fDSObject, (FDSObject)null));
        }
        fDSComposite.taskAddAll((Collection<? extends FDSObject>)collection).run();
        this.addTask(fDSComposite2.taskAdd(fDSComposite));
    }

    private boolean queueReplaceWithFrags(FDSObject fDSObject, FDSRasterization fDSRasterization) {
        FDSComposite fDSComposite;
        FDSObjectRasterization fDSObjectRasterization = fDSRasterization.getRasterization(fDSObject);
        if (fDSObjectRasterization == null) {
            return false;
        }
        Collection<FDSObject> collection = fDSObjectRasterization.getFrags(this.d_props.d_mergeBlocks);
        if (collection.isEmpty()) {
            fDSComposite = null;
        } else {
            fDSComposite = new FDSComposite(fDSObject.getName());
            fDSComposite.taskAddAll((Collection<? extends FDSObject>)collection).run();
        }
        FDSComposite fDSComposite2 = fDSObject.getParent();
        this.addTask(fDSComposite2.taskRemove(fDSObject, fDSComposite));
        return true;
    }
}

