/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class RampRecord
implements Serializable,
Cloneable,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    private String d_name;
    private UnitDouble d_t;
    private UnitDouble d_f;
    private int d_tUnit;
    private int d_fUnit;

    public RampRecord(String string, UnitDouble unitDouble, UnitDouble unitDouble2, int n, int n2) {
        this.d_name = string;
        this.d_t = unitDouble;
        this.d_f = unitDouble2;
        this.d_tUnit = n;
        this.d_fUnit = n2;
    }

    public Object clone() throws CloneNotSupportedException {
        RampRecord rampRecord = (RampRecord)super.clone();
        rampRecord.d_t = (UnitDouble)this.d_t.clone();
        rampRecord.d_f = (UnitDouble)this.d_f.clone();
        return rampRecord;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RampRecord)) {
            return false;
        }
        RampRecord rampRecord = (RampRecord)object;
        return rampRecord.d_name.equals(this.getName()) && rampRecord.d_t.equals(this.d_t) && rampRecord.d_f.equals(this.d_f);
    }

    public String getName() {
        return this.d_name;
    }

    public void setName(String string) {
        this.d_name = string;
    }

    public int getTUnit() {
        return this.d_tUnit;
    }

    public int getFUnit() {
        return this.d_fUnit;
    }

    public UnitDouble getT() {
        return this.d_t;
    }

    public UnitDouble getF() {
        return this.d_f;
    }

    @Override
    public String getFDSType() {
        return "RAMP";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("RAMP");
        fDSInputRecord.setValue("ID", this.getName());
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        fDSInputRecord.setValue("T", new Double(this.getT().getValue(fdsSISystem.getUnit(this.d_tUnit))));
        fDSInputRecord.setValue("F", new Double(this.getF().getValue(fdsSISystem.getUnit(this.d_fUnit))));
        collection.add(fDSInputRecord);
    }
}

