/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.RampRecord;
import pyrosim.legacy_2006_2.io.FDSInputRecord;

public class Ramp
implements IFDSRenderable,
Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private String d_name;
    private Collection<RampRecord> d_rampRecords;

    public Ramp(String string, Collection<RampRecord> collection) {
        this.d_name = string;
        this.d_rampRecords = new Vector<RampRecord>(collection.size());
        this.d_rampRecords.addAll(collection);
    }

    public Object clone() throws CloneNotSupportedException {
        Ramp ramp = (Ramp)super.clone();
        Vector<RampRecord> vector = new Vector<RampRecord>(this.d_rampRecords.size());
        for (RampRecord rampRecord : this.d_rampRecords) {
            vector.add((RampRecord)rampRecord.clone());
        }
        ramp.d_rampRecords = vector;
        return ramp;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ramp)) {
            return false;
        }
        Ramp ramp = (Ramp)object;
        if (!this.d_name.equals(ramp.getName())) {
            return false;
        }
        return this.d_rampRecords.equals(ramp.d_rampRecords);
    }

    public String getName() {
        return this.d_name;
    }

    public void setName(String string) {
        this.d_name = string;
        for (RampRecord rampRecord : this.d_rampRecords) {
            rampRecord.setName(this.d_name);
        }
    }

    public Collection<RampRecord> getRecords() {
        return this.d_rampRecords;
    }

    @Override
    public String getFDSType() {
        return "RAMP";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        for (RampRecord rampRecord : this.getRecords()) {
            rampRecord.getInputRecords(collection);
        }
    }
}

