/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class RadiRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    private static final long serialVersionUID = 1L;
    public static final String RADI = "RADI";
    public static final String ANGLE_INCREMENT = "ANGLE_INCREMENT";
    public static final String CH4_BANDS = "CH4_BANDS";
    public static final String KAPPA0 = "KAPPA0";
    public static final String NMIEANG = "NMIEANG";
    public static final String NUMBER_RADIATION_ANGLES = "NUMBER_RADIATION_ANGLES";
    public static final String PATH = "PATH";
    public static final String RADTMP = "RADTMP";
    public static final String TIME_STEP_INCREMENT = "TIME_STEP_INCREMENT";
    public static final String WIDE_BAND_MODEL = "WIDE_BAND_MODEL";
    public static final Map DEFAULT = new Hashtable();
    private final Map d_defaults;
    private final Map d_values;

    public RadiRecord(Map map) {
        this.d_defaults = map;
        this.d_values = new Hashtable(this.d_defaults);
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = this.toRecord();
        if (fDSInputRecord.getKeys().length == 0) {
            return;
        }
        collection.add(this.toRecord());
    }

    public void imprint(RadiRecord radiRecord, boolean bl) {
        if (bl) {
            this.d_values.clear();
            this.d_defaults.clear();
        }
        this.d_values.putAll(radiRecord.d_values);
        this.d_defaults.putAll(radiRecord.d_defaults);
        PyroDomainEvent pyroDomainEvent = new PyroDomainEvent(this, RadiRecord.class, 5);
        this.fireDomainEvent(pyroDomainEvent);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RadiRecord)) {
            return false;
        }
        RadiRecord radiRecord = (RadiRecord)object;
        return this.d_values.equals(radiRecord.d_values) && this.d_defaults.equals(radiRecord.d_defaults);
    }

    public FDSInputRecord toRecord() {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType(RADI);
        this.addIfSet(ANGLE_INCREMENT, fDSInputRecord);
        this.addIfSet(CH4_BANDS, fDSInputRecord);
        this.addIfSet(KAPPA0, fDSInputRecord);
        this.addIfSet(NMIEANG, fDSInputRecord);
        this.addIfSet(NUMBER_RADIATION_ANGLES, fDSInputRecord);
        this.addIfSet(PATH, fDSInputRecord);
        this.addIfSet(RADTMP, fDSInputRecord);
        this.addIfSet(TIME_STEP_INCREMENT, fDSInputRecord);
        this.addIfSet(WIDE_BAND_MODEL, fDSInputRecord);
        return fDSInputRecord;
    }

    public boolean getBool(String string) {
        return (Boolean)this.d_values.get(string);
    }

    public int getInt(String string) {
        return (Integer)this.d_values.get(string);
    }

    public UnitDouble getUD(String string) {
        return (UnitDouble)this.d_values.get(string);
    }

    public RadiRecord set(String string, Object object) {
        this.d_values.put(string, object);
        PyroDomainEvent pyroDomainEvent = new PyroDomainEvent(this, RadiRecord.class, 5);
        this.fireDomainEvent(pyroDomainEvent);
        return this;
    }

    private boolean isSet(String string) {
        return !this.d_values.get(string).equals(this.d_defaults.get(string));
    }

    private FDSInputRecord addIfSet(String string, FDSInputRecord fDSInputRecord) {
        if (this.isSet(string)) {
            Double d;
            if (string.equals(KAPPA0)) {
                Unit unit = FdsSISystem.getInstance().getKappa0Unit();
                d = ((UnitDouble)this.d_values.get(string)).getValue(unit);
            } else if (string.equals(RADTMP)) {
                Unit unit = FdsSISystem.getInstance().getTempUnit();
                d = ((UnitDouble)this.d_values.get(string)).getValue(unit);
            } else if (string.equals(PATH)) {
                Unit unit = FdsSISystem.getInstance().getLengthUnit();
                d = ((UnitDouble)this.d_values.get(string)).getValue(unit);
            } else {
                d = this.d_values.get(string);
            }
            fDSInputRecord.setValue(string, d);
        }
        return fDSInputRecord;
    }

    @Override
    public String getFDSType() {
        return RADI;
    }

    @Override
    public String getTypeDescription() {
        return "RADI Record";
    }

    static {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        DEFAULT.put(ANGLE_INCREMENT, new Integer(5));
        DEFAULT.put(CH4_BANDS, Boolean.FALSE);
        DEFAULT.put(KAPPA0, new UnitDouble(0.0, fdsSISystem.getKappa0Unit()));
        DEFAULT.put(NMIEANG, new Integer(15));
        DEFAULT.put(NUMBER_RADIATION_ANGLES, new Integer(100));
        DEFAULT.put(PATH, new UnitDouble(0.0, fdsSISystem.getLengthUnit()));
        DEFAULT.put(RADTMP, new UnitDouble(900.0, fdsSISystem.getTempUnit()));
        DEFAULT.put(TIME_STEP_INCREMENT, new Integer(3));
        DEFAULT.put(WIDE_BAND_MODEL, Boolean.FALSE);
    }
}

