/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class PipeRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    private static final long serialVersionUID = 1L;
    private UnitDouble d_delay;
    private UnitDouble d_pressure;
    private static final Hashtable<String, ValueRange> d_ranges;

    public PipeRecord(UnitDouble unitDouble, UnitDouble unitDouble2) {
        this.d_delay = unitDouble;
        this.d_pressure = unitDouble2;
    }

    public static ValueRange getValueRange(String string) {
        return d_ranges.get(string);
    }

    public UnitDouble getDelay() {
        return this.d_delay;
    }

    public UnitDouble getPressure() {
        return this.d_pressure;
    }

    @Override
    public String getFDSType() {
        return "PIPE";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("PIPE");
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        Unit unit = fdsSISystem.getTimeUnit();
        if (this.d_delay != null && this.d_delay.getValue(unit) > 0.0) {
            fDSInputRecord.setValue("DELAY", new Double(this.d_delay.getValue(FdsSISystem.getInstance().getTimeUnit())));
        }
        if (this.d_pressure != null) {
            fDSInputRecord.setValue("PRESSURE", new Double(this.d_pressure.getValue(FdsSISystem.getInstance().getPipePressureUnit())));
        }
        if (fDSInputRecord.getKeys().length > 0) {
            collection.add(fDSInputRecord);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PipeRecord)) {
            return false;
        }
        PipeRecord pipeRecord = (PipeRecord)object;
        boolean bl = (this.d_delay == null ? pipeRecord.d_delay == null : this.d_delay.equals(pipeRecord.d_delay)) && (this.d_pressure == null ? pipeRecord.d_pressure == null : this.d_pressure.equals(pipeRecord.d_pressure));
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!(objectInputStream instanceof PyroSimObjectInputStream) || objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 13) {
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            Unit unit = fdsSISystem.getTimeUnit();
            Unit unit2 = fdsSISystem.getPipePressureUnit();
            if (!PipeRecord.getValueRange("DELAY").checkValue(this.d_delay)) {
                this.d_delay = new UnitDouble(0.0, unit);
            }
            if (!PipeRecord.getValueRange("PRESSURE").checkValue(this.d_pressure)) {
                this.d_pressure = new UnitDouble(0.0, unit2);
            }
        }
    }

    @Override
    public String getTypeDescription() {
        return "Pipe Record";
    }

    @Override
    public Object clone() {
        UnitDouble unitDouble = this.d_delay != null ? (UnitDouble)this.d_delay.clone() : null;
        UnitDouble unitDouble2 = this.d_pressure != null ? (UnitDouble)this.d_pressure.clone() : null;
        return new PipeRecord(unitDouble, unitDouble2);
    }

    static {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        Unit unit = fdsSISystem.getTimeUnit();
        Unit unit2 = fdsSISystem.getPipePressureUnit();
        d_ranges = new Hashtable(2);
        d_ranges.put("DELAY", UnitDoubleValueRange.createCheckedMin(new UnitDouble(0.0, unit), true));
        d_ranges.put("PRESSURE", UnitDoubleValueRange.createCheckedMin(new UnitDouble(0.0, unit2), true));
    }
}

