/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class PartRecord
extends ADomainObject<PyroMod>
implements Serializable,
Cloneable,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    public static final String NO_QUANTITY = "none";
    private String d_ID;
    private double d_gamma;
    private int d_sample;
    private int d_initDrop;
    private int d_dropSec;
    private boolean d_massless;
    private boolean d_static;
    private boolean d_fuel;
    private boolean d_water;
    private boolean d_initTempFDS;
    private String d_quantity;
    private String d_quantityScalar;
    private String d_quantityColor;
    private UnitDouble d_udDensity;
    private UnitDouble d_udVapTemp;
    private UnitDouble d_udMeltTemp;
    private UnitDouble d_udSpecHeat;
    private UnitDouble d_udHeatVap;
    private UnitDouble d_udDiameter;
    private UnitDouble d_udHeatCombust;
    private UnitDouble d_udMassVol;
    private UnitDouble d_udAge;
    private UnitDouble d_udInitTemp;
    private static final Hashtable<String, ValueRange> d_ranges;

    public static ValueRange getValueRange(String string) {
        return d_ranges.get(string);
    }

    public PartRecord(String string) {
        this.d_ID = string;
        this.initUDs();
        this.setToDefaults();
    }

    @Override
    public Object clone() {
        PartRecord partRecord = (PartRecord)super.clone();
        partRecord.imprint(this);
        return partRecord;
    }

    public void imprint(Object object) {
        if (!(object instanceof PartRecord)) {
            return;
        }
        this.pauseUpdates(false);
        PartRecord partRecord = (PartRecord)object;
        this.taskSetID(partRecord.d_ID).run();
        this.d_gamma = partRecord.d_gamma;
        this.d_sample = partRecord.d_sample;
        this.d_initDrop = partRecord.d_initDrop;
        this.d_dropSec = partRecord.d_dropSec;
        this.d_massless = partRecord.d_massless;
        this.d_static = partRecord.d_static;
        this.d_fuel = partRecord.d_fuel;
        this.d_water = partRecord.d_water;
        this.d_initTempFDS = partRecord.d_initTempFDS;
        this.d_quantity = partRecord.d_quantity;
        this.d_quantityScalar = partRecord.d_quantityScalar;
        this.d_quantityColor = partRecord.d_quantityColor;
        this.d_udDensity = (UnitDouble)partRecord.d_udDensity.clone();
        this.d_udVapTemp = (UnitDouble)partRecord.d_udVapTemp.clone();
        this.d_udMeltTemp = (UnitDouble)partRecord.d_udMeltTemp.clone();
        this.d_udSpecHeat = (UnitDouble)partRecord.d_udSpecHeat.clone();
        this.d_udHeatVap = (UnitDouble)partRecord.d_udHeatVap.clone();
        this.d_udDiameter = (UnitDouble)partRecord.d_udDiameter.clone();
        this.d_udHeatCombust = (UnitDouble)partRecord.d_udHeatCombust.clone();
        this.d_udMassVol = (UnitDouble)partRecord.d_udMassVol.clone();
        this.d_udAge = (UnitDouble)partRecord.d_udAge.clone();
        this.d_udInitTemp = (UnitDouble)partRecord.d_udInitTemp.clone();
        this.resumeWithEvent(true);
    }

    public void initUDs() {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        this.d_udDensity = new UnitDouble(0.0, fdsSISystem.getDensityUnit());
        this.d_udVapTemp = new UnitDouble(0.0, fdsSISystem.getTempUnit());
        this.d_udMeltTemp = new UnitDouble(0.0, fdsSISystem.getTempUnit());
        this.d_udSpecHeat = new UnitDouble(0.0, fdsSISystem.getSpecHeatUnit());
        this.d_udHeatVap = new UnitDouble(0.0, fdsSISystem.getSpecEnergyUnit());
        this.d_udDiameter = new UnitDouble(0.0, fdsSISystem.getDiameterUnit());
        this.d_udHeatCombust = new UnitDouble(0.0, fdsSISystem.getSpecEnergyUnit());
        this.d_udMassVol = new UnitDouble(0.0, fdsSISystem.getDensityUnit());
        this.d_udAge = new UnitDouble(0.0, fdsSISystem.getTimeUnit());
        this.d_udInitTemp = new UnitDouble(0.0, fdsSISystem.getTempUnit());
    }

    public void setToDefaults() {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        this.pauseUpdates(false);
        this.d_udDensity = new UnitDouble(1000.0, fdsSISystem.getDensityUnit());
        this.d_udVapTemp = new UnitDouble(100.0, fdsSISystem.getTempUnit());
        this.d_udMeltTemp = new UnitDouble(0.0, fdsSISystem.getTempUnit());
        this.d_udSpecHeat = new UnitDouble(4.184, fdsSISystem.getSpecHeatUnit());
        this.d_udHeatVap = new UnitDouble(2259.0, fdsSISystem.getSpecEnergyUnit());
        this.d_udDiameter = new UnitDouble(100.0, fdsSISystem.getDiameterUnit());
        this.d_udHeatCombust = new UnitDouble(0.0, fdsSISystem.getSpecEnergyUnit());
        this.d_udMassVol = new UnitDouble(1.0, fdsSISystem.getDensityUnit());
        this.d_udAge = new UnitDouble(100000.0, fdsSISystem.getTimeUnit());
        this.d_udInitTemp = new UnitDouble(20.0, fdsSISystem.getTempUnit());
        this.d_gamma = 2.4;
        this.d_massless = true;
        this.d_static = false;
        this.d_fuel = false;
        this.d_water = false;
        this.d_sample = 1;
        this.d_quantity = NO_QUANTITY;
        this.d_quantityScalar = "TEMPERATURE";
        this.d_quantityColor = "RED";
        this.d_initDrop = 0;
        this.d_dropSec = 1000;
        this.d_initTempFDS = true;
        this.resumeWithEvent(true);
    }

    public Task taskSetID(String string) {
        return new AChangePyroDepOnIDTask(this, string, this.getDomains()){

            @Override
            public void setID(String string) {
                PartRecord.this.setID(string);
            }
        };
    }

    private void setID(String string) {
        this.d_ID = string;
        this.fireChangeEvent(false);
    }

    public void setDensity(double d, Unit unit) {
        this.d_udDensity = new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setVapTemp(double d, Unit unit) {
        this.d_udVapTemp = new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setMeltTemp(double d, Unit unit) {
        this.d_udMeltTemp = new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setSpecificHeat(double d, Unit unit) {
        this.d_udSpecHeat = new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setHeatVap(double d, Unit unit) {
        this.d_udHeatVap = new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setDiameter(double d, Unit unit) {
        this.d_udDiameter = new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setGamma(double d) {
        this.d_gamma = d;
        this.fireChangeEvent(true);
    }

    public void setMassless(boolean bl) {
        this.d_massless = bl;
        this.fireChangeEvent(true);
    }

    public void setStatic(boolean bl) {
        this.d_static = bl;
        this.fireChangeEvent(true);
    }

    public void setFuel(boolean bl) {
        this.d_fuel = bl;
        this.fireChangeEvent(true);
    }

    public void setHeatCombust(double d, Unit unit) {
        this.d_udHeatCombust = new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setWater(boolean bl) {
        this.d_water = bl;
        this.fireChangeEvent(true);
    }

    public void setSample(int n) {
        this.d_sample = n;
        this.fireChangeEvent(true);
    }

    public void setQuantity(String string) {
        this.d_quantity = string;
        this.fireChangeEvent(true);
    }

    public void setQuantityScalar(String string) {
        this.d_quantityScalar = string;
        this.fireChangeEvent(true);
    }

    public void setQuantityColor(String string) {
        this.d_quantityColor = string;
        this.fireChangeEvent(true);
    }

    public void setInitDrop(int n) {
        this.d_initDrop = n;
        this.fireChangeEvent(true);
    }

    public void setMassVol(double d, Unit unit) {
        this.d_udMassVol = new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setDropSec(int n) {
        this.d_dropSec = n;
        this.fireChangeEvent(true);
    }

    public void setAge(double d, Unit unit) {
        this.d_udAge = new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setInitTemp(double d, Unit unit) {
        this.d_udInitTemp = this.d_udInitTemp == null ? new UnitDouble(d, unit) : new UnitDouble(d, unit);
        this.fireChangeEvent(true);
    }

    public void setInitTemp(UnitDouble unitDouble) {
        this.d_udInitTemp = unitDouble;
        this.fireChangeEvent(true);
    }

    public void setInitTempFDS(boolean bl) {
        this.d_initTempFDS = bl;
        this.fireChangeEvent(true);
    }

    public String getID() {
        return this.d_ID;
    }

    public UnitDouble getDensity() {
        return this.d_udDensity;
    }

    public UnitDouble getVapTemp() {
        return this.d_udVapTemp;
    }

    public UnitDouble getMeltTemp() {
        return this.d_udMeltTemp;
    }

    public UnitDouble getSpecificHeat() {
        return this.d_udSpecHeat;
    }

    public UnitDouble getHeatVap() {
        return this.d_udHeatVap;
    }

    public UnitDouble getDiameter() {
        return this.d_udDiameter;
    }

    public double getGamma() {
        return this.d_gamma;
    }

    public boolean getMassless() {
        return this.d_massless;
    }

    public boolean getStatic() {
        return this.d_static;
    }

    public boolean getFuel() {
        return this.d_fuel;
    }

    public UnitDouble getHeatCombust() {
        return this.d_udHeatCombust;
    }

    public boolean getWater() {
        return this.d_water;
    }

    public int getSample() {
        return this.d_sample;
    }

    public String getQuantity() {
        return this.d_quantity;
    }

    public String getQuantityScalar() {
        return this.d_quantityScalar;
    }

    public String getQuantityColor() {
        return this.d_quantityColor;
    }

    public boolean getInitDropFDS() {
        return this.getInitDrop() > 0 && !this.getMassless();
    }

    public int getInitDrop() {
        return this.d_initDrop;
    }

    public UnitDouble getMassVol() {
        return this.d_udMassVol;
    }

    public int getDropSec() {
        return this.d_dropSec;
    }

    public UnitDouble getAge() {
        return this.d_udAge;
    }

    public UnitDouble getInitTemp() {
        return this.d_udInitTemp;
    }

    public boolean getInitTempFDS() {
        return this.d_initTempFDS;
    }

    @Override
    public String getFDSType() {
        return "PART";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("PART");
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        fDSInputRecord.setValue("ID", this.getID());
        fDSInputRecord.setValue("MASSLESS", new Boolean(this.getMassless()));
        fDSInputRecord.setValue("SAMPLING_FACTOR", new Integer(this.getSample()));
        fDSInputRecord.setValue("AGE", new Double(this.getAge().getValue(fdsSISystem.getTimeUnit())));
        if (!this.getQuantity().equals(NO_QUANTITY)) {
            fDSInputRecord.setValue("QUANTITY", this.getQuantity());
        }
        if (!this.getMassless()) {
            fDSInputRecord.setValue("DENSITY", new Double(this.getDensity().getValue(fdsSISystem.getDensityUnit())));
            fDSInputRecord.setValue("VAPORIZATION_TEMPERATURE", new Double(this.getVapTemp().getValue(fdsSISystem.getTempUnit())));
            fDSInputRecord.setValue("MELTING_TEMPERATURE", new Double(this.getMeltTemp().getValue(fdsSISystem.getTempUnit())));
            fDSInputRecord.setValue("SPECIFIC_HEAT", new Double(this.getSpecificHeat().getValue(fdsSISystem.getSpecHeatUnit())));
            fDSInputRecord.setValue("HEAT_OF_VAPORIZATION", new Double(this.getHeatVap().getValue(fdsSISystem.getSpecEnergyUnit())));
            fDSInputRecord.setValue("DIAMETER", new Double(this.getDiameter().getValue(fdsSISystem.getDiameterUnit())));
            fDSInputRecord.setValue("GAMMA_D", new Double(this.getGamma()));
            fDSInputRecord.setValue("FUEL", new Boolean(this.getFuel()));
            if (this.getFuel()) {
                fDSInputRecord.setValue("HEAT_OF_COMBUSTION", new Double(this.getHeatCombust().getValue(fdsSISystem.getSpecEnergyUnit())));
            }
            fDSInputRecord.setValue("WATER", new Boolean(this.getWater()));
            if (this.getInitDrop() > 0) {
                fDSInputRecord.setValue("STATIC", new Boolean(this.getStatic()));
                fDSInputRecord.setValue("NUMBER_INITIAL_DROPLETS", new Integer(this.getInitDrop()));
                fDSInputRecord.setValue("MASS_PER_VOLUME", new Double(this.getMassVol().getValue(fdsSISystem.getDensityUnit())));
            }
            fDSInputRecord.setValue("DROPLETS_PER_SECOND", new Integer(this.getDropSec()));
            if (!this.getInitTempFDS()) {
                fDSInputRecord.setValue("INITIAL_TEMPERATURE", new Double(this.getInitTemp().getValue(fdsSISystem.getTempUnit())));
            }
        }
        collection.add(fDSInputRecord);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PartRecord) {
            return ((PartRecord)object).d_ID.equals(this.d_ID) && ((PartRecord)object).d_udInitTemp.equals(this.d_udInitTemp) && ((PartRecord)object).d_udDensity.equals(this.d_udDensity) && ((PartRecord)object).d_udVapTemp.equals(this.d_udVapTemp) && ((PartRecord)object).d_udMeltTemp.equals(this.d_udMeltTemp) && ((PartRecord)object).d_udSpecHeat.equals(this.d_udSpecHeat) && ((PartRecord)object).d_udHeatVap.equals(this.d_udHeatVap) && ((PartRecord)object).d_udDiameter.equals(this.d_udDiameter) && ((PartRecord)object).d_gamma == this.d_gamma && ((PartRecord)object).d_udHeatCombust.equals(this.d_udHeatCombust) && ((PartRecord)object).d_sample == this.d_sample && ((PartRecord)object).d_udMassVol.equals(this.d_udMassVol) && ((PartRecord)object).d_initDrop == this.d_initDrop && ((PartRecord)object).d_dropSec == this.d_dropSec && ((PartRecord)object).d_udAge.equals(this.d_udAge) && ((PartRecord)object).d_massless == this.d_massless && ((PartRecord)object).d_static == this.d_static && ((PartRecord)object).d_fuel == this.d_fuel && ((PartRecord)object).d_water == this.d_water && ((PartRecord)object).d_quantity.equals(this.d_quantity) && ((PartRecord)object).d_quantityScalar.equals(this.d_quantityScalar) && ((PartRecord)object).d_quantityColor.equals(this.d_quantityColor) && ((PartRecord)object).d_initTempFDS == this.d_initTempFDS;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.d_ID = (String)getField.get("d_ID", null);
        this.d_gamma = getField.get("d_gamma", 0.0);
        this.d_udAge = (UnitDouble)getField.get("d_udAge", null);
        if (getField.defaulted("d_udAge")) {
            double d = getField.get("d_ageReal", -1.0);
            if (getField.defaulted("d_ageReal")) {
                int n = getField.get("d_age", 0);
                this.d_udAge = new UnitDouble(n, FdsSISystem.getInstance().getTimeUnit());
            } else {
                this.d_udAge = new UnitDouble(d, FdsSISystem.getInstance().getTimeUnit());
            }
        }
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        this.d_udDensity = (UnitDouble)getField.get("d_udDensity", null);
        if (!getField.defaulted("d_udDensity")) {
            this.d_udVapTemp = (UnitDouble)getField.get("d_udVapTemp", null);
            this.d_udMeltTemp = (UnitDouble)getField.get("d_udMeltTemp", null);
            this.d_udSpecHeat = (UnitDouble)getField.get("d_udSpecHeat", null);
            this.d_udHeatVap = (UnitDouble)getField.get("d_udHeatVap", null);
            this.d_udDiameter = (UnitDouble)getField.get("d_udDiameter", null);
            this.d_udHeatCombust = (UnitDouble)getField.get("d_udHeatCombust", null);
            this.d_udMassVol = (UnitDouble)getField.get("d_udMassVol", null);
        } else {
            this.d_udDensity = new UnitDouble(getField.get("d_density", 0.0), fdsSISystem.getDensityUnit());
            this.d_udVapTemp = new UnitDouble(getField.get("d_vapTemp", 0.0), fdsSISystem.getTempUnit());
            this.d_udMeltTemp = new UnitDouble(getField.get("d_meltTemp", 0.0), fdsSISystem.getTempUnit());
            this.d_udSpecHeat = new UnitDouble(getField.get("d_specificHeat", 0.0), fdsSISystem.getSpecHeatUnit());
            this.d_udHeatVap = new UnitDouble(getField.get("d_heatVap", 0.0), fdsSISystem.getSpecEnergyUnit());
            this.d_udDiameter = new UnitDouble(getField.get("d_diameter", 0.0), fdsSISystem.getDiameterUnit());
            this.d_udHeatCombust = new UnitDouble(getField.get("d_heatCombust", 0.0), fdsSISystem.getSpecEnergyUnit());
            this.d_udMassVol = new UnitDouble(getField.get("d_massVol", 0.0), fdsSISystem.getDensityUnit());
        }
        this.d_sample = getField.get("d_sample", 0);
        this.d_initDrop = getField.get("d_initDrop", 0);
        this.d_dropSec = getField.get("d_dropSec", 0);
        this.d_massless = getField.get("d_massless", false);
        this.d_static = getField.get("d_static", false);
        this.d_fuel = getField.get("d_fuel", false);
        this.d_water = getField.get("d_water", false);
        this.d_quantity = (String)getField.get("d_quantity", "");
        this.d_quantityScalar = (String)getField.get("d_quantityScalar", "");
        this.d_quantityColor = (String)getField.get("d_quantityColor", "");
        this.d_udInitTemp = new UnitDouble(0.0, fdsSISystem.getTempUnit());
        if (!(objectInputStream instanceof PyroSimObjectInputStream) || objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 13) {
            PartRecord partRecord = new PartRecord("default");
            if (!PartRecord.getValueRange("NUMBER_INITIAL_DROPLETS").checkValue(this.d_initDrop)) {
                this.d_initDrop = partRecord.d_initDrop;
            }
            if (!PartRecord.getValueRange("DROPLETS_PER_SECOND").checkValue(this.d_dropSec)) {
                this.d_dropSec = partRecord.d_dropSec;
            }
            if (!PartRecord.getValueRange("AGE").checkValue(this.d_udAge)) {
                this.d_udAge = partRecord.d_udAge;
            }
            if (this.d_udDensity != null && !PartRecord.getValueRange("DENSITY").checkValue(this.d_udDensity)) {
                this.d_udDensity = partRecord.d_udDensity;
            }
            if (this.d_udDiameter != null && !PartRecord.getValueRange("DIAMETER").checkValue(this.d_udDiameter)) {
                this.d_udDiameter = partRecord.d_udDiameter;
            }
            if (this.d_udHeatCombust != null && !PartRecord.getValueRange("HEAT_OF_COMBUSTION").checkValue(this.d_udHeatCombust)) {
                this.d_udHeatCombust = partRecord.d_udHeatCombust;
            }
            if (this.d_udHeatVap != null && !PartRecord.getValueRange("HEAT_OF_VAPORIZATION").checkValue(this.d_udHeatVap)) {
                this.d_udHeatVap = partRecord.d_udHeatVap;
            }
            if (this.d_udMassVol != null && !PartRecord.getValueRange("MASS_PER_VOLUME").checkValue(this.d_udMassVol)) {
                this.d_udMassVol = partRecord.d_udMassVol;
            }
            if (this.d_udSpecHeat != null && !PartRecord.getValueRange("SPECIFIC_HEAT").checkValue(this.d_udSpecHeat)) {
                this.d_udSpecHeat = partRecord.d_udSpecHeat;
            }
        }
    }

    @Override
    public String getUniqueID() {
        return this.getID();
    }

    @Override
    public String getTypeDescription() {
        return "Particle";
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    private void fireChangeEvent(boolean bl) {
        this.fireDomainEvent(new PyroDomainEvent(this, PartRecord.class, 5), bl);
    }

    private void resumeWithEvent(boolean bl) {
        this.resumeUpdates(new PyroDomainEvent(this, PartRecord.class, 5), bl);
    }

    public boolean fireDomainEvent(IDomainEvent iDomainEvent, boolean bl) {
        this.pauseUpdates();
        boolean bl2 = super.fireDomainEvent(iDomainEvent);
        if (bl) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return bl2;
    }

    public void resumeUpdates(IDomainEvent iDomainEvent, boolean bl) {
        super.resumeUpdates(iDomainEvent);
        if (bl) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
    }

    static {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        d_ranges = new Hashtable(2);
        d_ranges.put("NUMBER_INITIAL_DROPLETS", IntValueRange.createCheckedMin(0, true));
        d_ranges.put("DROPLETS_PER_SECOND", IntValueRange.createCheckedMin(1, true));
        d_ranges.put("AGE", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), false));
        d_ranges.put("DENSITY", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getDensityUnit(), false));
        d_ranges.put("DIAMETER", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getDiameterUnit(), true));
        d_ranges.put("HEAT_OF_COMBUSTION", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getSpecEnergyUnit(), true));
        d_ranges.put("HEAT_OF_VAPORIZATION", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getSpecEnergyUnit(), true));
        d_ranges.put("MASS_PER_VOLUME", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getDensityUnit(), true));
        d_ranges.put("SPECIFIC_HEAT", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getSpecHeatUnit(), true));
    }
}

