/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class PL3DRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    public static final int MAX_QUANTITIES = 5;
    public static final int MIN_QUANTITIES = 1;
    protected Hashtable d_hQuantities = new Hashtable(5);
    protected UnitDouble d_udDTSam;
    protected boolean d_bEnabled = true;
    protected boolean d_bWriteXYZ = false;
    private static final Hashtable<String, ValueRange> d_ranges;

    public static ValueRange getValueRange(String string) {
        return d_ranges.get(string);
    }

    public PL3DRecord(UnitDouble unitDouble) {
        this.d_hQuantities.put("TEMPERATURE", "TEMPERATURE");
        this.d_hQuantities.put("U-VELOCITY", "U-VELOCITY");
        this.d_hQuantities.put("V-VELOCITY", "V-VELOCITY");
        this.d_hQuantities.put("W-VELOCITY", "W-VELOCITY");
        this.d_hQuantities.put("HRRPUV", "HRRPUV");
        this.d_udDTSam = unitDouble;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if ((!(objectInputStream instanceof PyroSimObjectInputStream) || objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 13) && this.d_udDTSam != null && !PL3DRecord.getValueRange("DTSAM").checkValue(this.d_udDTSam)) {
            this.d_udDTSam = null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PL3DRecord)) {
            return false;
        }
        PL3DRecord pL3DRecord = (PL3DRecord)object;
        boolean bl = this.d_hQuantities.equals(pL3DRecord.d_hQuantities) && this.d_bEnabled == pL3DRecord.d_bEnabled && this.d_bWriteXYZ == pL3DRecord.d_bWriteXYZ && (this.d_udDTSam == null ? pL3DRecord.d_udDTSam == null : this.d_udDTSam.equals(pL3DRecord.d_udDTSam));
        return bl;
    }

    public void setDTSam(UnitDouble unitDouble) {
        this.d_udDTSam = unitDouble;
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
    }

    public UnitDouble getDTSam() {
        return this.d_udDTSam;
    }

    public void setWriteXYZ(boolean bl) {
        this.d_bWriteXYZ = bl;
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
    }

    public boolean getWriteXYZ() {
        return this.d_bWriteXYZ;
    }

    public String[] getQuantities() {
        return this.d_hQuantities.values().toArray(new String[this.d_hQuantities.size()]);
    }

    public boolean addQuantity(String string) {
        String string2 = (String)this.d_hQuantities.get(string);
        if (string2 != null) {
            return false;
        }
        this.d_hQuantities.put(string, string);
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
        return true;
    }

    public boolean removeQuantity(String string) {
        if (this.d_hQuantities.remove(string) == null) {
            return false;
        }
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
        return true;
    }

    public void clearQuantities() {
        this.d_hQuantities.clear();
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
    }

    @Override
    public String getFDSType() {
        return "PL3D";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("PL3D");
        String[] stringArray = this.getQuantities();
        Vector<String> vector = new Vector<String>(this.d_hQuantities.size());
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        fDSInputRecord.setValue("QUANTITIES", vector);
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        if (this.d_udDTSam != null) {
            fDSInputRecord.setValue("DTSAM", new Double(this.d_udDTSam.getValue(fdsSISystem.getTimeUnit())));
        }
        fDSInputRecord.setValue("WRITE_XYZ", new Boolean(this.d_bWriteXYZ));
        collection.add(fDSInputRecord);
    }

    public boolean isEnabled() {
        return this.d_bEnabled;
    }

    public void setEnabled(boolean bl) {
        if (this.d_hQuantities.size() > 0) {
            this.d_bEnabled = bl;
        }
        this.fireDomainEvent(new PyroDomainEvent(this, PL3DRecord.class, 5));
    }

    @Override
    public String getTypeDescription() {
        return "Plot3D Record";
    }

    @Override
    public Object clone() {
        PL3DRecord pL3DRecord = new PL3DRecord(this.d_udDTSam != null ? (UnitDouble)this.d_udDTSam.clone() : null);
        pL3DRecord.d_bEnabled = this.d_bEnabled;
        pL3DRecord.d_bWriteXYZ = this.d_bWriteXYZ;
        pL3DRecord.d_hQuantities = (Hashtable)this.d_hQuantities.clone();
        return pL3DRecord;
    }

    static {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        d_ranges = new Hashtable(2);
        d_ranges.put("DTSAM", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), false));
    }
}

