/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.SelectTask;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;

public class OpenGridsTask
extends CompositeTask {
    private static final String GRID_BOUNDARY_VENT_PARENT = "Grid Boundary Vents";
    private final Collection<? extends Grid> d_grids;
    private final PyroMod d_mediator;

    public OpenGridsTask(PyroMod pyroMod, Collection<? extends Grid> collection) {
        super(pyroMod);
        this.d_grids = collection;
        this.d_mediator = pyroMod;
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        if (this.d_grids.isEmpty()) {
            return;
        }
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        MaterialList materialList = this.d_mediator.getMaterials();
        Material material = materialList.get("OPEN");
        ArrayList<FDSComposite> arrayList = new ArrayList<FDSComposite>(this.d_grids.size());
        for (Grid object : this.d_grids) {
            Cloneable cloneable = object.getMinPoint().getPoint3dValue(unit);
            Point3d point3d = object.getMaxPoint().getPoint3dValue(unit);
            Vent vent = new Vent(new UnitPoint3D(((Point3d)cloneable).x, ((Point3d)cloneable).y, ((Point3d)cloneable).z, unit), new UnitPoint3D(((Point3d)cloneable).x, point3d.y, point3d.z, unit), "Vent Min X for " + object.getName(), material);
            Vent vent2 = new Vent(new UnitPoint3D(point3d.x, ((Point3d)cloneable).y, ((Point3d)cloneable).z, unit), new UnitPoint3D(point3d.x, point3d.y, point3d.z, unit), "Vent Max X for " + object.getName(), material);
            Vent vent3 = new Vent(new UnitPoint3D(((Point3d)cloneable).x, ((Point3d)cloneable).y, ((Point3d)cloneable).z, unit), new UnitPoint3D(point3d.x, ((Point3d)cloneable).y, point3d.z, unit), "Vent Min Y for " + object.getName(), material);
            Vent vent4 = new Vent(new UnitPoint3D(((Point3d)cloneable).x, point3d.y, ((Point3d)cloneable).z, unit), new UnitPoint3D(point3d.x, point3d.y, point3d.z, unit), "Vent Max Y for " + object.getName(), material);
            Vent vent5 = new Vent(new UnitPoint3D(((Point3d)cloneable).x, ((Point3d)cloneable).y, ((Point3d)cloneable).z, unit), new UnitPoint3D(point3d.x, point3d.y, ((Point3d)cloneable).z, unit), "Vent Min Z for " + object.getName(), material);
            Vent vent6 = new Vent(new UnitPoint3D(((Point3d)cloneable).x, ((Point3d)cloneable).y, point3d.z, unit), new UnitPoint3D(point3d.x, point3d.y, point3d.z, unit), "Vent Max Z for " + object.getName(), material);
            vent.setVisible(false);
            vent2.setVisible(false);
            vent3.setVisible(false);
            vent4.setVisible(false);
            vent5.setVisible(false);
            vent6.setVisible(false);
            FDSComposite fDSComposite = new FDSComposite("Vents for " + object.getName());
            fDSComposite.taskAddAll((Collection<? extends FDSObject>)Arrays.asList(vent, vent2, vent3, vent4, vent5, vent6)).run();
            arrayList.add(fDSComposite);
        }
        Object object = null;
        for (Cloneable cloneable : this.d_mediator.getObstructions()) {
            if (!(cloneable instanceof FDSComposite) || !cloneable.getName().equals(GRID_BOUNDARY_VENT_PARENT)) continue;
            object = (FDSComposite)cloneable;
            this.addTask(((FDSComposite)object).taskAddAll((Collection<? extends FDSObject>)arrayList));
            break;
        }
        if (object == null) {
            object = new FDSComposite(GRID_BOUNDARY_VENT_PARENT);
            ((FDSComposite)object).taskAddAll((Collection<? extends FDSObject>)arrayList).run();
            this.addTask(this.d_mediator.getObstructions().taskAdd((FDSObject)object, 0));
        }
        this.addTask(new SelectTask(this.d_mediator, arrayList));
    }
}

