/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.vecmath.Point2d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public abstract class ModelImage
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Point2d d_anchorImage;
    private UnitPoint2D d_anchorModel;
    private Point2d d_aImage;
    private Point2d d_bImage;
    private UnitDouble d_distABModel;
    private UnitDouble d_zLocationModel;
    private float d_opacity = 1.0f;

    public abstract String getID();

    public ModelImage(Point2d point2d, UnitPoint2D unitPoint2D, Point2d point2d2, Point2d point2d3, UnitDouble unitDouble, UnitDouble unitDouble2, float f) {
        this.d_anchorImage = new Point2d(point2d);
        this.d_anchorModel = (UnitPoint2D)unitPoint2D.clone();
        this.d_aImage = new Point2d(point2d2);
        this.d_bImage = new Point2d(point2d3);
        this.d_distABModel = (UnitDouble)unitDouble.clone();
        this.d_zLocationModel = (UnitDouble)unitDouble2.clone();
        this.d_opacity = f;
    }

    public AffineTransform getTransform() {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.d_anchorModel.x.getValue(unit), this.d_anchorModel.y.getValue(unit));
        double d = this.getBackgroundImageScale().getValue(unit);
        affineTransform.scale(d, d);
        affineTransform.translate(-this.d_anchorImage.x, -this.d_anchorImage.y);
        return affineTransform;
    }

    public UnitDouble getBackgroundImageScale() {
        double d = this.d_aImage.distance(this.d_bImage);
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        return new UnitDouble(this.d_distABModel.getValue(unit) / d, unit);
    }

    public String toString() {
        Point2D.Double double_ = this.d_anchorModel.getValue(Geometry.GEOM_LENGTH_UNIT);
        double d = this.d_distABModel.getValue(Geometry.GEOM_LENGTH_UNIT);
        return this.getID() + ";" + this.d_anchorImage + ";" + double_.getX() + "," + double_.getY() + ";" + this.d_aImage + ";" + this.d_bImage + ";" + this.d_zLocationModel + ";" + d + ";" + this.d_opacity;
    }

    public Object clone() {
        try {
            ModelImage modelImage = (ModelImage)super.clone();
            modelImage.d_anchorImage = new Point2d(this.d_anchorImage);
            modelImage.d_anchorModel = (UnitPoint2D)this.d_anchorModel.clone();
            modelImage.d_aImage = new Point2d(this.d_aImage);
            modelImage.d_bImage = new Point2d(this.d_bImage);
            modelImage.d_distABModel = (UnitDouble)this.d_distABModel.clone();
            modelImage.d_zLocationModel = (UnitDouble)this.d_zLocationModel.clone();
            modelImage.d_opacity = this.d_opacity;
            return modelImage;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ModelImage)) {
            return false;
        }
        ModelImage modelImage = (ModelImage)object;
        boolean bl = (modelImage.getID() != null ? modelImage.getID().equals(this.getID()) : this.getID() == null) && (modelImage.d_anchorModel != null ? modelImage.d_anchorModel.equals(this.d_anchorModel) : this.d_anchorModel == null) && (modelImage.d_distABModel != null ? modelImage.d_distABModel.equals(this.d_distABModel) : this.d_distABModel == null) && modelImage.d_anchorImage.equals(this.d_anchorImage) && modelImage.d_aImage.equals(this.d_aImage) && modelImage.d_bImage.equals(this.d_bImage) && modelImage.d_zLocationModel.equals(this.d_zLocationModel) && modelImage.d_opacity == this.d_opacity;
        return bl;
    }

    public int compareTo(Object object) {
        if (!(object instanceof ModelImage)) {
            return 1;
        }
        return ((ModelImage)object).getID().compareTo(this.getID());
    }

    public UnitPoint2D getAnchorModel() {
        return this.d_anchorModel;
    }

    public void setAnchorModel(UnitPoint2D unitPoint2D) {
        this.d_anchorModel = (UnitPoint2D)unitPoint2D.clone();
    }

    public Point2d getAnchorImage() {
        return this.d_anchorImage;
    }

    public void setAnchorImage(Point2d point2d) {
        this.d_anchorImage = new Point2d(point2d);
    }

    public UnitDouble getDistABModel() {
        return this.d_distABModel;
    }

    public void setDistABModel(UnitDouble unitDouble) {
        this.d_distABModel = (UnitDouble)unitDouble.clone();
    }

    public Point2d getAImage() {
        return this.d_aImage;
    }

    public void setAImage(Point2d point2d) {
        this.d_aImage = new Point2d(point2d);
    }

    public Point2d getBImage() {
        return this.d_bImage;
    }

    public void setBImage(Point2d point2d) {
        this.d_bImage = new Point2d(point2d);
    }

    public UnitDouble getZLocationModel() {
        return this.d_zLocationModel;
    }

    public void setZLocationModel(UnitDouble unitDouble) {
        this.d_zLocationModel = (UnitDouble)unitDouble.clone();
    }

    public float getOpacity() {
        return this.d_opacity;
    }

    public void setOpacity(float f) {
        this.d_opacity = f;
    }
}

