/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.Material;

public class MaterialProfile
implements Cloneable {
    private Vector<Prop> d_allProfileProps = new Vector();
    private Hashtable<String, Prop> d_allProfilePropsFast = new Hashtable();
    private Hashtable<String, List> d_profileLists = new Hashtable();
    private Hashtable<String, Prop> d_profileProps = new Hashtable();
    private Vector<MaterialProfile> d_profileGroups = new Vector();
    private Hashtable<String, Object> d_impliedProps = new Hashtable();
    private String d_name;
    private String d_desc;
    private static final MaterialProfile d_defaultProfile = new MaterialProfile("Default Material Profile");
    public static final String DEF_PROFILE_NAME = "Default Material Profile";

    public MaterialProfile(String string) {
        this(string, string);
    }

    public MaterialProfile(String string, String string2) {
        this.d_name = string;
        this.d_desc = string2;
    }

    public String getName() {
        return this.d_name;
    }

    public String getDesc() {
        return this.d_desc;
    }

    public void addImpliedProp(String string, Object object) {
        if (this.d_impliedProps.get(string) != null) {
            this.d_impliedProps.remove(string);
        }
        this.d_impliedProps.put(string, object);
    }

    public Map<String, Object> getImpliedProps() {
        return this.d_impliedProps;
    }

    public void addRequiredMatProp(Prop prop) {
        if (this.d_allProfilePropsFast.get(prop.getName()) == null) {
            this.d_allProfileProps.add(prop);
            this.d_allProfilePropsFast.put(prop.getName(), prop);
            if (prop instanceof List) {
                this.d_profileLists.put(prop.getName(), (List)prop);
            } else {
                this.d_profileProps.put(prop.getName(), prop);
            }
        }
    }

    public void addProfileProps(MaterialProfile materialProfile) {
        int n;
        for (n = 0; n < materialProfile.getRequiredPropCount(); ++n) {
            Prop object2 = materialProfile.getRequiredPropAt(n);
            this.addRequiredMatProp(object2);
        }
        for (n = 0; n < materialProfile.getProfileGroupCount(); ++n) {
            MaterialProfile materialProfile2 = materialProfile.getProfileGroupAt(n);
            this.addProfileGroup(materialProfile2);
        }
        for (String string : materialProfile.d_impliedProps.keySet()) {
            Object object = materialProfile.d_impliedProps.get(string);
            this.addImpliedProp(string, object);
        }
    }

    public void removeProfilePropAt(int n) {
        if (n >= 0 && n < this.d_allProfileProps.size()) {
            String string = this.d_allProfileProps.get(n).getName();
            this.d_allProfileProps.remove(n);
            this.d_allProfilePropsFast.remove(string);
            this.d_profileLists.remove(string);
            this.d_profileProps.remove(string);
        }
    }

    public void removeProfilePropNamed(String string) {
        int n = this.indexOfPropName(string);
        if (n >= 0) {
            this.d_allProfileProps.remove(n);
            this.d_allProfilePropsFast.remove(string);
            this.d_profileLists.remove(string);
            this.d_profileProps.remove(string);
        }
    }

    public int indexOfPropName(String string) {
        if (this.d_allProfilePropsFast.get(string) == null) {
            return -1;
        }
        for (int i = 0; i < this.d_allProfileProps.size(); ++i) {
            if (!this.d_allProfileProps.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsPropNamed(String string) {
        return this.d_allProfilePropsFast.get(string) != null;
    }

    public Prop getRequiredPropNamed(String string) {
        return this.d_allProfilePropsFast.get(string);
    }

    public Prop getRequiredPropAt(int n) {
        if (n >= 0 && n < this.d_allProfileProps.size()) {
            return this.d_allProfileProps.get(n);
        }
        return null;
    }

    public int getRequiredPropCount() {
        return this.d_allProfileProps.size();
    }

    public Map<String, List> getOnlyLists() {
        return this.d_profileLists;
    }

    public Map<String, Prop> getOnlyProps() {
        return this.d_profileProps;
    }

    public void addProfileGroup(MaterialProfile materialProfile) {
        if (!this.d_profileGroups.contains(materialProfile)) {
            this.d_profileGroups.add(materialProfile);
        }
    }

    public void removeProfileGroupAt(int n) {
        if (n >= 0 && n < this.d_profileGroups.size()) {
            this.d_profileGroups.remove(n);
        }
    }

    public MaterialProfile getProfileGroupAt(int n) {
        if (n >= 0 && n < this.d_profileGroups.size()) {
            return this.d_profileGroups.get(n);
        }
        return null;
    }

    public java.util.List<MaterialProfile> getGroups() {
        return this.d_profileGroups;
    }

    public int getProfileGroupCount() {
        return this.d_profileGroups.size();
    }

    public ProfilePath buildBestPathForMat(Material material) {
        ProfMatMatch profMatMatch = new ProfMatMatch();
        return this.buildBestPathForMat(material, profMatMatch);
    }

    public ProfilePath buildBestPathForMat(Material material, ProfMatMatch profMatMatch) {
        Object object;
        Object object3;
        int n;
        ProfilePath profilePath = new ProfilePath(this.d_name);
        String[] stringArray = material.getUsedKeys();
        for (n = 0; n < stringArray.length; ++n) {
            object3 = this.d_profileProps.get(stringArray[n]);
            if (object3 != null) {
                ++profMatMatch.d_maxNumPropsUsedInMaterial;
                continue;
            }
            List object22 = this.d_profileLists.get(stringArray[n]);
            if (object22 == null || !((object = material.getValue(stringArray[n])) instanceof String) || !object22.containsProfileNamed((String)object)) continue;
            ++profMatMatch.d_maxNumPropsUsedInMaterial;
        }
        profMatMatch.d_maxNumPropsUsedInMaterial += this.getNumMatchingImpliedProps(material);
        profMatMatch.d_numPropsInMaxPath += this.d_impliedProps.size();
        profMatMatch.d_numPropsInMaxPath += this.d_profileProps.size();
        for (n = 0; n < this.d_profileGroups.size(); ++n) {
            object3 = this.d_profileGroups.get(n);
            ProfilePath profilePath2 = ((MaterialProfile)object3).buildBestPathForMat(material, profMatMatch);
            profilePath.addGroupPath(((MaterialProfile)object3).getName(), profilePath2);
        }
        Set<String> set = Material.getValueNames();
        for (List list : this.d_profileLists.values()) {
            object = null;
            boolean bl = false;
            if (set.contains(list.getName())) {
                ++profMatMatch.d_numPropsInMaxPath;
                object = material.getValue(list.getName());
                if (object == null) {
                    bl = true;
                }
            }
            ProfilePath profilePath3 = null;
            int n2 = 0;
            ProfMatMatch profMatMatch2 = null;
            for (int i = 0; i < list.getProfileCount(); ++i) {
                MaterialProfile materialProfile = list.getProfile(i);
                if (object == null || object != null && materialProfile.getName().equals(object)) {
                    int n3 = materialProfile.getNumMatchingImpliedProps(material);
                    ProfMatMatch profMatMatch3 = new ProfMatMatch();
                    ProfilePath profilePath4 = materialProfile.buildBestPathForMat(material, profMatMatch3);
                    if (profMatMatch2 == null || profMatMatch3.d_maxNumPropsUsedInMaterial > profMatMatch2.d_maxNumPropsUsedInMaterial) {
                        profilePath3 = profilePath4;
                        profMatMatch2 = profMatMatch3;
                        n2 = n3;
                    } else if (profMatMatch3.d_maxNumPropsUsedInMaterial == profMatMatch2.d_maxNumPropsUsedInMaterial) {
                        double d;
                        double d2 = profMatMatch3.getIndex();
                        if (d2 > (d = profMatMatch2.getIndex())) {
                            profilePath3 = profilePath4;
                            profMatMatch2 = profMatMatch3;
                            n2 = n3;
                        } else if (d2 == d && n3 > n2) {
                            profilePath3 = profilePath4;
                            profMatMatch2 = profMatMatch3;
                            n2 = n3;
                        }
                    }
                }
                if (i == 0 && bl) break;
            }
            if (profilePath3 == null) continue;
            profilePath.addPath(list.getName(), profilePath3);
            profMatMatch.addMatchIndex(profMatMatch2);
        }
        return profilePath;
    }

    public int getNumMatchingImpliedProps(Material material) {
        int n = 0;
        String[] stringArray = material.getUsedKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.d_impliedProps.get(stringArray[i]);
            if (object == null || !object.equals(material.getValue(stringArray[i]))) continue;
            ++n;
        }
        return n;
    }

    public Object clone() {
        MaterialProfile materialProfile = new MaterialProfile(this.d_name, this.d_desc);
        for (int i = 0; i < this.d_allProfileProps.size(); ++i) {
            materialProfile.addRequiredMatProp(this.d_allProfileProps.get(i));
        }
        materialProfile.d_profileGroups = (Vector)this.d_profileGroups.clone();
        materialProfile.d_impliedProps = (Hashtable)this.d_impliedProps.clone();
        return materialProfile;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MaterialProfile)) {
            return false;
        }
        MaterialProfile materialProfile = (MaterialProfile)object;
        return materialProfile.d_name.equals(this.d_name);
    }

    public static MaterialProfile getDefaultProfile() {
        return d_defaultProfile;
    }

    private static List getBuiltinProfiles() {
        List list = new List("Surface Type");
        new Prop("ADIABATIC", "Adiabatic");
        Prop prop = new Prop("ALPHA", "Diffusivity");
        Prop prop2 = new Prop("A", "Pre-exponential Factor");
        Prop prop3 = new Prop("BACKING", "Backing");
        Prop prop4 = new Prop("BURN_AWAY", "Allow Surface to Burn Away");
        Prop prop5 = new Prop("BURNING_RATE_MAX", "Maximum Burning Rate");
        Prop prop6 = new Prop("C_DELTA_RHO", "C*Delta*Rho");
        Prop prop7 = new Prop("C_P", "Specific Heat");
        Prop prop8 = new Prop("C_P_CHAR", "Specific Heat of Char");
        Prop prop9 = new Prop("CHAR_DENSITY", "Char Density");
        Prop prop10 = new Prop("DELTA", "Wall Thickness");
        Prop prop11 = new Prop("DENSITY", "Density");
        Prop prop12 = new Prop("DX_SOLID", "First Cell Thickness");
        Prop prop13 = new Prop("E", "Activation Energy");
        Prop prop14 = new Prop("E_COEFFICIENT", "Extinguishing Coefficient");
        Prop prop15 = new Prop("EMISSIVITY", "Emissivity");
        Prop prop16 = new Prop("FUEL_FRACTION", "Fuel Fraction");
        Prop prop17 = new Prop("HEAT_FLUX", "Heat Flux");
        Prop prop18 = new Prop("HEAT_OF_COMBUSTION", "Heat of Combustion");
        Prop prop19 = new Prop("HEAT_OF_VAPORIZATION", "Heat of Vaporization");
        Prop prop20 = new Prop("HRRPUA", "Heat Release Rate (HRR)");
        Prop prop21 = new Prop("KS", "Thermal Conductivity");
        Prop prop22 = new Prop("KS_CHAR", "Thermal Conductivity of Char");
        new Prop("LEAKING", "Leaking");
        Prop prop23 = new Prop("MASS_FLUX_CRITICAL", "Mass Flux at Ignition Temperature");
        Prop prop24 = new Prop("MOISTURE_FRACTION", "Water Content by Mass");
        Prop prop25 = new Prop("NPPC", "Number of Particles Per Cell");
        Prop prop26 = new Prop("PARTICLES", "Emit the Default Particle");
        Prop prop27 = new Prop("PART_ID", "Emit a Custom Particle");
        new Prop("PHASE", "Phase");
        Prop prop28 = new Prop("PLE", "Atmospheric Profile Exponent");
        Prop prop29 = new Prop("POROSITY", "Porosity Fraction");
        new Prop("PROFILE", "Velocity Profile");
        Prop prop30 = new Prop("RAMP_C_P", "Apply Ramp to Specific Heat");
        Prop prop31 = new Prop("RAMP_C_P_CHAR", "Apply Ramp to Specific Heat of Char");
        Prop prop32 = new Prop("RAMP_KS", "Apply Ramp to Thermal Conductivity");
        Prop prop33 = new Prop("RAMP_KS_CHAR", "Apply Ramp to Thermal Conductivity of Char");
        Prop prop34 = new Prop("RAMP_Q", "Apply Ramp to Heat Release Rate");
        Prop prop35 = new Prop("RAMP_V", "Apply Ramp to Velocity");
        Prop prop36 = new Prop("SURFACE_DENSITY", "Surface Density");
        Prop prop37 = new Prop("TAU_Q", "HRR Ramp-up Time");
        Prop prop38 = new Prop("TAU_V", "Velocity Ramp-up Time");
        Prop prop39 = new Prop("TMPIGN", "Ignition Temperature");
        Prop prop40 = new Prop("TMPWAL", "Surface Temperature");
        Prop prop41 = new Prop("TMPWAL0", "Initial Surface Temperature");
        Prop prop42 = new Prop("VBC", "Velocity Slip Index");
        Prop prop43 = new Prop("VEL", "Normal Velocity");
        Prop prop44 = new Prop("VEL_T", "Tangential Velocity");
        Prop prop45 = new Prop("VOLUME_FLUX", "Volume Flux");
        Prop prop46 = new Prop("WALL_POINTS", "Internal Wall Points");
        Prop prop47 = new Prop("Z0", "Atmospheric Profile Origin");
        MaterialProfile materialProfile = new MaterialProfile("Fixed Temperature");
        materialProfile.addRequiredMatProp(prop40);
        MaterialProfile materialProfile2 = new MaterialProfile("Fixed Heat Flux");
        materialProfile2.addRequiredMatProp(prop17);
        MaterialProfile materialProfile3 = new MaterialProfile("Thermally Thick");
        materialProfile3.addRequiredMatProp(prop41);
        materialProfile3.addRequiredMatProp(prop21);
        materialProfile3.addRequiredMatProp(prop32);
        materialProfile3.addRequiredMatProp(prop7);
        materialProfile3.addRequiredMatProp(prop30);
        materialProfile3.addRequiredMatProp(prop10);
        materialProfile3.addRequiredMatProp(prop11);
        materialProfile3.addRequiredMatProp(prop36);
        materialProfile3.addRequiredMatProp(prop);
        materialProfile3.addRequiredMatProp(prop46);
        materialProfile3.addRequiredMatProp(prop12);
        MaterialProfile materialProfile4 = new MaterialProfile("Thermally Thick");
        materialProfile4.addProfileProps(materialProfile3);
        materialProfile4.addRequiredMatProp(prop4);
        MaterialProfile materialProfile5 = new MaterialProfile("Thermally Thick");
        materialProfile5.addProfileProps(materialProfile4);
        materialProfile5.addRequiredMatProp(prop39);
        MaterialProfile materialProfile6 = new MaterialProfile("Thermally Thick");
        materialProfile6.addRequiredMatProp(prop22);
        materialProfile6.addRequiredMatProp(prop33);
        materialProfile6.addRequiredMatProp(prop8);
        materialProfile6.addRequiredMatProp(prop31);
        materialProfile6.addRequiredMatProp(prop9);
        materialProfile6.addRequiredMatProp(prop46);
        materialProfile6.addRequiredMatProp(prop12);
        materialProfile6.addRequiredMatProp(prop4);
        MaterialProfile materialProfile7 = new MaterialProfile("Thermally Thin");
        materialProfile7.addRequiredMatProp(prop41);
        materialProfile7.addRequiredMatProp(prop6);
        materialProfile7.addRequiredMatProp(prop7);
        materialProfile7.addRequiredMatProp(prop30);
        materialProfile7.addRequiredMatProp(prop10);
        materialProfile7.addRequiredMatProp(prop11);
        materialProfile7.addRequiredMatProp(prop36);
        MaterialProfile materialProfile8 = new MaterialProfile("Thermally Thin");
        materialProfile8.addProfileProps(materialProfile7);
        materialProfile8.addRequiredMatProp(prop4);
        MaterialProfile materialProfile9 = new MaterialProfile("Thermally Thin");
        materialProfile9.addProfileProps(materialProfile8);
        materialProfile9.addRequiredMatProp(prop39);
        MaterialProfile materialProfile10 = new MaterialProfile("Particles");
        materialProfile10.addRequiredMatProp(prop25);
        materialProfile10.addRequiredMatProp(prop26);
        materialProfile10.addRequiredMatProp(prop27);
        MaterialProfile materialProfile11 = new MaterialProfile("Burner Fire");
        materialProfile11.addRequiredMatProp(prop20);
        materialProfile11.addRequiredMatProp(prop37);
        materialProfile11.addRequiredMatProp(prop34);
        materialProfile11.addRequiredMatProp(prop18);
        materialProfile11.addRequiredMatProp(prop16);
        materialProfile11.addRequiredMatProp(prop14);
        materialProfile11.addRequiredMatProp(prop29);
        materialProfile11.addProfileGroup(materialProfile10);
        materialProfile11.addImpliedProp("PHASE", "SOLID");
        MaterialProfile materialProfile12 = new MaterialProfile("Flammable Solid (Constant HRR)");
        materialProfile12.addRequiredMatProp(prop20);
        materialProfile12.addRequiredMatProp(prop37);
        materialProfile12.addRequiredMatProp(prop34);
        materialProfile12.addRequiredMatProp(prop18);
        materialProfile12.addRequiredMatProp(prop16);
        materialProfile12.addRequiredMatProp(prop14);
        materialProfile12.addRequiredMatProp(prop29);
        MaterialProfile materialProfile13 = new MaterialProfile("Boundary Conditions");
        List list2 = new List("Boundary Type");
        list2.addMaterialProfile(materialProfile);
        list2.addMaterialProfile(materialProfile2);
        list2.addMaterialProfile(materialProfile5);
        list2.addMaterialProfile(materialProfile9);
        materialProfile13.addRequiredMatProp(list2);
        materialProfile12.addProfileGroup(materialProfile13);
        materialProfile12.addProfileGroup(materialProfile10);
        materialProfile12.addImpliedProp("PHASE", "SOLID");
        MaterialProfile materialProfile14 = new MaterialProfile("Flammable Solid");
        materialProfile14.addRequiredMatProp(prop19);
        materialProfile14.addRequiredMatProp(prop18);
        materialProfile14.addRequiredMatProp(prop5);
        materialProfile14.addRequiredMatProp(prop16);
        materialProfile14.addRequiredMatProp(prop15);
        materialProfile14.addRequiredMatProp(prop3);
        MaterialProfile materialProfile15 = new MaterialProfile("Boundary Conditions");
        List list3 = new List("Boundary Type");
        MaterialProfile materialProfile16 = new MaterialProfile("Fixed Temperature");
        materialProfile16.addProfileProps(materialProfile);
        materialProfile16.addRequiredMatProp(new Prop("TAU_Q", "Temperature Ramp-up Time"));
        materialProfile16.addRequiredMatProp(new Prop("RAMP_Q", "Apply Ramp to Surface Temperature"));
        list3.addMaterialProfile(materialProfile16);
        list3.addMaterialProfile(materialProfile2);
        list3.addMaterialProfile(materialProfile5);
        list3.addMaterialProfile(materialProfile9);
        materialProfile15.addRequiredMatProp(list3);
        materialProfile14.addProfileGroup(materialProfile15);
        materialProfile14.addProfileGroup(materialProfile10);
        materialProfile14.addImpliedProp("PHASE", "SOLID");
        MaterialProfile materialProfile17 = new MaterialProfile("Non-Flammable Solid");
        materialProfile17.addRequiredMatProp(prop15);
        materialProfile17.addRequiredMatProp(prop3);
        MaterialProfile materialProfile18 = new MaterialProfile("Boundary Conditions");
        List list4 = new List("Boundary Type");
        MaterialProfile materialProfile19 = new MaterialProfile("Fixed Temperature");
        materialProfile19.addProfileProps(materialProfile);
        materialProfile19.addRequiredMatProp(new Prop("TAU_Q", "Temperature Ramp-up Time"));
        materialProfile19.addRequiredMatProp(new Prop("RAMP_Q", "Apply Ramp to Surface Temperature"));
        list4.addMaterialProfile(materialProfile19);
        list4.addMaterialProfile(materialProfile2);
        list4.addMaterialProfile(materialProfile3);
        list4.addMaterialProfile(materialProfile7);
        materialProfile18.addRequiredMatProp(list4);
        materialProfile17.addProfileGroup(materialProfile18);
        materialProfile17.addProfileGroup(materialProfile10);
        materialProfile17.addImpliedProp("PHASE", "SOLID");
        MaterialProfile materialProfile20 = new MaterialProfile("Liquid Fuel");
        materialProfile20.addRequiredMatProp(prop19);
        materialProfile20.addRequiredMatProp(prop18);
        materialProfile20.addRequiredMatProp(prop5);
        materialProfile20.addRequiredMatProp(prop16);
        materialProfile20.addRequiredMatProp(prop15);
        materialProfile20.addRequiredMatProp(prop3);
        MaterialProfile materialProfile21 = new MaterialProfile("Boundary Conditions");
        materialProfile21.addProfileProps(materialProfile4);
        materialProfile21.addRequiredMatProp(new Prop("TMPIGN", "Boiling Temperature"));
        materialProfile20.addProfileGroup(materialProfile21);
        materialProfile20.addProfileGroup(materialProfile10);
        materialProfile20.addImpliedProp("PHASE", "LIQUID");
        MaterialProfile materialProfile22 = new MaterialProfile("Charring Fuel");
        materialProfile22.addRequiredMatProp(prop19);
        materialProfile22.addRequiredMatProp(prop18);
        materialProfile22.addRequiredMatProp(prop5);
        materialProfile22.addRequiredMatProp(prop16);
        materialProfile22.addRequiredMatProp(prop15);
        materialProfile22.addRequiredMatProp(prop3);
        materialProfile22.addRequiredMatProp(prop2);
        materialProfile22.addRequiredMatProp(prop13);
        materialProfile22.addRequiredMatProp(prop23);
        materialProfile22.addRequiredMatProp(prop39);
        MaterialProfile materialProfile23 = new MaterialProfile("Virgin Boundary Conditions");
        materialProfile23.addRequiredMatProp(prop21);
        materialProfile23.addRequiredMatProp(prop32);
        materialProfile23.addRequiredMatProp(prop7);
        materialProfile23.addRequiredMatProp(prop30);
        materialProfile23.addRequiredMatProp(prop10);
        materialProfile23.addRequiredMatProp(prop11);
        materialProfile23.addRequiredMatProp(prop36);
        materialProfile23.addRequiredMatProp(prop);
        materialProfile23.addRequiredMatProp(prop24);
        materialProfile22.addProfileGroup(materialProfile23);
        MaterialProfile materialProfile24 = new MaterialProfile("Char Boundary Conditions");
        materialProfile24.addProfileProps(materialProfile6);
        materialProfile22.addProfileGroup(materialProfile24);
        materialProfile22.addProfileGroup(materialProfile10);
        materialProfile22.addImpliedProp("PHASE", "CHAR");
        MaterialProfile materialProfile25 = new MaterialProfile("Liquid Thermoplastic");
        materialProfile25.addRequiredMatProp(prop19);
        materialProfile25.addRequiredMatProp(prop18);
        materialProfile25.addRequiredMatProp(prop5);
        materialProfile25.addRequiredMatProp(prop16);
        materialProfile25.addRequiredMatProp(prop15);
        materialProfile25.addRequiredMatProp(prop3);
        materialProfile25.addRequiredMatProp(prop2);
        materialProfile25.addRequiredMatProp(prop13);
        materialProfile25.addRequiredMatProp(prop23);
        materialProfile25.addRequiredMatProp(prop39);
        MaterialProfile materialProfile26 = new MaterialProfile("Boundary Conditions");
        List list5 = new List("Boundary Type");
        list5.addMaterialProfile(materialProfile4);
        list5.addMaterialProfile(materialProfile8);
        materialProfile26.addRequiredMatProp(list5);
        materialProfile25.addProfileGroup(materialProfile26);
        materialProfile25.addProfileGroup(materialProfile10);
        materialProfile25.addImpliedProp("PHASE", "LIQUID");
        MaterialProfile materialProfile27 = new MaterialProfile("Charring Thermoplastic");
        materialProfile27.addProfileProps(materialProfile25);
        materialProfile27.addImpliedProp("PHASE", "CHAR");
        MaterialProfile materialProfile28 = new MaterialProfile("Fan/Wind");
        materialProfile28.addRequiredMatProp(new Prop("TMPWAL", "Air Temperature"));
        materialProfile28.addRequiredMatProp(new Prop("TAU_Q", "Temperature Ramp-up Time"));
        materialProfile28.addRequiredMatProp(new Prop("RAMP_Q", "Apply Ramp to Air Temperature"));
        MaterialProfile materialProfile29 = new MaterialProfile("Air Flow");
        materialProfile29.addRequiredMatProp(prop43);
        materialProfile29.addRequiredMatProp(prop45);
        materialProfile29.addRequiredMatProp(prop44);
        materialProfile29.addRequiredMatProp(prop38);
        materialProfile29.addRequiredMatProp(prop35);
        materialProfile29.addRequiredMatProp(prop42);
        List list6 = new List("PROFILE", "Wind Profile");
        MaterialProfile materialProfile30 = new MaterialProfile("TOP_HAT", "Top Hat (Default)");
        MaterialProfile materialProfile31 = new MaterialProfile("PARABOLIC", "Parabolic");
        MaterialProfile materialProfile32 = new MaterialProfile("ATMOSPHERIC", "Atmospheric");
        materialProfile32.addRequiredMatProp(prop28);
        materialProfile32.addRequiredMatProp(prop47);
        list6.addMaterialProfile(materialProfile30);
        list6.addMaterialProfile(materialProfile31);
        list6.addMaterialProfile(materialProfile32);
        materialProfile29.addRequiredMatProp(list6);
        materialProfile28.addProfileGroup(materialProfile29);
        materialProfile28.addProfileGroup(materialProfile10);
        materialProfile28.addImpliedProp("PHASE", "SOLID");
        MaterialProfile materialProfile33 = new MaterialProfile("Adiabatic");
        materialProfile33.addImpliedProp("ADIABATIC", Boolean.TRUE);
        materialProfile33.addImpliedProp("PHASE", "SOLID");
        MaterialProfile materialProfile34 = new MaterialProfile("Inert");
        list.addMaterialProfile(materialProfile34);
        list.addMaterialProfile(materialProfile33);
        list.addMaterialProfile(materialProfile11);
        list.addMaterialProfile(materialProfile28);
        list.addMaterialProfile(materialProfile14);
        list.addMaterialProfile(materialProfile12);
        list.addMaterialProfile(materialProfile17);
        list.addMaterialProfile(materialProfile20);
        list.addMaterialProfile(materialProfile22);
        list.addMaterialProfile(materialProfile25);
        list.addMaterialProfile(materialProfile27);
        return list;
    }

    static {
        d_defaultProfile.addRequiredMatProp(MaterialProfile.getBuiltinProfiles());
    }

    public static interface GroupsChangedListener {
        public void groupsChanged(Collection var1);
    }

    public static class List
    extends Prop
    implements Cloneable {
        private Vector<MaterialProfile> d_list = new Vector();

        public List(String string) {
            super(string, string);
        }

        public List(String string, String string2) {
            super(string, string2);
        }

        public void addMaterialProfile(MaterialProfile materialProfile) {
            this.d_list.add(materialProfile);
        }

        public MaterialProfile getProfile(int n) {
            if (n >= 0 && n < this.d_list.size()) {
                return this.d_list.get(n);
            }
            return null;
        }

        public int getProfileCount() {
            return this.d_list.size();
        }

        public MaterialProfile getProfile(String string) {
            for (MaterialProfile materialProfile : this.d_list) {
                if (!materialProfile.getName().equals(string)) continue;
                return materialProfile;
            }
            return null;
        }

        public boolean containsProfileNamed(String string) {
            return this.getProfile(string) != null;
        }

        @Override
        public Object clone() {
            List list = (List)super.clone();
            list.d_list = (Vector)this.d_list.clone();
            return list;
        }
    }

    public static class Prop {
        public String d_propName;
        public String d_propDesc;

        public Prop(String string, String string2) {
            this.d_propName = string;
            this.d_propDesc = string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Prop)) {
                return false;
            }
            Prop prop = (Prop)object;
            return this.d_propName.equals(prop.d_propName);
        }

        public String getName() {
            return this.d_propName;
        }

        public String getDesc() {
            return this.d_propDesc;
        }

        public Object clone() {
            return new Prop(this.d_propName, this.d_propDesc);
        }
    }

    public static class ProfMatMatch {
        public int d_maxNumPropsUsedInMaterial = 0;
        public int d_numPropsInMaxPath = 0;

        public void addMatchIndex(ProfMatMatch profMatMatch) {
            this.d_maxNumPropsUsedInMaterial += profMatMatch.d_maxNumPropsUsedInMaterial;
            this.d_numPropsInMaxPath += profMatMatch.d_numPropsInMaxPath;
        }

        public double getIndex() {
            if (this.d_maxNumPropsUsedInMaterial >= this.d_numPropsInMaxPath) {
                return 1.0;
            }
            if (this.d_numPropsInMaxPath == 0 || this.d_maxNumPropsUsedInMaterial == 0) {
                return 0.0;
            }
            return (double)this.d_maxNumPropsUsedInMaterial / (double)this.d_numPropsInMaxPath;
        }
    }

    public static class ProfilePath
    implements Serializable {
        static final long serialVersionUID = 3391078738835676198L;
        private String d_profileName;
        private Map<String, ProfilePath> d_listPaths = new Hashtable<String, ProfilePath>();
        private Map<String, ProfilePath> d_groupPaths = new Hashtable<String, ProfilePath>();

        public ProfilePath(String string) {
            this.d_profileName = string;
        }

        public void addPath(String string, ProfilePath profilePath) {
            this.d_listPaths.put(string, profilePath);
        }

        public void addGroupPath(String string, ProfilePath profilePath) {
            this.d_groupPaths.put(string, profilePath);
        }

        public String getProfileName() {
            return this.d_profileName;
        }

        public Map<String, ProfilePath> getListPaths() {
            return this.d_listPaths;
        }

        public Map<String, ProfilePath> getGroupPaths() {
            return this.d_groupPaths;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String string) {
            ProfilePath profilePath;
            String string2 = "::" + this.d_profileName + "::\n";
            for (String string3 : this.d_listPaths.keySet()) {
                profilePath = this.d_listPaths.get(string3);
                string2 = string2 + string + "List: " + string3 + "->" + profilePath.toString(string + "  ") + "\n";
            }
            for (String string3 : this.d_groupPaths.keySet()) {
                profilePath = this.d_groupPaths.get(string3);
                string2 = string2 + string + "Group: " + profilePath.toString(string + "  ") + "\n";
            }
            return string2;
        }

        public void initMat(Material material, Set<String> set) {
            MaterialProfile materialProfile = MaterialProfile.getDefaultProfile();
            this.conformMatRecursive(material, materialProfile, set);
            material.setProfilePath(this);
        }

        private void conformMatRecursive(Material material, MaterialProfile materialProfile, Set<String> set) {
            Object object;
            if (!this.getProfileName().equals(materialProfile.getName())) {
                System.out.println("Invalid profile name for Material " + material.getName());
                return;
            }
            Iterator<String> iterator = materialProfile.getImpliedProps().keySet().iterator();
            for (Object object22 : materialProfile.getImpliedProps().values()) {
                object = iterator.next();
                this.setMatValue(material, (String)object, object22, set);
            }
            for (Prop prop : materialProfile.getOnlyProps().values()) {
                object = Material.getDefaultValue(prop.getName());
                this.setMatValue(material, prop.getName(), object, set);
            }
            for (MaterialProfile materialProfile2 : materialProfile.getGroups()) {
                object = this.d_groupPaths.get(materialProfile2.getName());
                if (object == null) continue;
                super.conformMatRecursive(material, materialProfile2, set);
            }
            Set<String> set2 = Material.getValueNames();
            Iterator<String> iterator2 = this.d_listPaths.keySet().iterator();
            for (ProfilePath profilePath : this.d_listPaths.values()) {
                Object object2;
                String string = iterator2.next();
                List list = materialProfile.getOnlyLists().get(string);
                if (list == null) {
                    System.out.println("Invalid profile list for Material " + material.getName());
                    continue;
                }
                if (set2.contains(string)) {
                    object2 = Material.getDefaultValue(string);
                    this.setMatValue(material, string, object2, set);
                }
                if ((object2 = list.getProfile(profilePath.getProfileName())) == null) {
                    System.out.println("Invalid profile for list for Material " + material.getName());
                    continue;
                }
                profilePath.conformMatRecursive(material, (MaterialProfile)object2, set);
            }
        }

        private void setMatValue(Material material, String string, Object object, Set<String> set) {
            if (Material.isValueSetByDefault(string)) {
                material.setValue(string, object);
            }
            set.add(string);
        }
    }
}

