/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddAtIndexTask;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.APyroManReplaceDepOnTask;
import pyrosim.legacy_2006_2.events.MaterialDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class MaterialList
extends APyroDomainManager<String, Material>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SortedSet<Material> d_mats = new TreeSet<Material>(new LinOrd());

    public MaterialList() {
        this.initPreDefs();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Object object = getField.get("d_mats", null);
        if (object instanceof List) {
            this.d_mats = new TreeSet<Material>(new LinOrd());
            this.initPreDefs();
            for (Material material : (List)object) {
                this.add(material);
            }
        } else {
            this.d_mats = (SortedSet)object;
        }
    }

    @Override
    public Collection<Material> toCollection() {
        return new PyroCollection<String, Material>(this);
    }

    private void initPreDefs() {
        for (Material material : Material.getPredefinedMaterials()) {
            this.d_mats.add(material);
        }
    }

    public MaterialList(MaterialList materialList) {
        this();
        this.absorb(materialList);
    }

    public static MaterialList fromLegacy(pyrosim.legacy_2006_2.legacy.MaterialList materialList) {
        MaterialList materialList2 = new MaterialList();
        MaterialList materialList3 = materialList.getNewParent();
        if (materialList3 != null) {
            materialList2.absorb(materialList3);
        }
        Material[] materialArray = materialList.getLeafMaterials();
        for (int i = 0; i < materialArray.length; ++i) {
            materialList2.add(materialArray[i]);
        }
        return materialList2;
    }

    private void absorb(MaterialList materialList) {
        assert (materialList != null);
        Material[] materialArray = materialList.toArray();
        for (int i = 0; i < materialArray.length; ++i) {
            this.add(materialArray[i]);
        }
    }

    @Override
    public int size() {
        return this.d_mats.size();
    }

    public Material[] toArray() {
        Material[] materialArray = new Material[this.size()];
        this.d_mats.toArray(materialArray);
        return materialArray;
    }

    public Material[] toArray(Material[] materialArray) {
        return this.d_mats.toArray(materialArray);
    }

    private boolean add(Material material, int n) {
        return this.add(material);
    }

    @Override
    protected boolean add(Material material) {
        if (Material.isPredefinedMaterial(material.getName())) {
            return false;
        }
        Material material2 = this.get(material.getName());
        if (material2 != null) {
            return false;
        }
        super.add(material);
        this.d_mats.add(material);
        this.fireDomainEvent(new MaterialDomainEvent(this, material, 3));
        return true;
    }

    public int indexOf(Material material) {
        Iterator iterator = this.d_mats.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (iterator.next() == material) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public boolean contains(String string) {
        return this.get(string) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.d_mats.isEmpty();
    }

    @Override
    public Material get(String string) {
        for (Material material : this.d_mats) {
            if (!material.getName().equals(string)) continue;
            return material;
        }
        return null;
    }

    @Override
    public Material get(int n) {
        return (Material)this.d_mats.toArray()[n];
    }

    @Override
    protected boolean remove(Material material) {
        super.remove(material);
        boolean bl = this.d_mats.remove(material);
        this.fireDomainEvent(new MaterialDomainEvent(this, material, 4));
        return bl;
    }

    private boolean removeAll(Collection<? extends Material> collection) {
        this.pauseUpdates();
        boolean bl = true;
        for (Material material : collection) {
            if (this.remove(material)) continue;
            bl = false;
        }
        this.resumeUpdates();
        return bl;
    }

    public List getNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        Iterator iterator = this.d_mats.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Material)iterator.next()).getName());
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(": {");
        Iterator iterator = this.d_mats.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Material)iterator.next()).getName());
            stringBuffer.append(", ");
        }
        if (this.size() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append("}]");
        return stringBuffer.toString();
    }

    @Override
    public Iterator<Material> iterator() {
        return this.d_mats.iterator();
    }

    @Override
    public Class<Material> getVClass() {
        return Material.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(Material material) {
        return true;
    }

    @Override
    public Task taskMakeUnique(final Material material) {
        return new AMakeUniqueNameTask<Material>(this.getDomains(), material){

            @Override
            protected Task taskMakeUnique(Material material2) {
                return material.taskSetName(APyroDomainManager.getUniqueName(MaterialList.this, material2.getName()));
            }
        };
    }

    public Task taskSetMatName(final Material material, String string) {
        return new AChangePyroDepOnIDTask(material, string, this.getDomains()){

            @Override
            public void setID(String string) {
                this.pauseUpdates();
                MaterialList.this.d_mats.remove(material);
                material.setName(string);
                MaterialList.this.d_mats.add(material);
                MaterialList.this.fireDomainEvent(new MaterialDomainEvent(MaterialList.this.toCollection(), 2));
                this.resumeUpdates();
            }
        };
    }

    @Override
    public Material get(Material material) {
        return this.get(material.getName());
    }

    @Override
    public String describeObject(Material material) {
        return material.getName();
    }

    public Task taskAdd(Material material, int n) {
        return this.taskAddAll(new VectorFromArray<Material>(material), n);
    }

    public Task taskAddAll(Collection<? extends Material> collection, int n) {
        return new APyroManAddAtIndexTask<String, Material>((IPyroManager)this, collection, n){

            @Override
            public void removeAll(Collection<? extends Material> collection) {
                MaterialList.this.removeAll(collection);
            }

            @Override
            public boolean add(Material material, int n) {
                return MaterialList.this.add(material, n);
            }
        };
    }

    @Override
    public Task taskAddAll(Collection<? extends Material> collection) {
        return new APyroManAddTask<String, Material>((IPyroManager)this, collection){

            @Override
            public boolean add(Material material) {
                return MaterialList.this.add(material);
            }

            @Override
            public boolean remove(Material material) {
                return MaterialList.this.remove(material);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<Material> list, List<Material> list2) {
        return new APyroManReplaceDepOnTask<String, Material>((IPyroManager)this, list, list2, this.getDomains()){

            @Override
            public boolean add(Material material) {
                return MaterialList.this.add(material);
            }

            @Override
            public boolean remove(Material material) {
                return MaterialList.this.remove(material);
            }
        };
    }

    private static class LinOrd
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -9116325213664216512L;

        private LinOrd() {
        }

        public int compare(Object object, Object object2) {
            Material material = (Material)object;
            Material material2 = (Material)object2;
            return material.getName().compareToIgnoreCase(material2.getName());
        }
    }
}

