/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.UnitSystem;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.MaterialProfile;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.PyroResourceFinder;
import pyrosim.legacy_2006_2.domain.Ramp;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.MaterialDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Warning;

public class Material
extends ADomainObject<PyroMod>
implements Serializable,
Cloneable,
IDependent,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    public static final String INERT = "INERT";
    public static final String OPEN = "OPEN";
    public static final String MIRROR = "MIRROR";
    public static final String ADIABATIC_MAT = "ADIABATIC";
    private static final Material s_inert = new Material("INERT", new Color(0.5f, 0.5f, 0.5f));
    private static final Material s_open = new Material("OPEN", new Color(0.0f, 1.0f, 1.0f));
    private static final Material s_mirror = new Material("MIRROR", new Color(0.0f, 1.0f, 1.0f));
    private static final Material s_adiabatic = new Material("ADIABATIC", new Color(0.8f, 0.8f, 0.8f));
    private static Hashtable<String, Material> d_predefinedMaterials = new Hashtable(4);
    public static final String COLOR = "RGB";
    public static final String NAME = "ID";
    public static final String ADIABATIC = "ADIABATIC";
    public static final String ALPHA = "ALPHA";
    public static final String A = "A";
    public static final String BACKING = "BACKING";
    public static final String BURN_AWAY = "BURN_AWAY";
    public static final String BURNING_RATE_MAX = "BURNING_RATE_MAX";
    public static final String C_DELTA_RHO = "C_DELTA_RHO";
    public static final String CHAR_DENSITY = "CHAR_DENSITY";
    public static final String C_P = "C_P";
    public static final String C_P_CHAR = "C_P_CHAR";
    public static final String DELTA = "DELTA";
    public static final String DENSITY = "DENSITY";
    public static final String DX_SOLID = "DX_SOLID";
    public static final String E = "E";
    public static final String E_COEFFICIENT = "E_COEFFICIENT";
    public static final String EMISSIVITY = "EMISSIVITY";
    public static final String FUEL_FRACTION = "FUEL_FRACTION";
    public static final String FYI = "FYI";
    public static final String HEAT_FLUX = "HEAT_FLUX";
    public static final String HEAT_OF_COMBUSTION = "HEAT_OF_COMBUSTION";
    public static final String HEAT_OF_VAPORIZATION = "HEAT_OF_VAPORIZATION";
    public static final String HRRPUA = "HRRPUA";
    public static final String KS = "KS";
    public static final String KS_CHAR = "KS_CHAR";
    public static final String LEAKING = "LEAKING";
    public static final String MASS_FLUX_CRITICAL = "MASS_FLUX_CRITICAL";
    public static final String MOISTURE_FRACTION = "MOISTURE_FRACTION";
    public static final String NPPC = "NPPC";
    public static final String PARTICLES = "PARTICLES";
    public static final String PART_ID = "PART_ID";
    public static final String PHASE = "PHASE";
    public static final String PLE = "PLE";
    public static final String POROSITY = "POROSITY";
    public static final String PROFILE = "PROFILE";
    public static final String RAMP_C_P = "RAMP_C_P";
    public static final String RAMP_C_P_CHAR = "RAMP_C_P_CHAR";
    public static final String RAMP_KS = "RAMP_KS";
    public static final String RAMP_KS_CHAR = "RAMP_KS_CHAR";
    public static final String RAMP_Q = "RAMP_Q";
    public static final String RAMP_V = "RAMP_V";
    public static final String SURFACE_DENSITY = "SURFACE_DENSITY";
    public static final String TAU_Q = "TAU_Q";
    public static final String TAU_V = "TAU_V";
    public static final String TEXTURE_HEIGHT = "TEXTURE_HEIGHT";
    public static final String TEXTURE_MAP = "TEXTURE_MAP";
    public static final String TEXTURE_WIDTH = "TEXTURE_WIDTH";
    public static final String TMPIGN = "TMPIGN";
    public static final String TMPWAL = "TMPWAL";
    public static final String TMPWAL0 = "TMPWAL0";
    public static final String VBC = "VBC";
    public static final String VEL = "VEL";
    public static final String VEL_T = "VEL_T";
    public static final String VOLUME_FLUX = "VOLUME_FLUX";
    public static final String WALL_POINTS = "WALL_POINTS";
    public static final String Z0 = "Z0";
    public static final String DEF_VEL_PROFILE_DESC = "Top Hat (Default)";
    public static final String TOPHAT_PROFILE = "TOP_HAT";
    public static final String PARABOLIC_PROFILE = "PARABOLIC";
    public static final String ATMOSPHERIC_PROFILE = "ATMOSPHERIC";
    public static final String LIQUID = "LIQUID";
    public static final String CHAR = "CHAR";
    public static final String SOLID = "SOLID";
    public static final String INSULATED = "INSULATED";
    public static final String EXPOSED = "EXPOSED";
    private static final Hashtable<String, RampInfo> s_rampInfo;
    private static final TreeMap<String, ValueInfo<? extends Object, ? extends Object>> s_valueInfo;
    private Color d_color;
    private String d_name;
    private String d_texname;
    private TextureInfo d_texinfo;
    private Hashtable<String, Object> d_table;
    private MaterialProfile.ProfilePath d_profilePath = null;

    private static DoubleValueRange dur() {
        return DoubleValueRange.createUncheckedRange();
    }

    private static IntValueRange iur() {
        return IntValueRange.createUncheckedRange();
    }

    public static ValueInfo<?, ?> getValueInfo(String string) {
        return s_valueInfo.get(string);
    }

    public static Set<String> getValueNames() {
        return s_valueInfo.keySet();
    }

    public static int getUnitType(String string) {
        ValueInfo<? extends Object, ? extends Object> valueInfo = s_valueInfo.get(string);
        if (valueInfo == null) {
            return 28;
        }
        return valueInfo.d_unitType;
    }

    public static Object getDefaultValue(String string) {
        ValueInfo<? extends Object, ? extends Object> valueInfo = s_valueInfo.get(string);
        if (valueInfo == null) {
            return null;
        }
        return ((ValueInfo)valueInfo).d_defaultValue;
    }

    public static boolean isValueSetByDefault(String string) {
        ValueInfo<? extends Object, ? extends Object> valueInfo = s_valueInfo.get(string);
        if (valueInfo == null) {
            return true;
        }
        return valueInfo.d_defaultSet;
    }

    public static ValueRange getValueRange(String string) {
        ValueInfo<? extends Object, ? extends Object> valueInfo = s_valueInfo.get(string);
        if (valueInfo == null) {
            return null;
        }
        return valueInfo.d_valueRange;
    }

    public static boolean isPredefinedMaterial(String string) {
        return d_predefinedMaterials.get(string) != null;
    }

    public static Material getPredefinedMaterial(String string) {
        return d_predefinedMaterials.get(string);
    }

    public static Collection<Material> getPredefinedMaterials() {
        return d_predefinedMaterials.values();
    }

    public static RampInfo getRampInfo(String string) {
        return s_rampInfo.get(string);
    }

    public static Collection<String> getRampTypes() {
        return s_rampInfo.keySet();
    }

    public Material(String string) {
        this(string, s_inert.getColor(), (TextureInfo)null);
    }

    public Material(String string, Color color) {
        this(string, color, (TextureInfo)null);
    }

    public Material(String string, Color color, String string2) {
        this(string, color, (TextureInfo)null);
    }

    public Material(String string, Color color, TextureInfo textureInfo) {
        this.d_name = string;
        this.d_color = color;
        this.d_texname = null;
        this.d_texinfo = textureInfo;
        this.d_table = new Hashtable();
        this.d_profilePath = new MaterialProfile.ProfilePath("Default Material Profile");
    }

    public void updateTextureInfo(TextureDB textureDB) {
        if (this.d_texname != null) {
            this.d_texinfo = new TextureInfo(this.d_texname);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!(objectInputStream instanceof PyroSimObjectInputStream)) {
            return;
        }
        PyroSimObjectInputStream pyroSimObjectInputStream = (PyroSimObjectInputStream)objectInputStream;
        if (pyroSimObjectInputStream.getVersion() < 15) {
            if (this.d_table == null) {
                this.d_table = new Hashtable();
            } else {
                FdsSISystem fdsSISystem = FdsSISystem.getInstance();
                for (Map.Entry<String, Object> entry : this.d_table.entrySet()) {
                    Cloneable cloneable;
                    Unit unit;
                    int n;
                    String string = entry.getKey();
                    Object object = entry.getValue();
                    if (object instanceof Double) {
                        n = Material.getUnitType(string);
                        if (n == 28) continue;
                        unit = fdsSISystem.getUnit(n);
                        cloneable = new UnitDouble((Double)object, unit);
                        this.d_table.put(string, cloneable);
                        continue;
                    }
                    if (!(object instanceof Vector) || (n = Material.getUnitType(string)) == 28) continue;
                    unit = fdsSISystem.getUnit(n);
                    cloneable = (Vector)object;
                    for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                        Object e = ((Vector)cloneable).get(i);
                        if (!(e instanceof Double)) continue;
                        UnitDouble unitDouble = new UnitDouble((Double)e, unit);
                        ((Vector)cloneable).set(i, unitDouble);
                    }
                    this.d_table.put(string, cloneable);
                }
            }
            if (this.d_profilePath == null) {
                this.recalcProfilePath();
            }
        }
    }

    @Override
    public Object clone() {
        Material material = new Material(this.d_name, this.d_color, this.d_texinfo);
        material.imprint(this, false);
        return material;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2;
        if (!(object instanceof Material)) {
            return false;
        }
        Material material = (Material)object;
        boolean bl3 = bl2 = this.d_texinfo == null && material.d_texinfo == null || this.d_texinfo != null && this.d_texinfo.equals(material.d_texinfo);
        if (!(this.d_name.equals(material.d_name) && this.d_color.equals(material.d_color) && bl2 && this.d_table.equals(material.d_table))) {
            return false;
        }
        PartRecord partRecord = this.getPartRecord();
        PartRecord partRecord2 = material.getPartRecord();
        boolean bl4 = partRecord == null ? partRecord2 == null : (bl = partRecord.equals(partRecord2));
        return bl;
    }

    public void clearProps() {
        this.d_table.clear();
    }

    private PartRecord getPartRecord() {
        String string = (String)this.getValue(PART_ID);
        if (string != null) {
            return (PartRecord)PyroResourceFinder.find(PartRecord.class, string, this.getDomains());
        }
        return null;
    }

    public Color getColor() {
        return this.d_color;
    }

    public String getTextureName() {
        return this.d_texname;
    }

    public TextureInfo getTextureInfo() {
        return this.d_texinfo;
    }

    @Override
    public String getFDSType() {
        return "SURF";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        if (Material.isPredefinedMaterial(this.getName()) && !this.equals(s_adiabatic)) {
            return;
        }
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("SURF");
        fDSInputRecord.setValue(NAME, this.getName());
        Vector<Double> vector = new Vector<Double>(3);
        float[] fArray = this.getColor().getRGBColorComponents(null);
        vector.add(new Double(fArray[0]));
        vector.add(new Double(fArray[1]));
        vector.add(new Double(fArray[2]));
        fDSInputRecord.setValue(COLOR, vector);
        if (this.d_texinfo != null) {
            double d;
            fDSInputRecord.setValue(TEXTURE_MAP, this.d_texinfo.getTexID());
            double d2 = this.d_texinfo.getWidth().getValue(SI.METER);
            if (d2 > 0.0) {
                fDSInputRecord.setValue(TEXTURE_WIDTH, d2);
            }
            if ((d = this.d_texinfo.getHeight().getValue(SI.METER)) > 0.0) {
                fDSInputRecord.setValue(TEXTURE_HEIGHT, d);
            }
        }
        for (String string : this.getUsedKeysC()) {
            Object object = this.getValue(string);
            if (object instanceof Ramp || object.equals(SOLID)) continue;
            ValueInfo<?, ?> valueInfo = Material.getValueInfo(string);
            fDSInputRecord.setValue(string, valueInfo.convertPyroValueToFDSValue(object));
        }
        collection.add(fDSInputRecord);
        for (String string : Material.getRampTypes()) {
            Ramp ramp = (Ramp)this.getValue(string);
            if (ramp == null) continue;
            ramp.setName(string + "_" + this.getName());
            fDSInputRecord.setValue(string, ramp.getName());
            ramp.getInputRecords(collection);
        }
    }

    private void changed() {
        this.fireDomainEvent(new MaterialDomainEvent(this, 5), false);
    }

    public Task taskSetName(String string) {
        return new AChangePyroDepOnIDTask(this, string, this.getDomains()){

            @Override
            public void setID(String string) {
                Material.this.setName(string);
            }
        };
    }

    public String getName() {
        return this.d_name;
    }

    protected void setName(String string) {
        this.d_name = string;
        this.changed();
    }

    public void setColor(Color color) {
        this.d_color = color;
        this.changed();
    }

    public void setTexture(String string) {
        this.d_texname = string;
        this.changed();
    }

    public void setTexture(TextureInfo textureInfo) {
        this.d_texinfo = textureInfo;
    }

    public Object getValue(String string) {
        return this.d_table.get(string);
    }

    public void setValue(String string, Object object) {
        this.setValue(string, object, false);
    }

    public void setValue(String string, Object object, boolean bl) {
        if (object == null) {
            this.d_table.remove(string);
        } else {
            this.d_table.put(string, object);
        }
        if (bl) {
            this.recalcProfilePath();
        }
        this.fireDomainEvent(new MaterialDomainEvent(this, 5), true);
    }

    public void recalcProfilePath() {
        MaterialProfile materialProfile = MaterialProfile.getDefaultProfile();
        this.d_profilePath = materialProfile.buildBestPathForMat(this);
        this.fireDomainEvent(new MaterialDomainEvent(this, 5), true);
    }

    public String[] getUsedKeys() {
        return this.d_table.keySet().toArray(new String[this.d_table.size()]);
    }

    public Set<String> getUsedKeysC() {
        return this.d_table.keySet();
    }

    public boolean isDefined(Object object) {
        return this.d_table.containsKey(object);
    }

    public void imprint(Material material) {
        this.imprint(material, true);
    }

    public void imprint(Material material, boolean bl) {
        this.pauseUpdates(false);
        this.d_color = material.d_color;
        this.d_texname = material.d_texname;
        this.d_texinfo = material.d_texinfo != null ? new TextureInfo(material.d_texinfo) : null;
        for (String string : Material.getValueNames()) {
            if (material.isDefined(string)) {
                this.d_table.put(string, material.getValue(string));
                continue;
            }
            if (!bl) continue;
            this.d_table.remove(string);
        }
        try {
            for (String string : Material.getRampTypes()) {
                Ramp ramp = (Ramp)material.getValue(string);
                if (ramp == null) continue;
                this.setValue(string, ramp.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (bl) {
            this.d_profilePath = material.d_profilePath;
        } else {
            this.recalcProfilePath();
        }
        this.resumeUpdates(new MaterialDomainEvent(this, 5), true);
    }

    public void setProfilePath(MaterialProfile.ProfilePath profilePath) {
        this.d_profilePath = profilePath;
        this.fireDomainEvent(new MaterialDomainEvent(this, 5), true);
    }

    public MaterialProfile.ProfilePath getProfilePath() {
        return this.d_profilePath;
    }

    public boolean fireDomainEvent(IDomainEvent iDomainEvent, boolean bl) {
        this.pauseUpdates();
        boolean bl2 = super.fireDomainEvent(iDomainEvent);
        if (bl) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return bl2;
    }

    public void resumeUpdates(IDomainEvent iDomainEvent, boolean bl) {
        super.resumeUpdates(iDomainEvent);
        if (bl) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
    }

    @Override
    public String getTypeDescription() {
        return "Surface";
    }

    @Override
    public String getUniqueID() {
        return this.getName();
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> set, Class<IDependedOn> clazz) {
        PartRecord partRecord;
        String string;
        if (clazz.isAssignableFrom(PartRecord.class) && (string = (String)this.getValue(PART_ID)) != null && (partRecord = (PartRecord)PyroResourceFinder.find(clazz, string, this.getDomains())) != null) {
            set.add(partRecord);
        }
    }

    @Override
    public boolean dependsOnObject(IDependedOn iDependedOn) {
        if (iDependedOn instanceof PartRecord) {
            PartRecord partRecord = (PartRecord)iDependedOn;
            String string = (String)this.getValue(PART_ID);
            if (string != null && partRecord.getID().equals(string)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn iDependedOn, IDependedOn iDependedOn2) {
        assert (iDependedOn2 == null || iDependedOn2 instanceof PartRecord);
        PartRecord partRecord = (PartRecord)iDependedOn;
        PartRecord partRecord2 = (PartRecord)iDependedOn2;
        assert (partRecord == null ? this.getValue(PART_ID) == null : partRecord.getID().equals(this.getValue(PART_ID)));
        return new SetValueTask(this, PART_ID, partRecord2 != null ? partRecord2.getID() : null);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn iDependedOn, String string) {
        assert (iDependedOn instanceof PartRecord);
        PartRecord partRecord = (PartRecord)iDependedOn;
        assert (partRecord == null ? this.getValue(PART_ID) == null : partRecord.getID().equals(this.getValue(PART_ID)));
        return new SetValueTask(this, PART_ID, string);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn iDependedOn, Object object) {
        return null;
    }

    public static Collection<? extends Warning> validateMaterial(Material material) {
        ArrayList<Warning> arrayList = new ArrayList<Warning>();
        Material material2 = new Material(material.getName(), material.getColor());
        HashSet<String> hashSet = new HashSet<String>();
        material.getProfilePath().initMat(material2, hashSet);
        HashSet<String> hashSet2 = new HashSet<String>(material.getUsedKeysC());
        hashSet2.removeAll(hashSet);
        for (String string : hashSet2) {
            Map<String, MaterialProfile.ProfilePath> map = material.getProfilePath().getListPaths();
            String string2 = map.values().iterator().next().getProfileName();
            arrayList.add(new Warning("The surface, " + material.getName() + ", appears to be " + "a type of " + string2 + ", but it contains the field, " + string + ".  " + "This field is not known to be valid for a " + string2 + ".", "Removed field, " + string + ", from the surface, " + material.getName() + "."));
        }
        for (String string2 : material.getUsedKeys()) {
            if (hashSet.contains(string2)) continue;
            material.setValue(string2, null);
        }
        return arrayList;
    }

    static {
        s_adiabatic.setValue("ADIABATIC", Boolean.TRUE);
        s_valueInfo = new TreeMap();
        s_valueInfo.put("ADIABATIC", new BValueInfo(false, true));
        s_valueInfo.put(A, new UDValueInfo(8, 650000.0, false, Material.dur()));
        s_valueInfo.put(ALPHA, new UDValueInfo(27, 0.0, false, Material.dur()));
        s_valueInfo.put(BACKING, new SValueInfo(null, true));
        s_valueInfo.put(BURN_AWAY, new BValueInfo(false, true));
        s_valueInfo.put(BURNING_RATE_MAX, new UDValueInfo(20, 0.1, true, Material.dur()));
        s_valueInfo.put(C_DELTA_RHO, new UDValueInfo(0, 31.499999999999996, true, Material.dur()));
        s_valueInfo.put(CHAR_DENSITY, new UDValueInfo(4, 120.0, true, Material.dur()));
        s_valueInfo.put(C_P, new UDValueInfo(11, 0.7, false, Material.dur()));
        s_valueInfo.put(C_P_CHAR, new UDValueInfo(11, 0.7, false, Material.dur()));
        s_valueInfo.put(DELTA, new UDValueInfo(0, 0.1, false, Material.dur()));
        s_valueInfo.put(DENSITY, new UDValueInfo(4, 450.0, false, Material.dur()));
        s_valueInfo.put(DX_SOLID, new UDValueInfo(0, 1.0E-4, false, Material.dur()));
        s_valueInfo.put(E, new UDValueInfo(15, 0.0, false, Material.dur()));
        s_valueInfo.put(E_COEFFICIENT, new UDValueInfo(21, 0.0, true, Material.dur()));
        s_valueInfo.put(EMISSIVITY, new DValueInfo(0.9, true, Material.dur()));
        s_valueInfo.put(FUEL_FRACTION, new DValueInfo(1.0, true, Material.dur()));
        s_valueInfo.put(HEAT_FLUX, new UDValueInfo(22, 0.0, true, Material.dur()));
        s_valueInfo.put(HEAT_OF_COMBUSTION, new UDValueInfo(10, 0.0, false, Material.dur()));
        s_valueInfo.put(HEAT_OF_VAPORIZATION, new UDValueInfo(10, 0.0, true, Material.dur()));
        s_valueInfo.put(HRRPUA, new UDValueInfo(22, 0.0, true, Material.dur()));
        s_valueInfo.put(KS, new UDValueInfo(19, 0.0, false, Material.dur()));
        s_valueInfo.put(KS_CHAR, new UDValueInfo(19, 0.1, false, Material.dur()));
        s_valueInfo.put(LEAKING, new BValueInfo(false, true));
        s_valueInfo.put(MASS_FLUX_CRITICAL, new DValueInfo(0.02, false, Material.dur()));
        s_valueInfo.put(MOISTURE_FRACTION, new DValueInfo(0.0, true, Material.dur()));
        s_valueInfo.put(NPPC, new IValueInfo(1, true, Material.iur()));
        s_valueInfo.put(PARTICLES, new BValueInfo(false, true));
        s_valueInfo.put(PART_ID, new SValueInfo(null, true));
        s_valueInfo.put(PHASE, new SValueInfo(SOLID, true));
        s_valueInfo.put(POROSITY, new DValueInfo(0.0, true, Material.dur()));
        s_valueInfo.put(PLE, new DValueInfo(0.3, true, Material.dur()));
        s_valueInfo.put(PROFILE, new SValueInfo(TOPHAT_PROFILE, true));
        s_valueInfo.put(RAMP_C_P, new RampInfo(null, false, RAMP_C_P, 1, 11, "Temperature", "Specific Heat"));
        s_valueInfo.put(RAMP_C_P_CHAR, new RampInfo(null, false, RAMP_C_P_CHAR, 1, 11, "Temperature", "Specific Heat"));
        s_valueInfo.put(RAMP_KS, new RampInfo(null, false, RAMP_KS, 1, 19, "Temperature", "Conductivity"));
        s_valueInfo.put(RAMP_KS_CHAR, new RampInfo(null, false, RAMP_KS_CHAR, 1, 19, "Temperature", "Conductivity"));
        s_valueInfo.put(RAMP_Q, new RampInfo(null, false, RAMP_Q, 2, 28, "Time", "Fraction"));
        s_valueInfo.put(RAMP_V, new RampInfo(null, false, RAMP_V, 2, 28, "Time", "Velocity Fraction"));
        s_valueInfo.put(SURFACE_DENSITY, new UDValueInfo(23, 45.0, false, Material.dur()));
        s_valueInfo.put(TAU_Q, new UDValueInfo(2, 1.0, false, Material.dur()));
        s_valueInfo.put(TAU_V, new UDValueInfo(2, 1.0, false, Material.dur()));
        s_valueInfo.put(TMPIGN, new UDValueInfo(1, 5000.0, false, Material.dur()));
        s_valueInfo.put(TMPWAL, new UDValueInfo(1, 20.0, true, Material.dur()));
        s_valueInfo.put(TMPWAL0, new UDValueInfo(1, 20.0, false, Material.dur()));
        s_valueInfo.put(VBC, new DValueInfo(0.5, false, Material.dur()));
        s_valueInfo.put(VEL, new UDValueInfo(8, 0.0, true, Material.dur()));
        s_valueInfo.put(VEL_T, new VValueInfo<UnitDouble, Double>(2, false, new UDValueInfo(8, 0.0, false, Material.dur())));
        s_valueInfo.put(VOLUME_FLUX, new UDValueInfo(24, 0.0, false, Material.dur()));
        s_valueInfo.put(WALL_POINTS, new IValueInfo(20, true, Material.iur()));
        s_valueInfo.put(Z0, new UDValueInfo(0, 10.0, true, Material.dur()));
        s_inert.recalcProfilePath();
        s_open.recalcProfilePath();
        s_mirror.recalcProfilePath();
        s_adiabatic.recalcProfilePath();
        d_predefinedMaterials.put(s_inert.getName(), s_inert);
        d_predefinedMaterials.put(s_open.getName(), s_open);
        d_predefinedMaterials.put(s_mirror.getName(), s_mirror);
        d_predefinedMaterials.put(s_adiabatic.getName(), s_adiabatic);
        s_rampInfo = new Hashtable(6);
        s_rampInfo.put(RAMP_C_P, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_C_P)));
        s_rampInfo.put(RAMP_C_P_CHAR, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_C_P_CHAR)));
        s_rampInfo.put(RAMP_KS, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_KS)));
        s_rampInfo.put(RAMP_KS_CHAR, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_KS_CHAR)));
        s_rampInfo.put(RAMP_Q, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_Q)));
        s_rampInfo.put(RAMP_V, (RampInfo)RampInfo.class.cast(s_valueInfo.get(RAMP_V)));
    }

    private static class SetValueTask
    implements Task {
        private final Material d_owner;
        private final String d_key;
        private Object d_old;
        private final Object d_replacement;

        public SetValueTask(Material material, String string, Object object) {
            this.d_owner = material;
            this.d_key = string;
            this.d_replacement = object;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void undo() {
            this.d_owner.setValue(this.d_key, this.d_old, true);
        }

        @Override
        public void run() {
            this.d_old = this.d_owner.getValue(this.d_key);
            this.d_owner.setValue(this.d_key, this.d_replacement, true);
        }
    }

    public static class RampInfo
    extends ValueInfo<Ramp, String> {
        public final String d_rampType;
        public final int d_tUnit;
        public final int d_fUnit;
        public final String d_tDesc;
        public final String d_fDesc;

        public RampInfo(Ramp ramp, boolean bl, String string, int n, int n2, String string2, String string3) {
            super(Ramp.class, ramp, bl, null, String.class);
            this.d_tUnit = n;
            this.d_fUnit = n2;
            this.d_tDesc = string2;
            this.d_fDesc = string3;
            this.d_rampType = string;
        }

        @Override
        public Ramp convertFDSValueToPyroValue(String string) {
            assert (false);
            return null;
        }

        @Override
        public String convertPyroValueToFDSValue(Ramp ramp) {
            assert (false);
            return null;
        }
    }

    public static class SValueInfo
    extends ValueInfo<String, String> {
        public SValueInfo(String string, boolean bl) {
            super(String.class, string, bl, null, String.class);
        }
    }

    public static class BValueInfo
    extends ValueInfo<Boolean, Boolean> {
        public BValueInfo(boolean bl, boolean bl2) {
            super(Boolean.class, bl, bl2, null, Boolean.class);
        }
    }

    public static class DValueInfo
    extends ValueInfo<Double, Double> {
        public DValueInfo(double d, boolean bl, ValueRange<Double> valueRange) {
            super(Double.class, d, bl, valueRange, Double.class);
        }
    }

    public static class IValueInfo
    extends ValueInfo<Integer, Object> {
        public IValueInfo(int n, boolean bl, IntValueRange intValueRange) {
            super(Integer.class, n, bl, intValueRange, Object.class);
        }

        @Override
        public Integer convertFDSValueToPyroValue(Object object) {
            return ((Double)object).intValue();
        }

        @Override
        public Integer convertPyroValueToFDSValue(Integer n) {
            return n;
        }
    }

    public static class VValueInfo<T, T2>
    extends ValueInfo<Vector, Vector> {
        private final ValueInfo<T, T2> d_memberInfo;
        private final int d_size;

        public VValueInfo(int n, boolean bl, ValueInfo<T, T2> valueInfo) {
            super(Vector.class, valueInfo.d_unitType, null, bl, null, Vector.class);
            this.d_memberInfo = valueInfo;
            this.d_size = n;
        }

        @Override
        public Vector<T> convertFDSValueToPyroValue(Vector vector) {
            Vector<T> vector2 = new Vector<T>(vector.size());
            for (Object e : vector) {
                Object T2 = this.d_memberInfo.d_fdsParsingDataType.cast(e);
                T t = this.d_memberInfo.convertFDSValueToPyroValue(T2);
                vector2.add(t);
            }
            return vector2;
        }

        @Override
        public Vector<T2> convertPyroValueToFDSValue(Vector vector) {
            Vector<T2> vector2 = new Vector<T2>(vector.size());
            for (Object e : vector) {
                Object t = this.d_memberInfo.d_type.cast(e);
                T2 T2 = this.d_memberInfo.convertPyroValueToFDSValue(t);
                vector2.add(T2);
            }
            return vector2;
        }

        @Override
        public Object getDefaultValue(UnitSystem unitSystem) {
            Vector<Object> vector = new Vector<Object>(this.d_size);
            for (int i = 0; i < this.d_size; ++i) {
                vector.add(this.d_memberInfo.getDefaultValue(unitSystem));
            }
            return vector;
        }
    }

    public static class UDValueInfo
    extends ValueInfo<UnitDouble, Double> {
        private static UnitSystem d_si = FdsSISystem.getInstance();

        public UDValueInfo(int n, double d, boolean bl, DoubleValueRange doubleValueRange) {
            super(UnitDouble.class, n, new UnitDouble(d, d_si.getUnit(n)), bl, UnitDoubleValueRange.createCheckedRange(doubleValueRange, d_si.getUnit(n)), Double.class);
        }

        @Override
        public UnitDouble convertFDSValueToPyroValue(Double d) {
            return new UnitDouble(d, FdsSISystem.getInstance().getUnit(this.d_unitType));
        }

        @Override
        public Double convertPyroValueToFDSValue(UnitDouble unitDouble) {
            return unitDouble.getValue(d_si.getUnit(this.d_unitType));
        }

        @Override
        public Object getDefaultValue(UnitSystem unitSystem) {
            return ((UnitDouble)super.getDefaultValue(unitSystem)).getValue(unitSystem.getUnit(this.d_unitType));
        }
    }

    public static class ValueInfo<T, T2> {
        public final int d_unitType;
        private final T d_defaultValue;
        public final boolean d_defaultSet;
        public final ValueRange<T> d_valueRange;
        public final Class<T2> d_fdsParsingDataType;
        public final Class<T> d_type;

        public ValueInfo(Class<T> clazz, int n, T t, boolean bl, ValueRange<T> valueRange, Class<T2> clazz2) {
            this.d_unitType = n;
            this.d_defaultValue = t;
            this.d_valueRange = valueRange;
            this.d_fdsParsingDataType = clazz2;
            this.d_type = clazz;
            this.d_defaultSet = bl;
        }

        public ValueInfo(Class<T> clazz, T t, boolean bl, ValueRange<T> valueRange, Class<T2> clazz2) {
            this(clazz, 28, t, bl, valueRange, clazz2);
        }

        public T convertFDSValueToPyroValue(T2 T2) {
            return this.d_type.cast(T2);
        }

        public T2 convertPyroValueToFDSValue(T t) {
            return this.d_fdsParsingDataType.cast(t);
        }

        public Object getDefaultValue(UnitSystem unitSystem) {
            return this.d_defaultValue;
        }
    }
}

