/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class IsofRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    private static final long serialVersionUID = 1L;
    private final Vector d_values;
    private final String d_gasPhaseQuantity;
    private final UnitDouble d_dtsam;
    private final Unit d_timeUnit;
    private Unit d_quantityUnit;

    public IsofRecord(Vector vector, String string, UnitDouble unitDouble) {
        this.d_values = vector;
        this.d_gasPhaseQuantity = string;
        this.d_dtsam = unitDouble;
        this.d_timeUnit = unitDouble != null ? this.d_dtsam.getUnit() : FdsSISystem.getInstance().getTimeUnit();
    }

    public Vector getValues() {
        return this.d_values;
    }

    public String getGasPhaseQuantity() {
        return this.d_gasPhaseQuantity;
    }

    public UnitDouble getDtsam() {
        return this.d_dtsam;
    }

    @Override
    public String getFDSType() {
        return "ISOF";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        Serializable serializable;
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("ISOF");
        fDSInputRecord.setValue("QUANTITY", this.getGasPhaseQuantity());
        Unit unit = null;
        if (this.d_gasPhaseQuantity.equals("TEMPERATURE")) {
            unit = FdsSISystem.getInstance().getTempUnit();
        } else if (this.d_gasPhaseQuantity.equals("HRRPUV")) {
            unit = FdsSISystem.getInstance().getHRRPUVUnit();
        } else if (this.d_gasPhaseQuantity.equals("DENSITY")) {
            unit = FdsSISystem.getInstance().getDensityUnit();
        } else if (this.d_gasPhaseQuantity.equals("MIXTURE_FRACTION")) {
            unit = FdsSISystem.getInstance().getMixFracUnit();
        }
        int n = this.d_values.size();
        for (int i = 0; i < n; ++i) {
            serializable = (UnitDouble)this.d_values.get(i);
            fDSInputRecord.setValue("VALUE(" + (i + 1) + ")", new Double(((UnitDouble)serializable).getValue(unit)));
        }
        if (this.getDtsam() != null) {
            UnitDouble unitDouble = this.getDtsam();
            serializable = FdsSISystem.getInstance().getTimeUnit();
            if (this.d_timeUnit != serializable) {
                Double d = new Double(this.d_timeUnit.getConverterTo((Unit)serializable).convert(unitDouble.getValue(this.d_timeUnit)));
                fDSInputRecord.setValue("DTSAM", d);
            }
            fDSInputRecord.setValue("DTSAM", new Double(unitDouble.getValue((Unit)serializable)));
        }
        collection.add(fDSInputRecord);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IsofRecord) {
            IsofRecord isofRecord = (IsofRecord)object;
            boolean bl = false;
            Vector vector = isofRecord.d_values;
            if (vector.size() == this.d_values.size()) {
                bl = true;
                for (int i = 0; i < vector.size(); ++i) {
                    UnitDouble unitDouble = (UnitDouble)vector.elementAt(i);
                    UnitDouble unitDouble2 = (UnitDouble)this.d_values.elementAt(i);
                    if (unitDouble != null && unitDouble2 != null) {
                        if (unitDouble.getUnit() == unitDouble2.getUnit() && unitDouble.getValue(unitDouble.getUnit()) == unitDouble2.getValue(unitDouble2.getUnit())) continue;
                        bl = false;
                        continue;
                    }
                    bl = false;
                }
            }
            bl = bl && isofRecord.d_gasPhaseQuantity.equals(this.d_gasPhaseQuantity) && (this.d_dtsam == null ? isofRecord.d_dtsam == null : this.d_dtsam.equals(isofRecord.d_dtsam));
            return bl;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Unit unit = null;
        if (this.d_gasPhaseQuantity.equals("TEMPERATURE")) {
            unit = FdsSISystem.getInstance().getTempUnit();
        } else if (this.d_gasPhaseQuantity.equals("HRRPUV")) {
            unit = FdsSISystem.getInstance().getHRRPUVUnit();
        } else if (this.d_gasPhaseQuantity.equals("DENSITY")) {
            unit = FdsSISystem.getInstance().getDensityUnit();
        } else if (this.d_gasPhaseQuantity.equals("MIXTURE_FRACTION")) {
            unit = FdsSISystem.getInstance().getMixFracUnit();
        }
        for (int i = 0; i < this.d_values.size(); ++i) {
            if (!(this.d_values.get(i) instanceof Double)) continue;
            UnitDouble unitDouble = new UnitDouble((Double)this.d_values.get(i), unit);
            this.d_values.set(i, unitDouble);
        }
    }

    @Override
    public String getTypeDescription() {
        return "Isosurface";
    }

    @Override
    public Object clone() {
        Vector vector = (Vector)this.d_values.clone();
        String string = this.d_gasPhaseQuantity;
        UnitDouble unitDouble = (UnitDouble)this.d_dtsam.clone();
        return new IsofRecord(vector, string, unitDouble);
    }
}

