/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManClearTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class IsofList
extends APyroDomainManager<Integer, IsofRecord>
implements Serializable {
    static final long serialVersionUID = 1L;
    private Vector<IsofRecord> d_isofList = new Vector();

    @Override
    public Collection<? extends IsofRecord> toCollection() {
        return new PyroCollection<Integer, IsofRecord>(this);
    }

    @Override
    public IsofRecord get(Integer n) {
        return this.d_isofList.elementAt(n);
    }

    @Override
    public IsofRecord get(String string) {
        for (IsofRecord isofRecord : this.d_isofList) {
            if (!isofRecord.getGasPhaseQuantity().equals(string)) continue;
            return isofRecord;
        }
        return null;
    }

    @Override
    public int size() {
        return this.d_isofList.size();
    }

    @Override
    protected boolean add(IsofRecord isofRecord) {
        IsofRecord isofRecord2 = this.get(isofRecord.getGasPhaseQuantity());
        if (isofRecord2 != null) {
            return false;
        }
        super.add(isofRecord);
        this.fireDomainEvent(new PyroDomainEvent<IsofList, IsofRecord>(this, isofRecord, IsofRecord.class, 3));
        return this.d_isofList.add(isofRecord);
    }

    private boolean addAll(Collection<? extends IsofRecord> collection) {
        this.pauseUpdates();
        boolean bl = true;
        for (IsofRecord isofRecord : collection) {
            if (this.add(isofRecord)) continue;
            bl = false;
        }
        this.resumeUpdates();
        return bl;
    }

    @Override
    protected boolean remove(IsofRecord isofRecord) {
        super.remove(isofRecord);
        this.d_isofList.remove(isofRecord);
        this.fireDomainEvent(new PyroDomainEvent<IsofList, IsofRecord>(this, isofRecord, IsofRecord.class, 4));
        return true;
    }

    private boolean removeAll(Collection<? extends IsofRecord> collection) {
        this.pauseUpdates();
        boolean bl = true;
        for (IsofRecord isofRecord : collection) {
            if (this.remove(isofRecord)) continue;
            bl = false;
        }
        this.resumeUpdates();
        return bl;
    }

    @Override
    public boolean contains(Integer n) {
        return n < this.d_isofList.size() && n >= 0;
    }

    @Override
    public boolean contains(String string) {
        return this.get(string) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.d_isofList.isEmpty();
    }

    public IsofRecord[] toArray() {
        return this.d_isofList.toArray(new IsofRecord[this.size()]);
    }

    public IsofRecord[] toArray(IsofRecord[] isofRecordArray) {
        return this.d_isofList.toArray(isofRecordArray);
    }

    @Override
    public Iterator<IsofRecord> iterator() {
        return this.d_isofList.iterator();
    }

    @Override
    public Class<IsofRecord> getVClass() {
        return IsofRecord.class;
    }

    @Override
    public Class<Integer> getKClass() {
        return Integer.class;
    }

    @Override
    public boolean canMakeUnique(IsofRecord isofRecord) {
        return false;
    }

    @Override
    public String describeObject(IsofRecord isofRecord) {
        return isofRecord.getGasPhaseQuantity();
    }

    @Override
    public IsofRecord get(IsofRecord isofRecord) {
        return this.get(isofRecord.getGasPhaseQuantity());
    }

    @Override
    public Task taskMakeUnique(IsofRecord isofRecord) {
        return null;
    }

    @Override
    public Task taskAddAll(Collection<? extends IsofRecord> collection) {
        return new APyroManAddTask<Integer, IsofRecord>((IPyroManager)this, collection){

            @Override
            public boolean add(IsofRecord isofRecord) {
                return IsofList.this.add(isofRecord);
            }

            @Override
            public boolean remove(IsofRecord isofRecord) {
                return IsofList.this.remove(isofRecord);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<IsofRecord> list, List<IsofRecord> list2) {
        return new APyroManReplaceTask<Integer, IsofRecord>((IPyroManager)this, list, list2){

            @Override
            public boolean add(IsofRecord isofRecord) {
                return IsofList.this.add(isofRecord);
            }

            @Override
            public boolean remove(IsofRecord isofRecord) {
                return IsofList.this.remove(isofRecord);
            }
        };
    }

    public Task taskClear() {
        return new APyroManClearTask<Integer, IsofRecord>((IPyroManager)this){

            @Override
            public void addAll(Collection<IsofRecord> collection) {
                IsofList.this.addAll(collection);
            }

            @Override
            public void removeAll(Collection<IsofRecord> collection) {
                IsofList.this.removeAll(collection);
            }
        };
    }
}

