/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.domain.AFDSFaceProps;
import pyrosim.legacy_2006_2.domain.AFDSObjectProps;
import pyrosim.legacy_2006_2.domain.AUnalignedFDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.rasterization.HoleFragGenerator;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Hole
extends AUnalignedFDSObject {
    static final long serialVersionUID = 1L;
    private static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);

    public Hole(String string) {
        super(string, (Material)null);
    }

    public Hole(UnitPoint2D unitPoint2D, UnitPoint2D unitPoint2D2, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3) {
        super(unitPoint2D, unitPoint2D2, unitDouble, unitDouble2, unitDouble3, null);
    }

    public static Hole fromLegacy(pyrosim.legacy_2006_2.legacy.v16.Hole hole) {
        Hole hole2 = new Hole(hole.getName());
        AUnalignedFDSObject.fromLegacy(hole, hole2);
        return hole2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Hole)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void imprint(Object object) {
        if (!(object instanceof Hole)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        Hole hole = (Hole)object;
        this.setColor(hole.getColor());
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void fillExtraRecords(FDSInputRecord fDSInputRecord) {
    }

    @Override
    protected void fillMaterialRecords(FDSInputRecord fDSInputRecord) {
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    protected IFDSFragGenerator getFaceFragGenerator(IFace iFace) {
        return new HoleFragGenerator(new AFDSFaceProps(iFace){

            @Override
            public boolean isThickened() {
                return false;
            }

            @Override
            public boolean permitsHoles() {
                return true;
            }

            @Override
            public boolean isSawtoothed() {
                return false;
            }
        });
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return new HoleFragGenerator(new AFDSObjectProps(this){

            @Override
            public boolean isThickened() {
                return false;
            }

            @Override
            public boolean permitsHoles() {
                return true;
            }

            @Override
            public boolean isSawtoothed() {
                return false;
            }
        });
    }

    @Override
    public void setColor(Color color) {
        if (color != null) {
            super.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 102));
        } else {
            super.setColor(null);
        }
    }

    @Override
    public String getFDSType() {
        return "HOLE";
    }

    @Override
    public void setMaterial(int n, Material material) {
    }

    @Override
    public Material getMaterial(int n) {
        return null;
    }

    @Override
    protected IFace createFace(byte by, Material material) {
        return new BlockFace(this, by, material);
    }

    @Override
    public String getTypeDescription() {
        return "Hole";
    }

    @Override
    public boolean dependsOnObject(IDependedOn iDependedOn) {
        if (iDependedOn instanceof Material) {
            return false;
        }
        return super.dependsOnObject(iDependedOn);
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> set, Class<IDependedOn> clazz) {
        if (Material.class.isAssignableFrom(clazz)) {
            return;
        }
        super.getObjectsDependedOn(set, clazz);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn iDependedOn, Object object) {
        if (iDependedOn instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnChanged(iDependedOn, object);
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn iDependedOn, IDependedOn iDependedOn2) {
        if (iDependedOn instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnReplaced(iDependedOn, iDependedOn2);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn iDependedOn, String string) {
        if (iDependedOn instanceof Material) {
            return null;
        }
        return super.taskUpdateBeforeDependedOnRenamed(iDependedOn, string);
    }

    public static class BlockFace
    extends AUnalignedFDSObject.BlockFace
    implements Serializable {
        static final long serialVersionUID = 1L;

        public BlockFace(Hole hole, byte by, Material material) {
            super(hole, by, material);
        }

        @Override
        protected Color getGeometryColor() {
            return this.getBlock().getColor() != null ? this.getBlock().getColor() : DEF_COLOR;
        }
    }
}

