/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.dependencies.APyroManReplaceDepOnTask;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class HeatDetectorList
extends APyroDomainManager<String, HeatDetector>
implements Serializable {
    static final long serialVersionUID = 1L;
    private Vector<HeatDetector> d_heatDetectors = new Vector();

    @Override
    public Collection<? extends HeatDetector> toCollection() {
        return new PyroCollection<String, HeatDetector>(this);
    }

    @Override
    protected boolean add(HeatDetector heatDetector) {
        HeatDetector heatDetector2 = this.get(heatDetector.getLabel());
        if (heatDetector2 != null) {
            return false;
        }
        super.add(heatDetector);
        boolean bl = this.d_heatDetectors.add(heatDetector);
        this.fireDomainEvent(new PyroDomainEvent<HeatDetectorList, HeatDetector>(this, heatDetector, HeatDetector.class, 3));
        return bl;
    }

    @Override
    protected boolean remove(HeatDetector heatDetector) {
        super.remove(heatDetector);
        this.d_heatDetectors.remove(heatDetector);
        this.fireDomainEvent(new PyroDomainEvent<HeatDetectorList, HeatDetector>(this, heatDetector, HeatDetector.class, 4));
        return true;
    }

    @Override
    public boolean contains(String string) {
        return this.indexOf(string) >= 0;
    }

    public int indexOf(String string) {
        int n = -1;
        for (int i = 0; i < this.size(); ++i) {
            HeatDetector heatDetector = this.d_heatDetectors.get(i);
            if (!heatDetector.getLabel().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    public HeatDetector get(String string) {
        int n = this.indexOf(string);
        if (n < 0) {
            return null;
        }
        return this.d_heatDetectors.get(n);
    }

    public HeatDetector getAt(int n) {
        if (n >= this.size() || n < 0) {
            return null;
        }
        return this.d_heatDetectors.get(n);
    }

    @Override
    public Iterator<HeatDetector> iterator() {
        return this.d_heatDetectors.iterator();
    }

    @Override
    public int size() {
        return this.d_heatDetectors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d_heatDetectors.isEmpty();
    }

    public HeatDetector[] toArray() {
        return this.toArray(new HeatDetector[this.d_heatDetectors.size()]);
    }

    public HeatDetector[] toArray(HeatDetector[] heatDetectorArray) {
        return this.d_heatDetectors.toArray(heatDetectorArray);
    }

    public static HeatDetectorList fromLegacy(pyrosim.legacy_2006_2.legacy.HeatDetectorList heatDetectorList) {
        HeatDetectorList heatDetectorList2 = new HeatDetectorList();
        for (Object e : heatDetectorList) {
            heatDetectorList2.add((HeatDetector)e);
        }
        return heatDetectorList2;
    }

    @Override
    public Class<HeatDetector> getVClass() {
        return HeatDetector.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(HeatDetector heatDetector) {
        return true;
    }

    @Override
    public Task taskMakeUnique(HeatDetector heatDetector) {
        return new AMakeUniqueNameTask<HeatDetector>(this.getDomains(), heatDetector){

            @Override
            protected Task taskMakeUnique(HeatDetector heatDetector) {
                return heatDetector.taskSetLabel(APyroDomainManager.getUniqueName(HeatDetectorList.this, heatDetector.getLabel()));
            }
        };
    }

    @Override
    public HeatDetector get(HeatDetector heatDetector) {
        return this.get(heatDetector.getLabel());
    }

    @Override
    public String describeObject(HeatDetector heatDetector) {
        return heatDetector.getLabel();
    }

    @Override
    public Task taskAddAll(Collection<? extends HeatDetector> collection) {
        return new APyroManAddTask<String, HeatDetector>((IPyroManager)this, collection){

            @Override
            public boolean add(HeatDetector heatDetector) {
                return HeatDetectorList.this.add(heatDetector);
            }

            @Override
            public boolean remove(HeatDetector heatDetector) {
                return HeatDetectorList.this.remove(heatDetector);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<HeatDetector> list, List<HeatDetector> list2) {
        return new APyroManReplaceDepOnTask<String, HeatDetector>((IPyroManager)this, list, list2, this.getDomains()){

            @Override
            public boolean add(HeatDetector heatDetector) {
                return HeatDetectorList.this.add(heatDetector);
            }

            @Override
            public boolean remove(HeatDetector heatDetector) {
                return HeatDetectorList.this.remove(heatDetector);
            }
        };
    }
}

