/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class HeatDetector
extends ADomainObject<PyroMod>
implements Serializable,
DisplayablePointObject,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_pLocation;
    private UnitDouble d_dRTI;
    private UnitDouble d_dActivationTemp;
    private String d_sLabel;

    public HeatDetector(UnitPoint3D unitPoint3D, UnitDouble unitDouble, UnitDouble unitDouble2, String string) {
        this.d_pLocation = unitPoint3D;
        this.d_dRTI = unitDouble;
        this.d_dActivationTemp = unitDouble2;
        this.d_sLabel = string;
    }

    @Override
    public UnitPoint3D getLocation() {
        return this.d_pLocation;
    }

    @Override
    public Color getColor() {
        return Color.red;
    }

    @Override
    public int getPointSize() {
        return 8;
    }

    public void setLocation(UnitPoint3D unitPoint3D) {
        this.d_pLocation = unitPoint3D;
        this.fireDomainEvent(new PyroDomainEvent(this, HeatDetector.class, 5), true);
    }

    public UnitDouble getRTI() {
        return this.d_dRTI;
    }

    public void setRTI(UnitDouble unitDouble) {
        this.d_dRTI = unitDouble;
        this.fireDomainEvent(new PyroDomainEvent(this, HeatDetector.class, 5), true);
    }

    public UnitDouble getActivationTemp() {
        return this.d_dActivationTemp;
    }

    public void setActivationTemp(UnitDouble unitDouble) {
        this.d_dActivationTemp = unitDouble;
        this.fireDomainEvent(new PyroDomainEvent(this, HeatDetector.class, 5), true);
    }

    public String getLabel() {
        return this.d_sLabel;
    }

    public Task taskSetLabel(String string) {
        return new AChangePyroDepOnIDTask(this, string, this.getDomains()){

            @Override
            public void setID(String string) {
                HeatDetector.this.setLabel(string);
            }
        };
    }

    private void setLabel(String string) {
        this.d_sLabel = string;
        this.fireDomainEvent(new PyroDomainEvent(this, HeatDetector.class, 5), false);
    }

    @Override
    public String getFDSType() {
        return "HEAT";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("HEAT");
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        Vector<Double> vector = new Vector<Double>(3);
        vector.add(new Double(this.d_pLocation.x(fdsSISystem.getLengthUnit())));
        vector.add(new Double(this.d_pLocation.y(fdsSISystem.getLengthUnit())));
        vector.add(new Double(this.d_pLocation.z(fdsSISystem.getLengthUnit())));
        fDSInputRecord.setValue("XYZ", vector);
        fDSInputRecord.setValue("RTI", new Double(this.d_dRTI.getValue(fdsSISystem.getRtiUnit())));
        fDSInputRecord.setValue("ACTIVATION_TEMPERATURE", new Double(this.d_dActivationTemp.getValue(fdsSISystem.getTempUnit())));
        fDSInputRecord.setValue("LABEL", this.d_sLabel);
        collection.add(fDSInputRecord);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof HeatDetector)) {
            return false;
        }
        HeatDetector heatDetector = (HeatDetector)object;
        return this.d_sLabel.equals(heatDetector.d_sLabel) && this.d_pLocation.equals(heatDetector.d_pLocation) && this.d_dRTI.equals(heatDetector.d_dRTI) && this.d_dActivationTemp.equals(heatDetector.d_dActivationTemp);
    }

    @Override
    public Object clone() {
        HeatDetector heatDetector = new HeatDetector((UnitPoint3D)this.d_pLocation.clone(), (UnitDouble)this.d_dRTI.clone(), (UnitDouble)this.d_dActivationTemp.clone(), this.d_sLabel);
        return heatDetector;
    }

    @Override
    public String getUniqueID() {
        return this.getLabel();
    }

    @Override
    public String getTypeDescription() {
        return "Heat Detector";
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    public boolean fireDomainEvent(IDomainEvent iDomainEvent, boolean bl) {
        this.pauseUpdates();
        boolean bl2 = super.fireDomainEvent(iDomainEvent);
        if (bl) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return bl2;
    }
}

