/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AAddTask;
import pyrosim.legacy_2006_2.domain.ARemoveTask;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.HeatActivationEvent;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class HeatActivationEventList
extends AbstractActivationEventList
implements ActivationEventList {
    static final long serialVersionUID = 1L;
    private LinkedList<ActivationEvent> d_lEvents = new LinkedList();
    private boolean d_bCanBeActivatedByAny = false;
    private boolean d_bCanBeDeactivatedByAny = false;

    public HeatActivationEventList(Set<PyroMod> set) {
        super(1, set);
    }

    private boolean addEvent(ActivationEvent activationEvent) {
        if (this.d_lEvents.contains(activationEvent)) {
            return false;
        }
        ADomainObject.addDomains(activationEvent, this.getDomains());
        return this.d_lEvents.add(activationEvent);
    }

    private boolean removeEvent(ActivationEvent activationEvent) {
        ADomainObject.removeDomains(activationEvent, this.getDomains());
        return this.d_lEvents.remove(activationEvent);
    }

    public Collection getAllEvents() {
        return this.d_lEvents;
    }

    @Override
    public int size() {
        return this.d_lEvents.size();
    }

    @Override
    public Collection getInputRecords(FDSInputRecord fDSInputRecord, Map map) {
        Vector<FDSInputRecord> vector = new Vector<FDSInputRecord>();
        FDSInputRecord fDSInputRecord2 = fDSInputRecord.getValue("T_OPEN") != null || fDSInputRecord.getValue("T_CLOSE") != null || fDSInputRecord.getValue("T_ACTIVATE") != null || fDSInputRecord.getValue("T_DEACTIVATE") != null || fDSInputRecord.getValue("HEAT_ACTIVATE") != null || fDSInputRecord.getValue("HEAT_DEACTIVATE") != null || fDSInputRecord.getValue("T_CREATE") != null || fDSInputRecord.getValue("T_REMOVE") != null || fDSInputRecord.getValue("HEAT_CREATE") != null || fDSInputRecord.getValue("HEAT_REMOVE") != null ? (FDSInputRecord)fDSInputRecord.clone() : fDSInputRecord;
        for (int i = 0; i < this.d_lEvents.size(); ++i) {
            fDSInputRecord2.removeValue("T_OPEN");
            fDSInputRecord2.removeValue("T_CLOSE");
            fDSInputRecord2.removeValue("T_ACTIVATE");
            fDSInputRecord2.removeValue("T_DEACTIVATE");
            fDSInputRecord2.removeValue("HEAT_ACTIVATE");
            fDSInputRecord2.removeValue("HEAT_DEACTIVATE");
            fDSInputRecord2.removeValue("T_CREATE");
            fDSInputRecord2.removeValue("T_REMOVE");
            fDSInputRecord2.removeValue("HEAT_CREATE");
            fDSInputRecord2.removeValue("HEAT_REMOVE");
            boolean bl = false;
            HeatActivationEvent heatActivationEvent = (HeatActivationEvent)this.d_lEvents.get(i);
            String string = (String)map.get(new Integer(heatActivationEvent.getAction()));
            if (heatActivationEvent.getAction() == 0) {
                if (!this.d_bCanBeActivatedByAny) {
                    fDSInputRecord2.setValue(string, ((HeatDetector)heatActivationEvent.getCriteria()).getLabel());
                    bl = true;
                }
            } else if (!this.d_bCanBeDeactivatedByAny) {
                fDSInputRecord2.setValue(string, ((HeatDetector)heatActivationEvent.getCriteria()).getLabel());
                bl = true;
            }
            if (!bl) continue;
            vector.add(fDSInputRecord2);
            fDSInputRecord2 = (FDSInputRecord)fDSInputRecord2.clone();
        }
        return vector;
    }

    @Override
    public Object clone() {
        HeatActivationEventList heatActivationEventList = (HeatActivationEventList)super.clone();
        heatActivationEventList.d_lEvents = new LinkedList();
        Collection collection = this.getAllEvents();
        for (ActivationEvent activationEvent : collection) {
            heatActivationEventList.addEvent((ActivationEvent)activationEvent.clone());
        }
        return heatActivationEventList;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof HeatActivationEventList)) {
            return false;
        }
        HeatActivationEventList heatActivationEventList = (HeatActivationEventList)object;
        if (heatActivationEventList.d_lEvents.size() != this.d_lEvents.size()) {
            return false;
        }
        for (int i = 0; i < this.d_lEvents.size(); ++i) {
            if (this.d_lEvents.get(i).equals(heatActivationEventList.d_lEvents.get(i))) continue;
            return false;
        }
        return true;
    }

    public void setCanBeTriggeredByAny(boolean bl, int n) {
        if (n == 0) {
            this.d_bCanBeActivatedByAny = bl;
        } else {
            this.d_bCanBeDeactivatedByAny = bl;
        }
    }

    public boolean getCanBeTriggeredByAny(int n) {
        if (n == 0) {
            return this.d_bCanBeActivatedByAny;
        }
        return this.d_bCanBeDeactivatedByAny;
    }

    @Override
    public Task taskRemoveEvent(ActivationEvent activationEvent) {
        return new ARemoveTask<HeatActivationEvent>(this.getDomains(), new VectorFromArray<HeatActivationEvent>((HeatActivationEvent)activationEvent)){

            @Override
            protected boolean remove(HeatActivationEvent heatActivationEvent) {
                return HeatActivationEventList.this.removeEvent(heatActivationEvent);
            }

            @Override
            protected boolean add(HeatActivationEvent heatActivationEvent) {
                return HeatActivationEventList.this.addEvent(heatActivationEvent);
            }
        };
    }

    @Override
    public Task taskAddEvent(ActivationEvent activationEvent) {
        return new AAddTask<HeatActivationEvent>(this.getDomains(), new VectorFromArray<HeatActivationEvent>((HeatActivationEvent)activationEvent)){

            @Override
            protected boolean remove(HeatActivationEvent heatActivationEvent) {
                return HeatActivationEventList.this.removeEvent(heatActivationEvent);
            }

            @Override
            protected boolean add(HeatActivationEvent heatActivationEvent) {
                return HeatActivationEventList.this.addEvent(heatActivationEvent);
            }
        };
    }

    public String getTypeDescription() {
        return null;
    }
}

