/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.AOrdPyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.AOrderedPyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddAtIndexTask;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.IOrderedPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class GridList
extends AOrderedPyroDomainManager<String, Grid> {
    private Vector<Grid> d_grids;

    public GridList(PyroMod pyroMod) {
    }

    public void setGrids(Vector<Grid> vector) {
        this.d_grids = vector;
    }

    @Override
    public Collection<? extends Grid> toCollection() {
        return new PyroCollection<String, Grid>(this);
    }

    protected boolean add(Grid grid, int n) {
        assert (n >= 0 && n <= this.size());
        Grid grid2 = this.get(grid.getName());
        if (grid2 != null) {
            return false;
        }
        super.add(grid);
        this.d_grids.insertElementAt(grid, n);
        this.fireDomainEvent(new GridDomainEvent(this, grid, 3));
        return true;
    }

    @Override
    protected boolean add(Grid grid) {
        return this.add(grid, this.d_grids.size());
    }

    protected Grid remove(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        Grid grid = this.d_grids.get(n);
        super.remove(grid);
        this.d_grids.remove(n);
        this.fireDomainEvent(new GridDomainEvent(this, grid, 4));
        return grid;
    }

    @Override
    protected boolean remove(Grid grid) {
        int n = this.indexOf(grid);
        if (n < 0) {
            return false;
        }
        return this.remove(n) != null;
    }

    private boolean removeAll(Collection<? extends Grid> collection) {
        this.pauseUpdates();
        boolean bl = true;
        for (Grid grid : collection) {
            if (this.remove(grid)) continue;
            bl = false;
        }
        this.resumeUpdates();
        return bl;
    }

    @Override
    public boolean contains(String string) {
        return this.get(string) != null;
    }

    @Override
    public Grid get(String string) {
        for (Grid grid : this.d_grids) {
            if (!grid.getName().equals(string)) continue;
            return grid;
        }
        return null;
    }

    @Override
    public Grid get(int n) {
        return this.d_grids.get(n);
    }

    @Override
    public int size() {
        return this.d_grids.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d_grids.isEmpty();
    }

    public Grid[] toArray() {
        return this.d_grids.toArray(new Grid[this.d_grids.size()]);
    }

    public Grid[] toArray(Grid[] gridArray) {
        return this.d_grids.toArray(gridArray);
    }

    @Override
    public Iterator<Grid> iterator() {
        return this.d_grids.iterator();
    }

    @Override
    public Class<Grid> getVClass() {
        return Grid.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(Grid grid) {
        return true;
    }

    @Override
    public String describeObject(Grid grid) {
        return grid.getName();
    }

    @Override
    public Grid get(Grid grid) {
        return this.get(grid.getName());
    }

    public String getUniqueName(String string) {
        return GridList.getUniqueName(this, string);
    }

    @Override
    public Task taskMakeUnique(Grid grid) {
        return new AMakeUniqueNameTask<Grid>(this.getDomains(), grid){

            @Override
            protected Task taskMakeUnique(Grid grid) {
                return grid.taskSetName(APyroDomainManager.getUniqueName(GridList.this, grid.getName()));
            }
        };
    }

    @Override
    public Task taskAddAll(Collection<? extends Grid> collection) {
        return new APyroManAddTask<String, Grid>((IPyroManager)this, collection){

            @Override
            public boolean add(Grid grid) {
                return GridList.this.add(grid);
            }

            @Override
            public boolean remove(Grid grid) {
                return GridList.this.remove(grid);
            }
        };
    }

    @Override
    public Task taskAddAll(Collection<? extends Grid> collection, int n) {
        return new APyroManAddAtIndexTask<String, Grid>((IPyroManager)this, collection, n){

            @Override
            public void removeAll(Collection<? extends Grid> collection) {
                GridList.this.removeAll(collection);
            }

            @Override
            public boolean add(Grid grid, int n) {
                return GridList.this.add(grid, n);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<Grid> list, List<Grid> list2) {
        return new AOrdPyroManReplaceTask<String, Grid>((IOrderedPyroManager)this, list, list2){

            @Override
            public void add(Grid grid, int n) {
                GridList.this.add(grid, n);
            }

            @Override
            public void remove(int n) {
                GridList.this.remove(n);
            }
        };
    }

    public Task taskReorder(Grid grid, int n) {
        return new ReorderTask(this, grid, n);
    }

    private static class ReorderTask
    extends ATask {
        private final GridList d_gList;
        private final Grid d_grid;
        private int d_nextIx;
        private int d_lastIx;

        public ReorderTask(GridList gridList, Grid grid, int n) {
            super(0, true);
            this.d_gList = gridList;
            this.d_grid = grid;
            this.d_nextIx = n;
            this.d_lastIx = gridList.indexOf(grid);
        }

        @Override
        public void undo() {
            this.run();
        }

        @Override
        public void run() {
            assert (this.d_gList.get(this.d_lastIx) == this.d_grid);
            this.d_gList.remove(this.d_grid);
            this.d_gList.add(this.d_grid, this.d_nextIx);
            int n = this.d_lastIx;
            this.d_lastIx = this.d_nextIx;
            this.d_nextIx = n;
            this.d_gList.fireDomainEvent(new GridDomainEvent(this.d_grid, 2));
        }
    }
}

