/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.GridList;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class Grid
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_minPoint;
    private UnitPoint3D d_maxPoint;
    private UnitDouble[] d_x;
    private UnitDouble[] d_y;
    private UnitDouble[] d_z;
    private String d_name = null;
    private Vector<Vent> d_attachedVents;
    private UnitDouble d_minxyDim;
    private static final Hashtable<String, ValueRange> d_ranges = new Hashtable(2);

    public static ValueRange getValueRange(String string) {
        return d_ranges.get(string);
    }

    public Grid(String string) {
        UnitPoint3D unitPoint3D = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
        UnitPoint3D unitPoint3D2 = new UnitPoint3D(10.0, 10.0, 3.0, SI.METER);
        this.init(unitPoint3D, unitPoint3D2, Grid.makeUniformDivisions(20, unitPoint3D.xu(), unitPoint3D2.xu()), Grid.makeUniformDivisions(20, unitPoint3D.yu(), unitPoint3D2.yu()), Grid.makeUniformDivisions(6, unitPoint3D.zu(), unitPoint3D2.zu()), string);
    }

    public Grid(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, int n, int n2, int n3, String string) {
        this.init(unitPoint3D, unitPoint3D2, Grid.makeUniformDivisions(n, unitPoint3D.xu(), unitPoint3D2.xu()), Grid.makeUniformDivisions(n2, unitPoint3D.yu(), unitPoint3D2.yu()), Grid.makeUniformDivisions(n3, unitPoint3D.zu(), unitPoint3D2.zu()), string);
    }

    public Grid(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, UnitDouble[] unitDoubleArray, UnitDouble[] unitDoubleArray2, UnitDouble[] unitDoubleArray3, String string) {
        this.init(unitPoint3D, unitPoint3D2, unitDoubleArray, unitDoubleArray2, unitDoubleArray3, string);
    }

    private void init(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, UnitDouble[] unitDoubleArray, UnitDouble[] unitDoubleArray2, UnitDouble[] unitDoubleArray3, String string) {
        this.d_minPoint = unitPoint3D;
        this.d_maxPoint = unitPoint3D2;
        this.d_x = unitDoubleArray;
        this.d_y = unitDoubleArray2;
        this.d_z = unitDoubleArray3;
        this.d_attachedVents = new Vector();
        this.d_name = string;
        this.d_minxyDim = new UnitDouble(Math.min(this.getMinSpace(this.d_x), this.getMinSpace(this.d_y)), this.d_x[0].getUnit());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_minxyDim == null) {
            this.d_minxyDim = new UnitDouble(Math.min(this.getMinSpace(this.d_x), this.getMinSpace(this.d_y)), this.d_x[0].getUnit());
        }
    }

    private double getMinSpace(UnitDouble[] unitDoubleArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < unitDoubleArray.length; ++i) {
            d = Math.min(d, unitDoubleArray[i].getValue(unitDoubleArray[i].getUnit()));
        }
        return d;
    }

    @Override
    public Object clone() {
        Grid grid = (Grid)super.clone();
        grid.imprint(this);
        return grid;
    }

    public Task taskImprint(Grid grid) {
        return new ImprintGridTask(this, grid);
    }

    public void imprint(Grid grid) {
        int n;
        assert (this != grid);
        this.pauseUpdates(false);
        this.d_name = grid.d_name;
        this.d_minPoint = (UnitPoint3D)grid.d_minPoint.clone();
        this.d_maxPoint = (UnitPoint3D)grid.d_maxPoint.clone();
        this.d_x = new UnitDouble[grid.d_x.length];
        for (n = 0; n < grid.d_x.length; ++n) {
            this.d_x[n] = (UnitDouble)grid.d_x[n].clone();
        }
        this.d_y = new UnitDouble[grid.d_y.length];
        for (n = 0; n < grid.d_y.length; ++n) {
            this.d_y[n] = (UnitDouble)grid.d_y[n].clone();
        }
        this.d_z = new UnitDouble[grid.d_z.length];
        for (n = 0; n < grid.d_z.length; ++n) {
            this.d_z[n] = (UnitDouble)grid.d_z[n].clone();
        }
        if (grid.d_attachedVents != null) {
            this.d_attachedVents = new Vector(grid.d_attachedVents.size());
            for (Vent vent : grid.d_attachedVents) {
                this.d_attachedVents.add(vent);
            }
        } else {
            this.d_attachedVents = null;
        }
        this.d_minxyDim = new UnitDouble(Math.min(this.getMinSpace(this.d_x), this.getMinSpace(this.d_y)), this.d_x[0].getUnit());
        System.out.println("updating grid " + this.getDomains().size());
        this.resumeUpdates(new GridDomainEvent(this, 5));
    }

    public UnitDouble getMinXYDim() {
        return this.d_minxyDim;
    }

    @Override
    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Grid)) {
            return false;
        }
        Grid grid = (Grid)object;
        if (this.d_x.length != grid.d_x.length || this.d_y.length != grid.d_y.length || this.d_z.length != grid.d_z.length) {
            return false;
        }
        for (n = 0; n < this.d_x.length; ++n) {
            if (this.d_x[n].equals(grid.d_x[n])) continue;
            return false;
        }
        for (n = 0; n < this.d_y.length; ++n) {
            if (this.d_y[n].equals(grid.d_y[n])) continue;
            return false;
        }
        for (n = 0; n < this.d_z.length; ++n) {
            if (this.d_z[n].equals(grid.d_z[n])) continue;
            return false;
        }
        n = this.d_name.equalsIgnoreCase(grid.d_name) && (this.d_minPoint == null ? grid.d_minPoint == null : this.d_minPoint.equals(grid.d_minPoint)) && (this.d_maxPoint == null ? grid.d_maxPoint == null : this.d_maxPoint.equals(grid.d_maxPoint)) && (this.d_attachedVents == null ? grid.d_attachedVents == null : this.d_attachedVents.equals(grid.d_attachedVents)) ? 1 : 0;
        return n != 0;
    }

    public static UnitDouble[] makeUniformDivisions(int n, UnitDouble unitDouble, UnitDouble unitDouble2) {
        Object[] objectArray = new UnitDouble[n];
        BaseUnit baseUnit = SI.METER;
        double d = (unitDouble2.getValue(baseUnit) - unitDouble.getValue(baseUnit)) / (double)n;
        Arrays.fill(objectArray, new UnitDouble(d, baseUnit));
        return objectArray;
    }

    private void setName(String string) {
        this.d_name = string;
        this.fireDomainEvent(new GridDomainEvent(this, 5));
    }

    public Task taskSetName(String string) {
        return new ASetNameTask(string){

            @Override
            public void setName(String string) {
                Grid.this.setName(string);
            }

            @Override
            protected String getName() {
                return Grid.this.getName();
            }
        };
    }

    public String getName() {
        return this.d_name;
    }

    public UnitPoint3D getMinPoint() {
        return this.d_minPoint;
    }

    public UnitPoint3D getMaxPoint() {
        return this.d_maxPoint;
    }

    public UnitDouble[] getXDivisions() {
        return this.d_x;
    }

    public UnitDouble[] getYDivisions() {
        return this.d_y;
    }

    public UnitDouble[] getZDivisions() {
        return this.d_z;
    }

    private UnitDouble[] convertDivisionsToPositions(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble[] unitDoubleArray) {
        UnitDouble[] unitDoubleArray2 = new UnitDouble[unitDoubleArray.length + 1];
        unitDoubleArray2[0] = unitDouble;
        for (int i = 1; i < unitDoubleArray2.length; ++i) {
            unitDoubleArray2[i] = (UnitDouble)unitDoubleArray2[i - 1].clone();
            unitDoubleArray2[i] = unitDoubleArray2[i].add(unitDoubleArray[i - 1]);
        }
        return unitDoubleArray2;
    }

    public UnitDouble[] getXLinePositions() {
        return this.convertDivisionsToPositions(this.d_minPoint.xu(), this.d_maxPoint.xu(), this.d_x);
    }

    public UnitDouble[] getYLinePositions() {
        return this.convertDivisionsToPositions(this.d_minPoint.yu(), this.d_maxPoint.yu(), this.d_y);
    }

    public UnitDouble[] getZLinePositions() {
        return this.convertDivisionsToPositions(this.d_minPoint.zu(), this.d_maxPoint.zu(), this.d_z);
    }

    @Override
    public String getFDSType() {
        return "GRID";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        double d;
        int n;
        double[] dArray = new double[this.d_x.length];
        double[] dArray2 = new double[this.d_y.length];
        double[] dArray3 = new double[this.d_z.length];
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Unit unit = FdsSISystem.getInstance().getLengthUnit();
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = this.d_x[n].getValue(unit);
            if (dArray[n] == dArray[0]) continue;
            bl = false;
        }
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = this.d_y[n].getValue(unit);
            if (dArray2[n] == dArray2[0]) continue;
            bl2 = false;
        }
        for (n = 0; n < dArray3.length; ++n) {
            dArray3[n] = this.d_z[n].getValue(unit);
            if (dArray3[n] == dArray3[0]) continue;
            bl3 = false;
        }
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setComment(this.d_name);
        fDSInputRecord.setType("GRID");
        fDSInputRecord.setValue("IBAR", new Integer(this.d_x.length));
        fDSInputRecord.setValue("JBAR", new Integer(this.d_y.length));
        fDSInputRecord.setValue("KBAR", new Integer(this.d_z.length));
        collection.add(fDSInputRecord);
        FDSInputRecord fDSInputRecord2 = new FDSInputRecord();
        fDSInputRecord2.setComment(this.d_name);
        fDSInputRecord2.setType("PDIM");
        fDSInputRecord2.setValue("XBAR0", new Double(this.getMinPoint().x(unit)));
        fDSInputRecord2.setValue("YBAR0", new Double(this.getMinPoint().y(unit)));
        fDSInputRecord2.setValue("ZBAR0", new Double(this.getMinPoint().z(unit)));
        fDSInputRecord2.setValue("XBAR", new Double(this.getMaxPoint().x(unit)));
        fDSInputRecord2.setValue("YBAR", new Double(this.getMaxPoint().y(unit)));
        fDSInputRecord2.setValue("ZBAR", new Double(this.getMaxPoint().z(unit)));
        collection.add(fDSInputRecord2);
        if (!bl) {
            d = this.getMaxPoint().x(unit) - this.getMinPoint().x(unit);
            this.addTRNRecords(collection, this.getMinPoint().x(unit), dArray, d, "TRNX");
        }
        if (!bl2) {
            d = this.getMaxPoint().y(unit) - this.getMinPoint().y(unit);
            this.addTRNRecords(collection, this.getMinPoint().y(unit), dArray2, d, "TRNY");
        }
        if (!bl3) {
            d = this.getMaxPoint().z(unit) - this.getMinPoint().z(unit);
            this.addTRNRecords(collection, this.getMinPoint().z(unit), dArray3, d, "TRNZ");
        }
    }

    private void addTRNRecords(Collection collection, double d, double[] dArray, double d2, String string) {
        if (dArray.length <= 0) {
            return;
        }
        PyroMod pyroMod = (PyroMod)this.getDomains().iterator().next();
        GridList gridList = pyroMod.getGridManager();
        int n = gridList.indexOf(this) + 1;
        double d3 = dArray.length;
        double d4 = 1.0;
        double d5 = dArray[0];
        double d6 = d + d5;
        double d7 = d;
        int n2 = 1;
        while ((double)n2 < d3) {
            if (dArray[n2] == d5) {
                d4 += 1.0;
            } else {
                double d8 = d7 + d4 * d2 / d3;
                FDSInputRecord fDSInputRecord = new FDSInputRecord();
                fDSInputRecord.setComment(this.d_name);
                fDSInputRecord.setType(string);
                fDSInputRecord.setValue("CC", new Double(d8));
                fDSInputRecord.setValue("PC", new Double(d6));
                fDSInputRecord.setValue("MESH_NUMBER", new Integer(n));
                collection.add(fDSInputRecord);
                d4 = 1.0;
                d5 = dArray[n2];
                d7 = d8;
            }
            d6 += dArray[n2];
            ++n2;
        }
    }

    public int ventIndex(Vent vent) {
        for (int i = 0; i < this.d_attachedVents.size(); ++i) {
            if (!vent.equals(this.d_attachedVents.get(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean attachVent(Vent vent) {
        if (this.ventIndex(vent) >= 0) {
            return false;
        }
        this.d_attachedVents.add(vent);
        return true;
    }

    public boolean detachVent(Vent vent) {
        int n = this.ventIndex(vent);
        if (n < 0) {
            return false;
        }
        this.d_attachedVents.remove(n);
        return true;
    }

    @Override
    public String getTypeDescription() {
        return "Grid";
    }

    public String getUniqueID() {
        return this.getName();
    }

    public Object getUniqueTypeKey() {
        return "Grid";
    }

    static {
        d_ranges.put("IBAR", IntValueRange.createCheckedMin(1, false));
        d_ranges.put("JBAR", IntValueRange.createCheckedMin(1, false));
        d_ranges.put("KBAR", IntValueRange.createCheckedMin(1, false));
    }

    private static class ImprintGridTask
    implements Task {
        private final Grid d_target;
        private final Grid d_holder;
        private final Grid d_newData;

        public ImprintGridTask(Grid grid, Grid grid2) {
            this.d_target = grid;
            this.d_newData = grid2;
            this.d_holder = new Grid(grid.getName());
            this.d_holder.imprint(grid);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            this.d_target.imprint(this.d_holder);
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void run() {
            this.d_target.imprint(this.d_newData);
        }
    }
}

