/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectIterator;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.events.FloorDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class FloorManager
extends APyroDomainManager<String, Floor> {
    private Hashtable<String, Floor> d_floors;

    public FloorManager(PyroMod pyroMod) {
    }

    public void setFloors(Hashtable<String, Floor> hashtable) {
        this.d_floors = hashtable;
    }

    public Task taskAddDefaultFloor() {
        Floor floor = new Floor("Default", 0.0, 3.0, SI.METER, null);
        return this.taskAdd(floor);
    }

    public Task taskAddFloorFromObst(final Collection<? extends FDSObject> collection) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                UnitPoint3D unitPoint3D = FDSComposite.getMinPoint(new FDSObjectIterator(collection, false));
                UnitPoint3D unitPoint3D2 = FDSComposite.getMaxPoint(new FDSObjectIterator(collection, false));
                Floor floor = new Floor("Floor", unitPoint3D.zu(), unitPoint3D2.zu(), null);
                this.addTask(FloorManager.this.taskMakeUnique(floor));
                this.addTask(FloorManager.this.taskAdd(floor));
            }
        };
    }

    @Override
    protected boolean add(Floor floor) {
        if (this.d_floors.containsKey(floor.getName())) {
            return false;
        }
        this.d_floors.put(floor.getName(), floor);
        super.add(floor);
        this.fireDomainEvent(new FloorDomainEvent(this, floor, 3));
        return true;
    }

    @Override
    protected boolean remove(Floor floor) {
        Floor floor2 = this.d_floors.remove(floor.getName());
        if (floor2 == null) {
            return false;
        }
        super.remove(floor2);
        this.fireDomainEvent(new FloorDomainEvent(this, floor, 4));
        return true;
    }

    @Override
    public Task taskAddAll(Collection<? extends Floor> collection) {
        return new APyroManAddTask<String, Floor>((IPyroManager)this, collection){

            @Override
            public boolean add(Floor floor) {
                return FloorManager.this.add(floor);
            }

            @Override
            public boolean remove(Floor floor) {
                return FloorManager.this.remove(floor);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<Floor> list, List<Floor> list2) {
        return new APyroManReplaceTask<String, Floor>((IPyroManager)this, list, list2){

            @Override
            public boolean add(Floor floor) {
                return FloorManager.this.add(floor);
            }

            @Override
            public boolean remove(Floor floor) {
                return FloorManager.this.remove(floor);
            }
        };
    }

    @Override
    public boolean contains(String string) {
        return this.get(string) != null;
    }

    @Override
    public Floor get(String string) {
        return this.d_floors.get(string);
    }

    @Override
    public Floor get(Floor floor) {
        return this.get(floor.getName());
    }

    @Override
    public boolean canMakeUnique(Floor floor) {
        return true;
    }

    @Override
    public Task taskMakeUnique(Floor floor) {
        return new AMakeUniqueNameTask<Floor>(this.getDomains(), floor){

            @Override
            protected Task taskMakeUnique(Floor floor) {
                return floor.taskSetName(APyroDomainManager.getUniqueName(FloorManager.this, floor.getName()));
            }
        };
    }

    @Override
    public String describeObject(Floor floor) {
        return floor.getName();
    }

    @Override
    public int size() {
        return this.d_floors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d_floors.isEmpty();
    }

    public Floor[] toArray() {
        return this.d_floors.values().toArray(new Floor[this.size()]);
    }

    public Floor[] toArray(Floor[] floorArray) {
        return this.d_floors.values().toArray(floorArray);
    }

    @Override
    public Class<Floor> getVClass() {
        return Floor.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public Collection<? extends Floor> toCollection() {
        return this.d_floors.values();
    }

    @Override
    public Iterator<Floor> iterator() {
        return this.d_floors.values().iterator();
    }
}

