/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.ModelImage;
import pyrosim.legacy_2006_2.events.FloorDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.WeakHashSet;

public class Floor
implements Serializable,
IPyroObject {
    static final long serialVersionUID = 1L;
    private String d_name;
    private UnitDouble d_bottom;
    private UnitDouble d_top;
    private ModelImage d_bgImage;
    public static final int OUTSIDE = 0;
    public static final int INSIDE = 1;
    public static final int PART_INSIDE = 2;
    public static final int FLOOR = 3;
    private transient Set<FDSObject> d_roomObjs = new WeakHashSet<FDSObject>();
    private transient Set<FDSObject> d_floorObjs = new WeakHashSet<FDSObject>();
    private transient Set<DisplayablePointObject> d_pointObjs = new WeakHashSet<DisplayablePointObject>();
    private transient ADomainObject<PyroMod> d_domainHelper = new ADomainObject();

    public Floor(String string, double d, double d2, Unit unit, ModelImage modelImage) {
        this(string, new UnitDouble(d, unit), new UnitDouble(d2, unit), modelImage);
    }

    public Floor(String string, UnitDouble unitDouble, UnitDouble unitDouble2, ModelImage modelImage) {
        this.set(string, unitDouble, unitDouble2, modelImage);
    }

    @Override
    public Object clone() {
        try {
            Floor floor = (Floor)super.clone();
            floor.d_bottom = (UnitDouble)this.d_bottom.clone();
            floor.d_top = (UnitDouble)this.d_top.clone();
            floor.d_bgImage = (ModelImage)this.d_bgImage.clone();
            floor.d_domainHelper = new ADomainObject();
            return floor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.d_roomObjs = new WeakHashSet<FDSObject>();
        this.d_floorObjs = new WeakHashSet<FDSObject>();
        this.d_pointObjs = new WeakHashSet<DisplayablePointObject>();
        this.d_domainHelper = new ADomainObject();
    }

    public String getName() {
        return this.d_name;
    }

    private void setName(String string) {
        this.d_name = string;
        this.d_domainHelper.fireDomainEvent(new FloorDomainEvent(this, 5));
    }

    public Task taskSetName(String string) {
        return new ASetNameTask(string){

            @Override
            public void setName(String string) {
                Floor.this.setName(string);
            }

            @Override
            protected String getName() {
                return Floor.this.getName();
            }
        };
    }

    public UnitDouble getBottom() {
        return this.d_bottom;
    }

    public UnitDouble getTop() {
        return this.d_top;
    }

    public ModelImage getBgImage() {
        return this.d_bgImage;
    }

    public void set(String string, UnitDouble unitDouble, UnitDouble unitDouble2, ModelImage modelImage) {
        this.d_domainHelper.pauseUpdates(false);
        this.d_name = string;
        if (!unitDouble.equals(this.d_bottom)) {
            this.d_bottom = unitDouble;
        }
        if (!unitDouble2.equals(this.d_top)) {
            this.d_top = unitDouble2;
        }
        this.setBgImage(modelImage);
        this.d_domainHelper.resumeUpdates(new FloorDomainEvent(this, 5));
    }

    public void setBgImage(ModelImage modelImage) {
        this.d_bgImage = modelImage;
        if (this.d_bgImage != null) {
            this.d_bgImage.setZLocationModel(this.getBottom());
        }
        this.d_domainHelper.fireDomainEvent(new FloorDomainEvent(this, 5));
    }

    public void clearCachedPointObjects() {
        this.d_pointObjs.clear();
    }

    public void clearCachedFDSObjects() {
        this.d_roomObjs.clear();
        this.d_floorObjs.clear();
    }

    public void clearAllCachedObjects() {
        this.clearCachedPointObjects();
        this.clearCachedFDSObjects();
    }

    public void filterObjects(Collection<? extends FDSObject> collection) {
        for (FDSObject fDSObject : collection) {
            if (fDSObject instanceof FDSComposite) {
                FDSComposite fDSComposite = (FDSComposite)fDSObject;
                this.filterObjects(fDSComposite.toCollection());
                continue;
            }
            int n = this.whereIs(fDSObject);
            if (n == 1 || n == 2) {
                this.d_floorObjs.remove(fDSObject);
                this.d_roomObjs.add(fDSObject);
                continue;
            }
            if (n == 3) {
                this.d_roomObjs.remove(fDSObject);
                this.d_floorObjs.add(fDSObject);
                continue;
            }
            if (n != 0) continue;
            this.d_floorObjs.remove(fDSObject);
            this.d_roomObjs.remove(fDSObject);
        }
    }

    public void filterPointObjects(Collection<? extends DisplayablePointObject> collection) {
        for (DisplayablePointObject displayablePointObject : collection) {
            int n = this.whereIs(displayablePointObject);
            if (n == 1) {
                this.d_pointObjs.add(displayablePointObject);
                continue;
            }
            this.d_pointObjs.remove(displayablePointObject);
        }
    }

    public void removeFilteredPointObjects(Collection<? extends DisplayablePointObject> collection) {
        this.d_pointObjs.removeAll(collection);
    }

    public void removeFilteredObjects(Collection<? extends FDSObject> collection) {
        for (FDSObject fDSObject : collection) {
            if (fDSObject instanceof FDSComposite) {
                FDSComposite fDSComposite = (FDSComposite)fDSObject;
                this.removeFilteredObjects(fDSComposite.toCollection());
                continue;
            }
            this.d_floorObjs.remove(fDSObject);
            this.d_roomObjs.remove(fDSObject);
        }
    }

    public int whereIs(FDSObject fDSObject) {
        UnitDouble unitDouble = fDSObject.getMinPoint().zu();
        UnitDouble unitDouble2 = fDSObject.getMaxPoint().zu();
        int n = unitDouble.compareTo(this.d_top);
        if (n >= 0) {
            return 0;
        }
        int n2 = unitDouble2.compareTo(this.d_bottom);
        if (n2 < 0) {
            return 0;
        }
        if (n2 == 0) {
            return 3;
        }
        if (unitDouble2.compareTo(this.d_top) > 0 || unitDouble.compareTo(this.d_bottom) < 0) {
            return 2;
        }
        return 1;
    }

    public int whereIs(DisplayablePointObject displayablePointObject) {
        UnitDouble unitDouble = displayablePointObject.getLocation().zu();
        if (unitDouble.compareTo(this.d_top) >= 0 || unitDouble.compareTo(this.d_bottom) < 0) {
            return 0;
        }
        return 1;
    }

    public Set<FDSObject> getFloorObstructions() {
        return this.d_floorObjs;
    }

    public Set<FDSObject> getRoomItems() {
        return this.d_roomObjs;
    }

    public Set<DisplayablePointObject> getPointObjects() {
        return this.d_pointObjs;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Floor)) {
            return false;
        }
        Floor floor = (Floor)object;
        boolean bl = (floor.d_bgImage == null ? this.d_bgImage == null : floor.d_bgImage.equals(this.d_bgImage)) && floor.d_bottom.equals(this.d_bottom) && floor.d_top.equals(this.d_top) && floor.d_name.equals(this.d_name);
        return bl;
    }

    public static void sortByName(Floor[] floorArray) {
        Arrays.sort(floorArray, new CompareName());
    }

    public static void sortByLevel(Floor[] floorArray) {
        Arrays.sort(floorArray, new CompareLevel());
    }

    @Override
    public void addDomain(PyroMod pyroMod) {
        this.d_domainHelper.addDomain(pyroMod);
    }

    @Override
    public void removeDomain(PyroMod pyroMod) {
        this.d_domainHelper.removeDomain(pyroMod);
    }

    @Override
    public Set<PyroMod> getDomains() {
        return this.d_domainHelper.getDomains();
    }

    @Override
    public String getTypeDescription() {
        return "Floor";
    }

    static class CompareLevel
    implements Comparator {
        CompareLevel() {
        }

        public int compare(Object object, Object object2) {
            BaseUnit baseUnit = SI.METER;
            return Double.compare(((Floor)object).d_bottom.getValue(baseUnit), ((Floor)object2).d_bottom.getValue(baseUnit));
        }
    }

    static class CompareName
    implements Comparator {
        CompareName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Floor)object).d_name;
            String string2 = ((Floor)object2).d_name;
            return string.compareToIgnoreCase(string2);
        }
    }
}

