/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class FilterObstructionsTask
implements Task {
    private final PyroMod d_mediator;
    private final Collection<FDSObject> d_selObjs;
    private boolean[] d_oldVisible;
    private final FDSObject[] d_allObjs;

    public FilterObstructionsTask(PyroMod pyroMod, FDSObject[] fDSObjectArray) {
        this.d_mediator = pyroMod;
        this.d_selObjs = FDSComposite.toCollection(fDSObjectArray);
        this.d_allObjs = this.d_mediator.getFDSObjectManager().toArray();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        int n = 0;
        for (FDSObject fDSObject : this.d_allObjs) {
            fDSObject.setVisible(this.d_oldVisible[n++]);
        }
        this.d_oldVisible = null;
        this.d_mediator.resumeUpdates();
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void run() {
        this.d_oldVisible = new boolean[this.d_allObjs.length];
        this.d_mediator.pauseUpdates();
        int n = 0;
        for (FDSObject fDSObject : this.d_allObjs) {
            this.d_oldVisible[n++] = fDSObject.isVisible();
            fDSObject.setVisible(false);
        }
        for (FDSObject fDSObject : this.d_selObjs) {
            fDSObject.setVisible(true);
        }
        this.d_mediator.resumeUpdates();
    }
}

