/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectIterator;

public class FDSObjectTypeIterator<T extends FDSObject>
implements Iterator<T> {
    private final FDSObjectIterator d_it;

    public FDSObjectTypeIterator(FDSComposite fDSComposite, boolean bl, Class<T> clazz) {
        this.d_it = new FDSObjectIterator(fDSComposite, bl);
        this.initFilter(clazz);
    }

    public FDSObjectTypeIterator(FDSObject[] fDSObjectArray, boolean bl, Class<T> clazz) {
        this.d_it = new FDSObjectIterator(fDSObjectArray, bl);
        this.initFilter(clazz);
    }

    public FDSObjectTypeIterator(Collection<? extends FDSObject> collection, boolean bl, Class<T> clazz) {
        this.d_it = new FDSObjectIterator(collection, bl);
        this.initFilter(clazz);
    }

    private void initFilter(Class<T> clazz) {
        if (clazz.equals(FDSObject.class)) {
            this.d_it.setFilter(new FDSObjectTypeFilter<T>(this.d_it, clazz));
        } else {
            this.d_it.setFilter(new TypeFilter<T>(this.d_it, clazz));
        }
    }

    @Override
    public boolean hasNext() {
        return this.d_it.hasNext();
    }

    @Override
    public T next() {
        TypeFilter typeFilter = (TypeFilter)this.d_it.getFilter();
        return (T)((FDSObject)typeFilter.d_type.cast(this.d_it.next()));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class FDSObjectTypeFilter<TT extends FDSObject>
    extends TypeFilter<TT> {
        private final FDSObjectIterator.DefaultObjectFilter d_defObjFilter;

        public FDSObjectTypeFilter(FDSObjectIterator fDSObjectIterator, Class<TT> clazz) {
            super(fDSObjectIterator, clazz);
            this.d_defObjFilter = new FDSObjectIterator.DefaultObjectFilter(fDSObjectIterator);
        }

        @Override
        public FDSObject prefetchNext() {
            return this.d_defObjFilter.prefetchNext();
        }

        @Override
        public Object filterObject(FDSObject fDSObject) {
            return this.d_defObjFilter.filterObject(fDSObject);
        }
    }

    private static class TypeFilter<TT extends FDSObject>
    extends FDSObjectIterator.AbstractObjectFilter {
        private Class<TT> d_type;

        public TypeFilter(FDSObjectIterator fDSObjectIterator, Class<TT> clazz) {
            super(fDSObjectIterator);
            this.d_type = clazz;
        }

        @Override
        public Object filterObject(FDSObject fDSObject) {
            if (this.d_type.isInstance(fDSObject)) {
                return fDSObject;
            }
            return FDSObjectIterator.OBJECT_FILTERED;
        }
    }
}

