/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectTypeIterator;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class FDSObjectManager<T extends FDSObject>
implements IPyroManager<T, T> {
    private boolean d_deep;
    private final FDSComposite d_root;
    private final Class<T> d_type;
    private int d_size = -1;

    public FDSObjectManager(FDSComposite fDSComposite, boolean bl, Class<T> clazz) {
        this.d_root = fDSComposite;
        this.d_deep = bl;
        this.d_type = clazz;
    }

    @Override
    public Collection<? extends T> toCollection() {
        return new PyroCollection(this);
    }

    @Override
    public boolean contains(T t) {
        return FDSObjectManager.contains(this.d_root, t, this.d_deep);
    }

    private static boolean contains(FDSComposite fDSComposite, FDSObject fDSObject, boolean bl) {
        if (fDSComposite.contains(fDSObject)) {
            return true;
        }
        if (bl) {
            for (FDSObject fDSObject2 : fDSComposite.toCollection()) {
                if (!(fDSObject2 instanceof FDSComposite) || !FDSObjectManager.contains((FDSComposite)fDSObject2, fDSObject, bl)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<? extends T> collection) {
        return APyroDomainManager.containsAll(this, collection);
    }

    @Override
    public T get(T t) {
        return null;
    }

    @Override
    public int size() {
        if (this.d_size == -1) {
            this.d_size = 0;
            Iterator<T> iterator = this.iterator();
            while (iterator.hasNext()) {
                ++this.d_size;
                iterator.next();
            }
        }
        return this.d_size;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public T[] toArray() {
        FDSObject[] fDSObjectArray = (FDSObject[])Array.newInstance(this.d_type, this.size());
        return this.toArray(fDSObjectArray);
    }

    @Override
    public T[] toArray(T[] TArray) {
        int n = 0;
        for (FDSObject fDSObject : this) {
            TArray[n++] = fDSObject;
        }
        return TArray;
    }

    @Override
    public Iterator<T> iterator() {
        return new FDSObjectTypeIterator<T>(this.d_root, this.d_deep, this.d_type);
    }

    @Override
    public Class<T> getVClass() {
        return this.d_type;
    }

    @Override
    public Class<T> getKClass() {
        return this.d_type;
    }

    @Override
    public boolean canMakeUnique(T t) {
        return this.d_root.canMakeUnique((FDSObject)t);
    }

    @Override
    public String describeObject(T t) {
        return this.d_root.describeObject((FDSObject)t);
    }

    @Override
    public Task taskAdd(T t) {
        return this.d_root.taskAdd((FDSObject)t);
    }

    @Override
    public Task taskAddAll(Collection<? extends T> collection) {
        return this.d_root.taskAddAll((Collection<? extends FDSObject>)collection);
    }

    @Override
    public Task taskMakeUnique(T t) {
        return this.d_root.taskMakeUnique((FDSObject)t);
    }

    @Override
    public void addDomain(PyroMod pyroMod) {
        this.d_root.addDomain(pyroMod);
    }

    @Override
    public void removeDomain(PyroMod pyroMod) {
        this.d_root.removeDomain(pyroMod);
    }

    @Override
    public Set<PyroMod> getDomains() {
        return this.d_root.getDomains();
    }

    @Override
    public Task taskRemove(T t, T t2) {
        return this.taskRemoveAll((List<T>)new VectorFromArray<T>(t), (List<T>)new VectorFromArray<T>(t2));
    }

    @Override
    public Task taskRemoveAll(final List<T> list, final List<T> list2) {
        return new CompositeTask<PyroMod>(this.d_root.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                if (list2 == null) {
                    for (FDSObject fDSObject : list) {
                        FDSComposite fDSComposite = fDSObject.getParent();
                        if (fDSComposite == null) continue;
                        this.addTask(fDSComposite.taskRemove(fDSObject, (FDSObject)null));
                    }
                } else {
                    assert (list2.size() == list.size());
                    Iterator iterator = list2.iterator();
                    for (FDSObject fDSObject : list) {
                        FDSObject fDSObject2 = (FDSObject)iterator.next();
                        FDSComposite fDSComposite = fDSObject.getParent();
                        if (fDSComposite == null) continue;
                        this.addTask(fDSComposite.taskRemove(fDSObject, fDSObject2));
                    }
                }
            }
        };
    }
}

