/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class FDSObjectIterator
implements Iterator<FDSObject> {
    public static final FilteredStub OBJECT_FILTERED = new FilteredStub();
    private FDSComposite d_comp;
    private Iterator<? extends FDSObject> d_arrIterator;
    private Object d_current;
    private int d_currIndex;
    private int d_length;
    private FDSObject d_next;
    private boolean d_deep;
    private FDSObjectIterator d_recursiveNext;
    private ObjectFilter d_filter = new DefaultObjectFilter(this);

    public FDSObjectIterator(FDSComposite fDSComposite, boolean bl) {
        this(fDSComposite, bl, null);
    }

    public FDSObjectIterator(FDSComposite fDSComposite, boolean bl, ObjectFilter objectFilter) {
        this.d_comp = fDSComposite;
        this.d_currIndex = 0;
        this.d_length = this.d_comp.size();
        this.d_deep = bl;
        if (objectFilter != null) {
            this.d_filter = objectFilter;
        }
        this.d_next = this.d_filter.prefetchNext();
    }

    public FDSObjectIterator(FDSObject[] fDSObjectArray, boolean bl) {
        this(fDSObjectArray, bl, null);
    }

    public FDSObjectIterator(FDSObject[] fDSObjectArray, boolean bl, ObjectFilter objectFilter) {
        this(new VectorFromArray<FDSObject>(fDSObjectArray), bl, objectFilter);
    }

    public FDSObjectIterator(Collection<? extends FDSObject> collection, boolean bl) {
        this(collection, bl, null);
    }

    public FDSObjectIterator(Collection<? extends FDSObject> collection, boolean bl, ObjectFilter objectFilter) {
        this.d_arrIterator = collection.iterator();
        this.d_currIndex = 0;
        this.d_length = collection.size();
        this.d_deep = bl;
        if (objectFilter != null) {
            this.d_filter = objectFilter;
        }
        this.d_next = this.d_filter.prefetchNext();
    }

    public void setFilter(ObjectFilter objectFilter) {
        this.d_filter = objectFilter;
        if (this.d_next != null && objectFilter.filterObject(this.d_next) != this.d_next) {
            this.d_next = objectFilter.prefetchNext();
        }
    }

    public ObjectFilter getFilter() {
        return this.d_filter;
    }

    @Override
    public boolean hasNext() {
        return this.d_next != null;
    }

    public Object next(ObjectFilter objectFilter) {
        FDSObject fDSObject = this.d_next;
        this.d_next = objectFilter.prefetchNext();
        return fDSObject;
    }

    @Override
    public FDSObject next() {
        FDSObject fDSObject = this.d_next;
        this.d_next = this.d_filter.prefetchNext();
        return fDSObject;
    }

    private FDSObject prefetchNext() {
        this.updateRecursion();
        if (this.d_recursiveNext != null) {
            return this.d_recursiveNext.next();
        }
        FDSObject fDSObject = this.getCurr();
        ++this.d_currIndex;
        return fDSObject;
    }

    private void updateRecursion() {
        if (this.d_recursiveNext != null && !this.d_recursiveNext.hasNext()) {
            this.d_recursiveNext = null;
            ++this.d_currIndex;
        }
        if (this.d_recursiveNext == null) {
            FDSObject fDSObject;
            if (this.d_arrIterator != null && this.d_arrIterator.hasNext()) {
                this.d_current = this.d_arrIterator.next();
            }
            if ((fDSObject = this.getCurr()) instanceof FDSComposite && this.d_deep) {
                this.d_recursiveNext = new FDSObjectIterator((FDSComposite)fDSObject, true);
                this.updateRecursion();
            }
        }
    }

    private FDSObject getCurr() {
        if (this.d_currIndex >= this.d_length) {
            return null;
        }
        if (this.d_comp != null) {
            return this.d_comp.get(this.d_currIndex);
        }
        return (FDSObject)this.d_current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("FDSObjectIterator does not currently support the remove operation.");
    }

    private static class FilteredStub {
        private FilteredStub() {
        }
    }

    public static class DefaultObjectFilter
    extends AbstractObjectFilter {
        public DefaultObjectFilter(FDSObjectIterator fDSObjectIterator) {
            super(fDSObjectIterator);
        }

        @Override
        public FDSObject prefetchNext() {
            return this.getBaseIterator().prefetchNext();
        }

        @Override
        public Object filterObject(FDSObject fDSObject) {
            return fDSObject;
        }
    }

    public static abstract class AbstractObjectFilter
    implements ObjectFilter {
        private final FDSObjectIterator d_it;

        public AbstractObjectFilter(FDSObjectIterator fDSObjectIterator) {
            this.d_it = fDSObjectIterator;
        }

        protected FDSObjectIterator getBaseIterator() {
            return this.d_it;
        }

        @Override
        public FDSObject prefetchNext() {
            Object object;
            do {
                this.d_it.d_next = this.d_it.prefetchNext();
                if (this.d_it.d_next != null) continue;
                return null;
            } while ((object = this.filterObject(this.d_it.d_next)) == OBJECT_FILTERED);
            return (FDSObject)object;
        }
    }

    public static interface ObjectFilter {
        public FDSObject prefetchNext();

        public Object filterObject(FDSObject var1);
    }
}

