/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import pyrosim.legacy_2006_2.domain.DeepFDSObjectIterator;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectIterator;
import pyrosim.legacy_2006_2.domain.FDSObjectTypeIterator;

public class FDSObjectCollection<T extends FDSObject>
implements Collection<T> {
    private final boolean d_deep;
    private final Collection<? extends FDSObject> d_objs;
    private final Class<T> d_type;
    private int d_size = -1;

    public FDSObjectCollection(Collection<? extends FDSObject> collection, Class<T> clazz) {
        this(collection, true, clazz);
    }

    public FDSObjectCollection(Collection<? extends FDSObject> collection, boolean bl, Class<T> clazz) {
        this.d_deep = bl;
        this.d_objs = collection;
        this.d_type = clazz;
    }

    @Override
    public int size() {
        if (this.d_size == -1) {
            this.d_size = 0;
            Iterator<T> iterator = this.iterator();
            while (iterator.hasNext()) {
                ++this.d_size;
                iterator.next();
            }
        }
        return this.d_size;
    }

    public int shallowSize() {
        return this.d_objs.size();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean shallowIsEmpty() {
        return this.d_objs.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return FDSObjectCollection.contains(this.d_objs, object, this.d_deep);
    }

    private static boolean contains(Collection<? extends FDSObject> collection, Object object, boolean bl) {
        for (FDSObject fDSObject : collection) {
            if (fDSObject == object) {
                return true;
            }
            if (!bl || !(fDSObject instanceof FDSComposite)) continue;
            FDSComposite fDSComposite = (FDSComposite)fDSObject;
            if (fDSComposite.contains((FDSObject)object)) {
                return true;
            }
            if (!FDSObjectCollection.contains(fDSComposite.toCollection(), object, bl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new FDSObjectTypeIterator<T>(this.d_objs, this.d_deep, this.d_type);
    }

    public DeepFDSObjectIterator deepIterator() {
        return new DeepFDSObjectIterator(this.d_objs);
    }

    public FDSObjectIterator shallowIterator() {
        return new FDSObjectIterator(this.d_objs, false);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        return this.toArray((T2[])objectArray);
    }

    @Override
    public <T2> T2[] toArray(T2[] T2Array) {
        int n = 0;
        T2[] T2Array2 = T2Array;
        for (FDSObject fDSObject : this) {
            T2Array2[n++] = fDSObject;
        }
        return T2Array;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

