/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AFDSFaceProps;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.BlockFragGenerator;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.geom.Triangle;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class FDSConvexPoly
extends AbstractFDSObject
implements Serializable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D[] d_points;

    public FDSConvexPoly(Material material, UnitPoint3D ... unitPoint3DArray) {
        super("Convex Polygon");
        this.d_points = unitPoint3DArray;
        ConvexPolyFace convexPolyFace = new ConvexPolyFace(this);
        convexPolyFace.setMaterial(material);
        this.d_faces = new Vector(1);
        this.d_faces.add(convexPolyFace);
    }

    private void changed() {
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setPoints(UnitPoint3D ... unitPoint3DArray) {
        this.d_points = unitPoint3DArray;
        this.changed();
    }

    public UnitPoint3D[] getPoints() {
        return this.d_points;
    }

    public int getNumPoints() {
        return this.d_points.length;
    }

    public UnitPoint3D getPoint(int n) {
        assert (n >= 0 && n < this.d_points.length);
        return this.d_points[n];
    }

    public void setPoint(int n, UnitPoint3D unitPoint3D) {
        assert (n >= 0 && n < this.d_points.length);
        this.d_points[n] = unitPoint3D;
        this.changed();
    }

    private ConvexPolyFace getFace() {
        return (ConvexPolyFace)this.getFace(0);
    }

    @Override
    protected void imprint(Object object) {
        if (!(object instanceof FDSConvexPoly)) {
            return;
        }
        ADomainObject.pauseUpdates(this);
        super.imprint(object);
        this.getFace().d_obj = this;
        FDSConvexPoly fDSConvexPoly = (FDSConvexPoly)object;
        this.d_points = FDSConvexPoly.clonePoints(fDSConvexPoly.d_points);
        this.changed();
        ADomainObject.resumeUpdates(this);
    }

    private static UnitPoint3D[] clonePoints(UnitPoint3D[] unitPoint3DArray) {
        UnitPoint3D[] unitPoint3DArray2 = new UnitPoint3D[unitPoint3DArray.length];
        for (int i = 0; i < unitPoint3DArray.length; ++i) {
            unitPoint3DArray2[i] = (UnitPoint3D)unitPoint3DArray[i].clone();
        }
        return unitPoint3DArray2;
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void translate(UnitPoint3D unitPoint3D) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        for (int i = 0; i < this.d_points.length; ++i) {
            Point3d point3d2 = this.d_points[i].getPoint3dValue(unit);
            point3d2.add(point3d);
            this.d_points[i] = new UnitPoint3D(point3d2, unit);
        }
        this.changed();
    }

    @Override
    protected void rotate(UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        Matrix3d matrix3d = FDSConvexPoly.getRotateMat(vector3d, unitDouble);
        for (int i = 0; i < this.d_points.length; ++i) {
            Point3d point3d2 = this.d_points[i].getPoint3dValue(unit);
            FDSConvexPoly.rotatePoint(point3d2, point3d, matrix3d);
            this.d_points[i] = new UnitPoint3D(point3d2, unit);
        }
        this.changed();
    }

    @Override
    protected void mirror(int n, UnitDouble unitDouble) {
    }

    @Override
    protected void scale(UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        assert (tuple3d.x >= 0.0 && tuple3d.y >= 0.0 && tuple3d.z >= 0.0);
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        for (int i = 0; i < this.d_points.length; ++i) {
            Point3d point3d2 = this.d_points[i].getPoint3dValue(unit);
            FDSConvexPoly.scalePoint(point3d2, point3d, tuple3d);
            this.d_points[i] = new UnitPoint3D(point3d2, unit);
        }
        this.changed();
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public void setMaterial(int n, Material material) {
        this.getFace().setMaterial(material);
    }

    @Override
    public Material getMaterial(int n) {
        return this.getFace().getMaterial();
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
    }

    @Override
    public String getFDSType() {
        return "POLY";
    }

    @Override
    public String getTypeDescription() {
        return "Convex Polygon";
    }

    @Override
    public boolean isRasterizable() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    private static class ConvexPolyFace
    implements IFace,
    Serializable {
        static final long serialVersionUID = 1L;
        private Material d_mat;
        private FDSConvexPoly d_obj;

        public ConvexPolyFace(FDSConvexPoly fDSConvexPoly) {
            this.d_obj = fDSConvexPoly;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                assert (false);
                return null;
            }
        }

        @Override
        public String getName() {
            return "Triangle Face";
        }

        @Override
        public void getGeometry(Geometry geometry) {
            PrimProps primProps = new PrimProps(this.d_mat, this.d_obj.getColor());
            Unit unit = Geometry.GEOM_LENGTH_UNIT;
            if (this.d_obj.d_points.length == 3) {
                Point3d point3d = this.d_obj.d_points[0].getPoint3dValue(unit);
                Point3d point3d2 = this.d_obj.d_points[1].getPoint3dValue(unit);
                Point3d point3d3 = this.d_obj.d_points[2].getPoint3dValue(unit);
                geometry.addTriangle(new Triangle(point3d, point3d2, point3d3, primProps));
            } else if (this.d_obj.d_points.length == 4) {
                Point3d point3d = this.d_obj.d_points[0].getPoint3dValue(unit);
                Point3d point3d4 = this.d_obj.d_points[1].getPoint3dValue(unit);
                Point3d point3d5 = this.d_obj.d_points[2].getPoint3dValue(unit);
                Point3d point3d6 = this.d_obj.d_points[3].getPoint3dValue(unit);
                geometry.addQuad(new Quad(point3d, point3d4, point3d5, point3d6, primProps));
            }
        }

        @Override
        public Material getMaterial() {
            return this.d_mat;
        }

        @Override
        public void setMaterial(Material material) {
            this.d_mat = material;
            this.d_obj.changed();
        }

        @Override
        public Iterator getVentIterator() {
            return null;
        }

        @Override
        public boolean isSelected() {
            return false;
        }

        @Override
        public void setSelected(boolean bl) {
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return this.d_obj.d_points;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return new BlockFragGenerator(new AFDSFaceProps(this){

                @Override
                public boolean isThickened() {
                    return false;
                }

                @Override
                public boolean permitsHoles() {
                    return true;
                }

                @Override
                public boolean isSawtoothed() {
                    return false;
                }
            }, FDSRasterization.getCellPriority(false, true, true));
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_obj;
        }
    }

    private class SaveGeomTask
    extends ATask {
        private UnitPoint3D[] d_points;
        private Material d_mat;

        public SaveGeomTask(int n) {
            super(n, true);
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(FDSConvexPoly.this);
            FDSConvexPoly.this.setPoints(this.d_points);
            FDSConvexPoly.this.setMaterial(this.d_mat);
            ADomainObject.resumeUpdates(FDSConvexPoly.this);
        }

        @Override
        public void run() {
            this.d_points = FDSConvexPoly.clonePoints(FDSConvexPoly.this.d_points);
            this.d_mat = FDSConvexPoly.this.getMaterial();
        }
    }
}

