/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AImprintTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddAtIndexTask;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.ARemoveAtIndexTask;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.DeepFDSObjectIterator;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectCollection;
import pyrosim.legacy_2006_2.domain.FDSObjectIterator;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.Slab;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.KeyableObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class FDSComposite
extends KeyableObject
implements FDSObject,
Serializable,
Cloneable,
IPyroManager<Integer, FDSObject> {
    static final long serialVersionUID = 1L;
    private String d_name;
    private List<FDSObject> d_members;
    private Set<FDSObject> d_obstSet;
    private Set<FDSComposite> d_compSet;
    private transient boolean d_selected;
    private transient ADomainObject<PyroMod> d_domainHelper = new ADomainObject();
    private transient Map<FDSObject, Integer> d_objIndexMap;
    private FDSComposite d_parent = null;

    public FDSComposite() {
        this("Group");
    }

    public FDSComposite(String string) {
        this.d_members = new ArrayList<FDSObject>();
        this.d_obstSet = new HashSet<FDSObject>();
        this.d_compSet = new HashSet<FDSComposite>();
        this.d_name = string;
    }

    @Override
    public Collection<? extends FDSObject> toCollection() {
        return new PyroCollection<Integer, FDSObject>(this);
    }

    public <T extends FDSObject> Collection<T> toCollection(Class<T> clazz, boolean bl) {
        return new FDSObjectCollection<T>(Arrays.asList(this), bl, clazz);
    }

    public static FDSObjectCollection<FDSObject> toCollection(Collection<? extends FDSObject> collection) {
        return FDSComposite.toCollection(collection, true);
    }

    public static FDSObjectCollection<FDSObject> toCollection(Collection<? extends FDSObject> collection, boolean bl) {
        return new FDSObjectCollection<FDSObject>(collection, bl, FDSObject.class);
    }

    public static FDSObjectCollection<FDSObject> toCollection(FDSObject ... fDSObjectArray) {
        return FDSComposite.toCollection(Arrays.asList(fDSObjectArray));
    }

    public static FDSObjectCollection<FDSObject> toCollection(boolean bl, FDSObject ... fDSObjectArray) {
        return FDSComposite.toCollection(Arrays.asList(fDSObjectArray), bl);
    }

    @Override
    public Object clone() {
        FDSComposite fDSComposite = (FDSComposite)super.clone();
        fDSComposite.d_domainHelper = new ADomainObject();
        fDSComposite.d_selected = false;
        fDSComposite.d_members = new Vector<FDSObject>(this.d_members.size());
        fDSComposite.d_obstSet = new HashSet<FDSObject>(this.d_obstSet.size());
        fDSComposite.d_compSet = new HashSet<FDSComposite>(this.d_compSet.size());
        for (FDSObject fDSObject : this.d_members) {
            FDSObject fDSObject2 = (FDSObject)fDSObject.clone();
            fDSObject2.setParent(fDSComposite);
            fDSComposite.d_members.add(fDSObject2);
            if (fDSObject2 instanceof FDSComposite) {
                fDSComposite.d_compSet.add((FDSComposite)fDSObject2);
                continue;
            }
            fDSComposite.d_obstSet.add(fDSObject2);
        }
        fDSComposite.clearIndexCache();
        return fDSComposite;
    }

    private void imprint(FDSComposite fDSComposite) {
        this.d_domainHelper.pauseUpdates();
        this.setName(fDSComposite.d_name);
        Vector<FDSObject> vector = new Vector<FDSObject>(this.size());
        vector.addAll(this.toCollection());
        this.taskRemoveAll((List<FDSObject>)vector, (List<FDSObject>)null).run();
        for (FDSObject fDSObject : fDSComposite.toCollection()) {
            FDSObject fDSObject2 = (FDSObject)fDSObject.clone();
            fDSObject2.setParent(this);
            this.taskAdd(fDSObject2).run();
        }
        this.d_domainHelper.resumeUpdates();
    }

    @Override
    public Task taskImprint(Object object) {
        if (!(object instanceof FDSComposite)) {
            return null;
        }
        return new AImprintTask<FDSComposite>(this, (FDSComposite)object, FDSComposite.class){

            @Override
            protected void imprint(FDSComposite fDSComposite, FDSComposite fDSComposite2) {
                fDSComposite.imprint(fDSComposite2);
            }
        };
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FDSComposite)) {
            return false;
        }
        FDSComposite fDSComposite = (FDSComposite)object;
        return fDSComposite.d_members.equals(this.d_members);
    }

    @Override
    public FDSComposite getParent() {
        return this.d_parent;
    }

    @Override
    public void setParent(FDSComposite fDSComposite) {
        this.d_parent = fDSComposite;
    }

    @Override
    public Task taskTranslateObject(final UnitPoint3D unitPoint3D) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject fDSObject : FDSComposite.this.d_members) {
                    this.addTask(fDSObject.taskTranslateObject(unitPoint3D));
                }
            }
        };
    }

    @Override
    public Task taskMirrorObject(final int n, final UnitDouble unitDouble) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject fDSObject : FDSComposite.this.d_members) {
                    this.addTask(fDSObject.taskMirrorObject(n, unitDouble));
                }
            }
        };
    }

    @Override
    public Task taskScaleObject(final UnitPoint3D unitPoint3D, final Tuple3d tuple3d) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject fDSObject : FDSComposite.this.d_members) {
                    this.addTask(fDSObject.taskScaleObject(unitPoint3D, tuple3d));
                }
            }
        };
    }

    @Override
    public Task taskRotateObject(final UnitPoint3D unitPoint3D, final Vector3d vector3d, final UnitDouble unitDouble) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject fDSObject : FDSComposite.this.d_members) {
                    this.addTask(fDSObject.taskRotateObject(unitPoint3D, vector3d, unitDouble));
                }
            }
        };
    }

    private boolean add(FDSObject fDSObject) {
        return this.add(fDSObject, this.size());
    }

    private boolean add(FDSObject fDSObject, int n) {
        if (fDSObject instanceof FDSComposite) {
            if (fDSObject == this || ((FDSComposite)fDSObject).isDecendent(this)) {
                return false;
            }
            this.d_compSet.add((FDSComposite)fDSObject);
        } else {
            this.d_obstSet.add(fDSObject);
        }
        this.d_members.add(n, fDSObject);
        fDSObject.setParent(this);
        ADomainObject.addDomains(fDSObject, this.getDomains());
        this.clearIndexCache();
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, fDSObject, 3));
        if (fDSObject instanceof FDSComposite) {
            ((FDSComposite)fDSObject).propagateEvent(3);
        }
        return true;
    }

    private FDSObject remove(int n) {
        FDSObject fDSObject = this.d_members.get(n);
        if (fDSObject == null) {
            return null;
        }
        this.d_members.remove(n);
        this.d_obstSet.remove(fDSObject);
        this.d_compSet.remove(fDSObject);
        this.clearIndexCache();
        if (fDSObject.getParent() == this) {
            fDSObject.setParent(null);
        } else {
            System.err.println("Can't remove parent because parent was different " + this + " " + fDSObject.getParent());
        }
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, fDSObject, 4));
        if (fDSObject instanceof FDSComposite) {
            ((FDSComposite)fDSObject).propagateEvent(4);
        }
        ADomainObject.removeDomains(fDSObject, this.getDomains());
        return fDSObject;
    }

    private boolean remove(FDSObject fDSObject) {
        int n = this.indexOfUncached(fDSObject);
        if (n < 0) {
            return false;
        }
        return this.remove(n) != null;
    }

    private void propagateEvent(int n) {
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, this.d_members, n));
        for (FDSComposite fDSComposite : this.d_compSet) {
            fDSComposite.propagateEvent(n);
        }
    }

    private boolean removeAll(Collection<? extends FDSObject> collection) {
        boolean bl = true;
        for (FDSObject fDSObject : collection) {
            if (this.remove(fDSObject)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean contains(FDSObject fDSObject) {
        if (fDSObject instanceof FDSComposite) {
            return this.d_compSet.contains(fDSObject);
        }
        return this.d_obstSet.contains(fDSObject);
    }

    @Override
    public boolean contains(Integer n) {
        return n < this.d_members.size() && n >= 0;
    }

    @Override
    public boolean containsAll(Collection<? extends Integer> collection) {
        return APyroDomainManager.containsAll(this, collection);
    }

    @Override
    public boolean isEmpty() {
        return this.d_members.isEmpty();
    }

    public FDSObject[] toArray() {
        return this.toArray(new FDSObject[this.size()]);
    }

    public FDSObject[] toArray(FDSObject[] fDSObjectArray) {
        return this.d_members.toArray(fDSObjectArray);
    }

    @Override
    public Iterator<FDSObject> iterator() {
        return new FDSObjectIterator(this, false);
    }

    @Override
    public int size() {
        return this.d_members.size();
    }

    @Override
    public FDSObject get(Integer n) {
        return this.d_members.get(n);
    }

    private void clearIndexCache() {
        this.d_objIndexMap = null;
    }

    private void buildIndexCache() {
        if (this.d_objIndexMap == null) {
            this.d_objIndexMap = new HashMap<FDSObject, Integer>(this.d_members.size());
            for (int i = 0; i < this.d_members.size(); ++i) {
                this.d_objIndexMap.put(this.d_members.get(i), i);
            }
        }
    }

    public int indexOf(FDSObject fDSObject) {
        this.buildIndexCache();
        Integer n = this.d_objIndexMap.get(fDSObject);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int indexOfUncached(FDSObject fDSObject) {
        for (int i = 0; i < this.d_members.size(); ++i) {
            if (this.d_members.get(i) != fDSObject) continue;
            return i;
        }
        return -1;
    }

    public boolean isDecendent(FDSObject fDSObject) {
        if (this.contains(fDSObject)) {
            return true;
        }
        for (FDSComposite fDSComposite : this.d_compSet) {
            if (!fDSComposite.isDecendent(fDSObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFDSType() {
        return "";
    }

    public Collection<FDSInputRecord> getInputRecords() {
        ArrayList<FDSInputRecord> arrayList = new ArrayList<FDSInputRecord>(1);
        this.getInputRecords(arrayList);
        return arrayList;
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        for (FDSObject fDSObject : this.d_members) {
            fDSObject.getInputRecords(collection);
        }
    }

    @Override
    public void getGeometry(Geometry geometry) {
        Geometry geometry2 = new Geometry();
        for (FDSObject fDSObject : this.d_members) {
            if (!fDSObject.isVisible()) continue;
            fDSObject.getGeometry(geometry2);
        }
        geometry.addGeometry(geometry2);
    }

    @Override
    public UnitPoint3D getMinPoint() {
        return FDSComposite.getMinPoint(new FDSObjectIterator(this, false));
    }

    public static UnitPoint3D getMinPoint(Iterator<? extends FDSObject> iterator) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        BaseUnit baseUnit = SI.METER;
        if (iterator.hasNext()) {
            d = Double.MAX_VALUE;
            d2 = Double.MAX_VALUE;
            d3 = Double.MAX_VALUE;
            while (iterator.hasNext()) {
                UnitPoint3D unitPoint3D = iterator.next().getMinPoint();
                if (unitPoint3D.x(baseUnit) < d) {
                    d = unitPoint3D.x(baseUnit);
                }
                if (unitPoint3D.y(baseUnit) < d2) {
                    d2 = unitPoint3D.y(baseUnit);
                }
                if (!(unitPoint3D.z(baseUnit) < d3)) continue;
                d3 = unitPoint3D.z(baseUnit);
            }
        }
        return new UnitPoint3D(d, d2, d3, baseUnit);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        return FDSComposite.getMaxPoint(new FDSObjectIterator(this, false));
    }

    public static UnitPoint3D getMaxPoint(Iterator<? extends FDSObject> iterator) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        BaseUnit baseUnit = SI.METER;
        if (iterator.hasNext()) {
            d = -1.7976931348623157E308;
            d2 = -1.7976931348623157E308;
            d3 = -1.7976931348623157E308;
            while (iterator.hasNext()) {
                UnitPoint3D unitPoint3D = iterator.next().getMaxPoint();
                if (unitPoint3D.x(baseUnit) > d) {
                    d = unitPoint3D.x(baseUnit);
                }
                if (unitPoint3D.y(baseUnit) > d2) {
                    d2 = unitPoint3D.y(baseUnit);
                }
                if (!(unitPoint3D.z(baseUnit) > d3)) continue;
                d3 = unitPoint3D.z(baseUnit);
            }
        }
        return new UnitPoint3D(d, d2, d3, baseUnit);
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    private void setName(String string) {
        this.d_name = string;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Task taskSetName(String string) {
        return new ASetNameTask(string){

            @Override
            protected void setName(String string) {
                FDSComposite.this.setName(string);
            }

            @Override
            protected String getName() {
                return FDSComposite.this.getName();
            }
        };
    }

    @Override
    public boolean isSelected() {
        return this.d_selected;
    }

    @Override
    public void setSelected(boolean bl) {
        this.d_selected = bl;
        ADomainObject.pauseUpdates(this);
        for (FDSObject fDSObject : this.d_members) {
            fDSObject.setSelected(bl);
        }
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 0));
        ADomainObject.resumeUpdates(this);
    }

    @Override
    public void setVisible(boolean bl) {
        ADomainObject.pauseUpdates(this, false);
        for (FDSObject fDSObject : this.d_members) {
            fDSObject.setVisible(bl);
        }
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 1));
    }

    @Override
    public boolean isVisible() {
        if (this.size() < 1) {
            return true;
        }
        for (FDSObject fDSObject : this.d_members) {
            if (!fDSObject.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumFaces() {
        assert (false) : "Warning!! -- unimplemented";
        return 0;
    }

    @Override
    public IFace getFace(int n) {
        assert (false) : "Warning!! -- unimplemented";
        return null;
    }

    private static void pauseUpdates(Set<PyroMod> set) {
        for (PyroMod pyroMod : set) {
            pyroMod.pauseUpdates();
        }
    }

    private static void resumeUpdates(Set<PyroMod> set) {
        for (PyroMod pyroMod : set) {
            pyroMod.resumeUpdates();
        }
    }

    @Override
    public void setMaterial(Material material) {
        FDSComposite.setMaterial(material, new FDSObjectIterator(this, false), this.getDomains());
    }

    public static void setMaterial(Material material, FDSObjectIterator fDSObjectIterator, Set<PyroMod> set) {
        FDSComposite.pauseUpdates(set);
        while (fDSObjectIterator.hasNext()) {
            fDSObjectIterator.next().setMaterial(material);
        }
        FDSComposite.resumeUpdates(set);
    }

    @Override
    public void setMaterial(int n, Material material) {
        FDSComposite.setMaterial(n, material, new FDSObjectIterator(this, false), this.getDomains());
    }

    public static void setMaterial(int n, Material material, FDSObjectIterator fDSObjectIterator, Set<PyroMod> set) {
        FDSComposite.pauseUpdates(set);
        while (fDSObjectIterator.hasNext()) {
            fDSObjectIterator.next().setMaterial(n, material);
        }
        FDSComposite.resumeUpdates(set);
    }

    @Override
    public Material getMaterial() {
        return FDSComposite.getMaterial(this.d_members);
    }

    public static Material getMaterial(Collection<? extends FDSObject> collection) {
        if (FDSComposite.isUniformMaterial(collection.iterator())) {
            if (collection.size() < 1) {
                return null;
            }
            for (FDSObject fDSObject : collection) {
                Material material = fDSObject.getMaterial();
                if (material == null) continue;
                return material;
            }
            return null;
        }
        return null;
    }

    @Override
    public void setColor(Color color) {
        FDSComposite.setColor(color, new FDSObjectIterator(this, false), this.getDomains());
    }

    public static void setColor(Color color, FDSObjectIterator fDSObjectIterator, Set<PyroMod> set) {
        FDSComposite.pauseUpdates(set);
        while (fDSObjectIterator.hasNext()) {
            fDSObjectIterator.next().setColor(color);
        }
        FDSComposite.resumeUpdates(set);
    }

    @Override
    public Color getColor() {
        return FDSComposite.getColor(new DeepFDSObjectIterator(this));
    }

    public static Color getColor(Iterator<? extends FDSObject> iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next().getColor();
    }

    public boolean isUniformColor() {
        return FDSComposite.isUniformColor(new DeepFDSObjectIterator(this));
    }

    public static boolean isUniformColor(Iterator<? extends FDSObject> iterator) {
        if (!iterator.hasNext()) {
            return true;
        }
        Color color = iterator.next().getColor();
        while (iterator.hasNext()) {
            Color color2 = iterator.next().getColor();
            boolean bl = color == null ? color2 == null : color.equals(color2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    public void setIsSawtoothed(boolean bl) {
        FDSComposite.setIsSawtoothed(bl, new DeepFDSObjectIterator(this), this.getDomains());
    }

    public static void setIsSawtoothed(boolean bl, Iterator<? extends FDSObject> iterator, Set<PyroMod> set) {
        FDSComposite.pauseUpdates(set);
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject instanceof Wall) {
                ((Wall)fDSObject).setIsSawtoothed(bl);
                continue;
            }
            if (fDSObject instanceof AlignedBlock) {
                ((AlignedBlock)fDSObject).setIsSawtoothed(bl);
                continue;
            }
            if (!(fDSObject instanceof Slab)) continue;
            ((Slab)fDSObject).setIsSawtoothed(bl);
        }
        FDSComposite.resumeUpdates(set);
    }

    public boolean isSawtoothed() {
        DeepFDSObjectIterator deepFDSObjectIterator = new DeepFDSObjectIterator(this);
        return FDSComposite.isSawtoothed(deepFDSObjectIterator);
    }

    public static boolean isSawtoothed(Iterator<? extends FDSObject> iterator) {
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject instanceof Wall) {
                return ((Wall)fDSObject).isSawtoothed();
            }
            if (fDSObject instanceof AlignedBlock) {
                return ((AlignedBlock)fDSObject).isSawtoothed();
            }
            if (!(fDSObject instanceof Slab)) continue;
            return ((Slab)fDSObject).isSawtoothed();
        }
        return false;
    }

    public boolean isUniformSawtoothed() {
        DeepFDSObjectIterator deepFDSObjectIterator = new DeepFDSObjectIterator(this);
        return FDSComposite.isUniformSawtoothed(deepFDSObjectIterator);
    }

    public static boolean isUniformSawtoothed(Iterator<? extends FDSObject> iterator) {
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject instanceof Wall) {
                if (!bl2) {
                    bl = ((Wall)fDSObject).isSawtoothed();
                    bl2 = true;
                    continue;
                }
                if (((Wall)fDSObject).isSawtoothed() == bl) continue;
                return false;
            }
            if (fDSObject instanceof AlignedBlock) {
                if (!bl2) {
                    bl = ((AlignedBlock)fDSObject).isSawtoothed();
                    bl2 = true;
                    continue;
                }
                if (((AlignedBlock)fDSObject).isSawtoothed() == bl) continue;
                return false;
            }
            if (!(fDSObject instanceof Slab)) continue;
            if (!bl2) {
                bl = ((Slab)fDSObject).isSawtoothed();
                bl2 = true;
                continue;
            }
            if (((Slab)fDSObject).isSawtoothed() == bl) continue;
            return false;
        }
        return true;
    }

    public void setIsThickened(boolean bl) {
        FDSComposite.setIsThickened(bl, new DeepFDSObjectIterator(this), this.getDomains());
    }

    public static void setIsThickened(boolean bl, Iterator<? extends FDSObject> iterator, Set<PyroMod> set) {
        FDSComposite.pauseUpdates(set);
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject instanceof Wall) {
                ((Wall)fDSObject).setIsThickened(bl);
                continue;
            }
            if (fDSObject instanceof AlignedBlock) {
                ((AlignedBlock)fDSObject).setIsThickened(bl);
                continue;
            }
            if (!(fDSObject instanceof Slab)) continue;
            ((Slab)fDSObject).setIsThickened(bl);
        }
        FDSComposite.resumeUpdates(set);
    }

    public boolean isThickened() {
        DeepFDSObjectIterator deepFDSObjectIterator = new DeepFDSObjectIterator(this);
        return FDSComposite.isThickened(deepFDSObjectIterator);
    }

    public static boolean isThickened(Iterator<? extends FDSObject> iterator) {
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject instanceof Wall) {
                return ((Wall)fDSObject).isThickened();
            }
            if (fDSObject instanceof AlignedBlock) {
                return ((AlignedBlock)fDSObject).isThickened();
            }
            if (!(fDSObject instanceof Slab)) continue;
            return ((Slab)fDSObject).isThickened();
        }
        return false;
    }

    public boolean isUniformThickened() {
        DeepFDSObjectIterator deepFDSObjectIterator = new DeepFDSObjectIterator(this);
        return FDSComposite.isUniformThickened(deepFDSObjectIterator);
    }

    public static boolean isUniformThickened(Iterator<? extends FDSObject> iterator) {
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject instanceof Wall) {
                if (!bl2) {
                    bl = ((Wall)fDSObject).isThickened();
                    bl2 = true;
                    continue;
                }
                if (((Wall)fDSObject).isThickened() == bl) continue;
                return false;
            }
            if (fDSObject instanceof AlignedBlock) {
                if (!bl2) {
                    bl = ((AlignedBlock)fDSObject).isThickened();
                    bl2 = true;
                    continue;
                }
                if (((AlignedBlock)fDSObject).isThickened() == bl) continue;
                return false;
            }
            if (!(fDSObject instanceof Slab)) continue;
            if (!bl2) {
                bl = ((Slab)fDSObject).isThickened();
                bl2 = true;
                continue;
            }
            if (((Slab)fDSObject).isThickened() == bl) continue;
            return false;
        }
        return true;
    }

    public void setPermitsHole(boolean bl) {
        FDSComposite.setPermitsHole(bl, new DeepFDSObjectIterator(this), this.getDomains());
    }

    public static void setPermitsHole(boolean bl, Iterator<? extends FDSObject> iterator, Set<PyroMod> set) {
        FDSComposite.pauseUpdates(set);
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject instanceof Wall) {
                ((Wall)fDSObject).setPermitsHole(bl);
                continue;
            }
            if (fDSObject instanceof AlignedBlock) {
                ((AlignedBlock)fDSObject).setPermitsHole(bl);
                continue;
            }
            if (!(fDSObject instanceof Slab)) continue;
            ((Slab)fDSObject).setPermitsHole(bl);
        }
        FDSComposite.resumeUpdates(set);
    }

    public boolean permitsHole() {
        DeepFDSObjectIterator deepFDSObjectIterator = new DeepFDSObjectIterator(this);
        return FDSComposite.permitsHole(deepFDSObjectIterator);
    }

    public static boolean permitsHole(Iterator<? extends FDSObject> iterator) {
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject instanceof Wall) {
                return ((Wall)fDSObject).permitsHole();
            }
            if (fDSObject instanceof AlignedBlock) {
                return ((AlignedBlock)fDSObject).permitsHole();
            }
            if (!(fDSObject instanceof Slab)) continue;
            return ((Slab)fDSObject).permitsHole();
        }
        return false;
    }

    public boolean isUniformPermitsHole() {
        DeepFDSObjectIterator deepFDSObjectIterator = new DeepFDSObjectIterator(this);
        return FDSComposite.isUniformPermitsHole(deepFDSObjectIterator);
    }

    public static boolean isUniformPermitsHole(Iterator<? extends FDSObject> iterator) {
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject instanceof Wall) {
                if (!bl2) {
                    bl = ((Wall)fDSObject).permitsHole();
                    bl2 = true;
                    continue;
                }
                if (((Wall)fDSObject).permitsHole() == bl) continue;
                return false;
            }
            if (fDSObject instanceof AlignedBlock) {
                if (!bl2) {
                    bl = ((AlignedBlock)fDSObject).permitsHole();
                    bl2 = true;
                    continue;
                }
                if (((AlignedBlock)fDSObject).permitsHole() == bl) continue;
                return false;
            }
            if (!(fDSObject instanceof Slab)) continue;
            if (!bl2) {
                bl = ((Slab)fDSObject).permitsHole();
                bl2 = true;
                continue;
            }
            if (((Slab)fDSObject).permitsHole() == bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniformMaterial() {
        return FDSComposite.isUniformMaterial(new FDSObjectIterator(this, false));
    }

    @Override
    public Material getMaterial(int n) {
        return FDSComposite.getMaterial(new DeepFDSObjectIterator(this), n);
    }

    public static Material getMaterial(Iterator<? extends FDSObject> iterator, int n) {
        Material material;
        if (!iterator.hasNext()) {
            return null;
        }
        FDSObject fDSObject = iterator.next();
        Material material2 = material = n <= fDSObject.getNumFaces() ? fDSObject.getMaterial(n) : null;
        while (iterator.hasNext()) {
            fDSObject = iterator.next();
            if (n >= fDSObject.getNumFaces() || (material2 = fDSObject.getMaterial(n)) == material) continue;
            return null;
        }
        return material;
    }

    public static boolean isUniformMaterial(Iterator<? extends FDSObject> iterator) {
        Material material = null;
        Material material2 = null;
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (!fDSObject.isUniformMaterial()) {
                return false;
            }
            material2 = fDSObject.getMaterial();
            if (material == null) {
                material = material2;
                continue;
            }
            if (material2 == material || material2 == null) continue;
            return false;
        }
        return true;
    }

    public static FDSComposite getCommonParentFromRoot(FDSObject[] fDSObjectArray, FDSComposite fDSComposite) {
        return FDSComposite.getCommonParentFromRoot(Arrays.asList(fDSObjectArray), fDSComposite);
    }

    public static FDSComposite getCommonParentFromRoot(Collection<? extends FDSObject> collection, FDSComposite fDSComposite) {
        if (collection.isEmpty()) {
            return fDSComposite;
        }
        Iterator<? extends FDSObject> iterator = collection.iterator();
        FDSComposite[] fDSCompositeArray = FDSComposite.getPath(iterator.next(), fDSComposite);
        if (fDSCompositeArray == null) {
            return fDSComposite;
        }
        int n = fDSCompositeArray.length - 1;
        while (iterator.hasNext()) {
            FDSObject fDSObject = iterator.next();
            if (fDSObject == fDSComposite) {
                return fDSComposite;
            }
            while (!fDSCompositeArray[n].isDecendent(fDSObject)) {
                --n;
            }
        }
        return fDSCompositeArray[n];
    }

    public static FDSComposite getParentFromRoot(FDSObject fDSObject, FDSComposite fDSComposite) {
        if (fDSComposite.contains(fDSObject)) {
            return fDSComposite;
        }
        for (FDSComposite fDSComposite2 : fDSComposite.d_compSet) {
            FDSComposite fDSComposite3 = FDSComposite.getParentFromRoot(fDSObject, fDSComposite2);
            if (fDSComposite3 == null) continue;
            return fDSComposite3;
        }
        return null;
    }

    public static FDSComposite[] getPath(FDSObject fDSObject, FDSComposite fDSComposite) {
        LinkedList<FDSComposite> linkedList = new LinkedList<FDSComposite>();
        FDSComposite.getPath(fDSObject, linkedList);
        if (linkedList.isEmpty() || linkedList.getFirst() != fDSComposite) {
            return null;
        }
        return linkedList.toArray(new FDSComposite[linkedList.size()]);
    }

    private static void getPath(FDSObject fDSObject, LinkedList<FDSComposite> linkedList) {
        FDSComposite fDSComposite = fDSObject.getParent();
        if (fDSComposite != null) {
            linkedList.addFirst(fDSComposite);
            FDSComposite.getPath((FDSObject)fDSComposite, linkedList);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_domainHelper == null) {
            this.d_domainHelper = new ADomainObject();
        }
        this.clearIndexCache();
        if (objectInputStream instanceof PyroSimObjectInputStream) {
            PyroSimObjectInputStream pyroSimObjectInputStream = (PyroSimObjectInputStream)objectInputStream;
            if (pyroSimObjectInputStream.getVersion() < 15) {
                this.ensureKeyed();
                this.d_compSet = new HashSet<FDSComposite>();
                this.d_obstSet = new HashSet<FDSObject>();
                for (FDSObject fDSObject : this.d_members) {
                    if (fDSObject instanceof FDSComposite) {
                        this.d_compSet.add((FDSComposite)fDSObject);
                        continue;
                    }
                    this.d_obstSet.add(fDSObject);
                }
            }
            if (pyroSimObjectInputStream.getVersion() < 19) {
                for (FDSObject fDSObject : this.d_members) {
                    fDSObject.setParent(this);
                }
            }
        }
    }

    @Override
    public boolean addEvent(ActivationEvent activationEvent) {
        return true;
    }

    @Override
    public boolean removeEvent(ActivationEvent activationEvent) {
        return true;
    }

    @Override
    public void removeAllEvents() {
    }

    @Override
    public void removeEvents(int n) {
    }

    @Override
    public ActivationEventList getEventsOfType(int n) {
        return AbstractActivationEventList.createNewList(n, this.getDomains());
    }

    @Override
    public ActivationEvent[] getAllEvents() {
        return new ActivationEvent[0];
    }

    @Override
    public Vector getEventsSeparatedByType() {
        return new Vector(0);
    }

    @Override
    public void setCanBeTriggeredByAnyHeatDetector(boolean bl, int n) {
    }

    @Override
    public boolean getCanBeTriggeredByAnyHeatDetector(int n) {
        return false;
    }

    @Override
    public String getPropertyHashString() {
        return "";
    }

    @Override
    public Map getEventInputRecordMap(int n) {
        return new TreeMap();
    }

    @Override
    public Collection getEventInputRecords(FDSInputRecord fDSInputRecord) {
        return new Vector(0);
    }

    public void sortMembers() {
        FDSObject[] fDSObjectArray = new FDSObject[this.d_members.size()];
        this.d_members.toArray(fDSObjectArray);
        Arrays.sort(fDSObjectArray, new FDSObjectComparator());
        this.d_members.clear();
        for (int i = 0; i < fDSObjectArray.length; ++i) {
            this.d_members.add(fDSObjectArray[i]);
        }
        this.clearIndexCache();
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 2));
    }

    @Override
    public String getTypeDescription() {
        return "FDS Object Group";
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> set, Class<IDependedOn> clazz) {
        for (FDSObject fDSObject : this.d_members) {
            fDSObject.getObjectsDependedOn(set, clazz);
        }
    }

    @Override
    public boolean dependsOnObject(IDependedOn iDependedOn) {
        for (FDSObject fDSObject : this.d_members) {
            if (!fDSObject.dependsOnObject(iDependedOn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(final IDependedOn iDependedOn, final IDependedOn iDependedOn2) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject fDSObject : FDSComposite.this.d_members) {
                    this.addTask(fDSObject.taskUpdateAfterDependedOnReplaced(iDependedOn, iDependedOn2));
                }
            }
        };
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(final IDependedOn iDependedOn, final String string) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject fDSObject : FDSComposite.this.d_members) {
                    this.addTask(fDSObject.taskUpdateBeforeDependedOnRenamed(iDependedOn, string));
                }
            }
        };
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(final IDependedOn iDependedOn, final Object object) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                for (FDSObject fDSObject : FDSComposite.this.d_members) {
                    this.addTask(fDSObject.taskUpdateAfterDependedOnChanged(iDependedOn, object));
                }
            }
        };
    }

    @Override
    public Class<FDSObject> getVClass() {
        return FDSObject.class;
    }

    @Override
    public Class<Integer> getKClass() {
        return Integer.class;
    }

    @Override
    public boolean canMakeUnique(FDSObject fDSObject) {
        return false;
    }

    public boolean willReplaceIfAdded(FDSObject fDSObject) {
        return false;
    }

    @Override
    public String describeObject(FDSObject fDSObject) {
        return fDSObject.getName();
    }

    @Override
    public FDSObject get(FDSObject fDSObject) {
        return null;
    }

    @Override
    public Task taskMakeUnique(FDSObject fDSObject) {
        return null;
    }

    public Task taskAdd(FDSObject fDSObject, int n) {
        return this.taskAddAll(Arrays.asList(fDSObject), n);
    }

    public Task taskAddAll(Collection<? extends FDSObject> collection, int n) {
        return new APyroManAddAtIndexTask<Integer, FDSObject>((IPyroManager)this, collection, n){

            @Override
            public void removeAll(Collection<? extends FDSObject> collection) {
                FDSComposite.this.removeAll(collection);
            }

            @Override
            public boolean add(FDSObject fDSObject, int n) {
                return FDSComposite.this.add(fDSObject, n);
            }
        };
    }

    @Override
    public Task taskAdd(FDSObject fDSObject) {
        return this.taskAddAll((Collection<? extends FDSObject>)Arrays.asList(fDSObject));
    }

    @Override
    public Task taskAddAll(Collection<? extends FDSObject> collection) {
        return new APyroManAddTask<Integer, FDSObject>((IPyroManager)this, collection){

            @Override
            public boolean add(FDSObject fDSObject) {
                return FDSComposite.this.add(fDSObject);
            }

            @Override
            public boolean remove(FDSObject fDSObject) {
                return FDSComposite.this.remove(fDSObject);
            }
        };
    }

    @Override
    public Task taskRemove(FDSObject fDSObject, FDSObject fDSObject2) {
        return this.taskRemoveAll(Arrays.asList(fDSObject), Arrays.asList(fDSObject2));
    }

    @Override
    public Task taskRemoveAll(List<FDSObject> list, List<FDSObject> list2) {
        return new APyroManReplaceTask<Integer, FDSObject>((IPyroManager)this, list, list2){

            @Override
            public boolean add(FDSObject fDSObject) {
                return FDSComposite.this.add(fDSObject);
            }

            @Override
            public boolean remove(FDSObject fDSObject) {
                return FDSComposite.this.remove(fDSObject);
            }
        };
    }

    public Task taskRemove(int n) {
        return this.taskRemoveAll(Arrays.asList(n));
    }

    public Task taskRemoveAll(Collection<Integer> collection) {
        return new ARemoveAtIndexTask<Integer, FDSObject>((IPyroManager)this, collection){

            @Override
            public FDSObject remove(int n) {
                return FDSComposite.this.remove(n);
            }

            @Override
            public void add(FDSObject fDSObject, int n) {
                FDSComposite.this.add(fDSObject, n);
            }
        };
    }

    @Override
    public void addDomain(PyroMod pyroMod) {
        this.d_domainHelper.addDomain(pyroMod);
        for (FDSObject fDSObject : this) {
            fDSObject.addDomain(pyroMod);
        }
    }

    @Override
    public void removeDomain(PyroMod pyroMod) {
        this.d_domainHelper.removeDomain(pyroMod);
        for (FDSObject fDSObject : this) {
            fDSObject.removeDomain(pyroMod);
        }
    }

    @Override
    public Set<PyroMod> getDomains() {
        return this.d_domainHelper.getDomains();
    }

    public static Collection<FDSObject> collectAllObjects(Collection<? extends FDSObject> collection) {
        HashSet<FDSObject> hashSet = new HashSet<FDSObject>(collection.size());
        FDSComposite.collectAllObjects(collection, hashSet);
        return hashSet;
    }

    public static void collectAllObjects(Collection<? extends FDSObject> collection, Collection<FDSObject> collection2) {
        for (FDSObject fDSObject : collection) {
            collection2.add(fDSObject);
            if (!(fDSObject instanceof FDSComposite)) continue;
            FDSComposite.collectAllObjects(((FDSComposite)fDSObject).toCollection(), collection2);
        }
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    private class FDSObjectComparator
    implements Comparator {
        private FDSObjectComparator() {
        }

        public int compare(Object object, Object object2) {
            assert (object instanceof FDSObject);
            assert (object2 instanceof FDSObject);
            if (object instanceof FDSComposite && !(object2 instanceof FDSComposite)) {
                return -1;
            }
            if (!(object instanceof FDSComposite) && object2 instanceof FDSComposite) {
                return 1;
            }
            return ((FDSObject)object).getName().compareToIgnoreCase(((FDSObject)object2).getName());
        }
    }

    private static class OrderedObject {
        public Integer d_index;
        public FDSObject d_obj;

        public OrderedObject(FDSObject fDSObject, Integer n) {
            this.d_index = n;
            this.d_obj = fDSObject;
        }
    }
}

