/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class Block
extends AbstractFDSObject {
    static final long serialVersionUID = 1L;
    public static final int NUM_FACES = 6;
    private Prism d_prism;

    public Block(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, Material material) {
        this(unitPoint3D, unitPoint3D2, "Obstruction", material);
    }

    public Block(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string, Material material) {
        super(string);
        this.d_prism = new Prism(unitPoint3D.x(Geometry.GEOM_LENGTH_UNIT), unitPoint3D2.x(Geometry.GEOM_LENGTH_UNIT), unitPoint3D.y(Geometry.GEOM_LENGTH_UNIT), unitPoint3D2.y(Geometry.GEOM_LENGTH_UNIT), unitPoint3D.z(Geometry.GEOM_LENGTH_UNIT), unitPoint3D2.z(Geometry.GEOM_LENGTH_UNIT));
        this.initFaces(new Material[]{material, material, material, material, material, material});
    }

    public Block(UnitPoint3D[] unitPoint3DArray, String string, Material material) {
        super(string);
        this.d_prism = new Prism(new Point3d[]{unitPoint3DArray[0].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), unitPoint3DArray[1].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), unitPoint3DArray[2].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), unitPoint3DArray[3].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), unitPoint3DArray[4].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), unitPoint3DArray[5].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), unitPoint3DArray[6].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT), unitPoint3DArray[7].getPoint3dValue(Geometry.GEOM_LENGTH_UNIT)});
        this.initFaces(new Material[]{material, material, material, material, material, material});
    }

    private void initFaces(Material[] materialArray) {
        this.d_faces = new Vector(6);
        for (byte by = 0; by < 6; by = (byte)(by + 1)) {
            this.d_faces.add(new BlockFace(this, by, materialArray[by]));
        }
    }

    @Override
    public Task taskScaleObject(UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        return null;
    }

    @Override
    public Task taskRotateObject(UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        return null;
    }

    @Override
    public Task taskTranslateObject(UnitPoint3D unitPoint3D) {
        return null;
    }

    @Override
    public Task taskMirrorObject(int n, UnitDouble unitDouble) {
        return null;
    }

    @Override
    public Object clone() {
        Block block = (Block)super.clone();
        Iterator<IFace> iterator = block.getFaceIterator();
        while (iterator.hasNext()) {
            BlockFace blockFace = (BlockFace)iterator.next();
            blockFace.d_block = block;
        }
        block.d_prism = (Prism)this.d_prism.clone();
        return block;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Block block = (Block)object;
        return this.d_prism.equals(block.d_prism);
    }

    public void setPoint(int n, UnitPoint3D unitPoint3D) {
        Point3d point3d = this.d_prism.getPoint(n);
        point3d.x = unitPoint3D.x(Geometry.GEOM_LENGTH_UNIT);
        point3d.y = unitPoint3D.y(Geometry.GEOM_LENGTH_UNIT);
        point3d.z = unitPoint3D.z(Geometry.GEOM_LENGTH_UNIT);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("OBST");
        Vector<Double> vector = new Vector<Double>(6);
        Point3d point3d = this.d_prism.getPoint(0);
        Point3d point3d2 = this.d_prism.getPoint(6);
        vector.add(new Double(point3d.x));
        vector.add(new Double(point3d2.x));
        vector.add(new Double(point3d.y));
        vector.add(new Double(point3d2.y));
        vector.add(new Double(point3d.z));
        vector.add(new Double(point3d2.z));
        fDSInputRecord.setValue("XB", vector);
        if (this.isUniformMaterial()) {
            fDSInputRecord.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(1)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(2)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(3)).getMaterial()) {
            VectorFromArray<String> vectorFromArray = new VectorFromArray<String>(((IFace)this.d_faces.get(5)).getMaterial().getName(), ((IFace)this.d_faces.get(0)).getMaterial().getName(), ((IFace)this.d_faces.get(4)).getMaterial().getName());
            fDSInputRecord.setValue("SURF_IDS", vectorFromArray);
        } else {
            Vector<String> vector2 = new Vector<String>(6);
            for (int i = 0; i < 6; ++i) {
                vector2.add(((IFace)this.d_faces.get(i)).getMaterial().getName());
            }
            fDSInputRecord.setValue("SURF_ID6", vector2);
        }
        fDSInputRecord.setComment(this.getName());
        collection.add(fDSInputRecord);
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    @Override
    public void setMaterial(int n, Material material) {
        ((IFace)this.d_faces.get(n)).setMaterial(material);
    }

    @Override
    public Material getMaterial(int n) {
        return ((IFace)this.d_faces.get(n)).getMaterial();
    }

    @Override
    public String getTypeDescription() {
        return "Block";
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    static class BlockFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Block d_block;
        private byte d_index;

        public BlockFace(Block block, byte by, Material material) {
            super(material);
            this.d_block = block;
            this.d_index = by;
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public String getName() {
            return "Face " + this.d_index;
        }

        @Override
        public void getGeometry(Geometry geometry) {
            Quad quad = this.d_block.d_prism.getFace(this.d_index);
            geometry.addQuad(quad);
        }

        @Override
        public void setMaterial(Material material) {
            super.setMaterial(material);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof BlockFace)) {
                return false;
            }
            BlockFace blockFace = (BlockFace)object;
            return this.d_index == blockFace.d_index;
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return null;
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return null;
        }
    }
}

