/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.BNDFRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class BNDFRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    public static final String DEPTH = "DEPTH";
    public static final UnitDouble DEF_DEPTH = new UnitDouble(0.0, SI.METER);
    private UnitDouble d_dtsam = null;
    private String d_quantity = null;
    private Hashtable d_htExtraParams = new Hashtable(5);
    private static final Hashtable<String, ValueRange> d_ranges;

    public BNDFRecord(UnitDouble unitDouble, String string) {
        this.d_quantity = string;
        this.d_dtsam = unitDouble;
    }

    public static ValueRange getValueRange(String string) {
        return d_ranges.get(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.updateExtraParams();
        if ((!(objectInputStream instanceof PyroSimObjectInputStream) || objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 13) && this.d_dtsam != null && !BNDFRecord.getValueRange("DTSAM").checkValue(this.d_dtsam)) {
            this.d_dtsam = null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BNDFRecord)) {
            return false;
        }
        BNDFRecord bNDFRecord = (BNDFRecord)object;
        return this.d_quantity.equals(bNDFRecord.d_quantity) && this.d_htExtraParams.equals(bNDFRecord.d_htExtraParams) && (this.d_dtsam != null ? this.d_dtsam.equals(bNDFRecord.d_dtsam) : bNDFRecord.d_dtsam == null);
    }

    @Override
    public Object clone() {
        UnitDouble unitDouble = this.d_dtsam != null ? (UnitDouble)this.d_dtsam.clone() : null;
        BNDFRecord bNDFRecord = new BNDFRecord(unitDouble, this.d_quantity);
        for (Object v : this.d_htExtraParams.values()) {
            ExtraParam extraParam = (ExtraParam)v;
            bNDFRecord.setExtraParam(extraParam.d_sName, (UnitDouble)extraParam.d_udValue.clone(), extraParam.d_unitType);
        }
        return bNDFRecord;
    }

    private void updateExtraParams() {
        for (String string : this.d_htExtraParams.keySet()) {
            Object v = this.d_htExtraParams.get(string);
            if (!(v instanceof BNDFRecord.ExtraParam)) continue;
            BNDFRecord.ExtraParam extraParam = (BNDFRecord.ExtraParam)v;
            UnitDouble unitDouble = new UnitDouble(extraParam.d_dValue, SI.CELSIUS);
            ExtraParam extraParam2 = new ExtraParam(string, unitDouble, 1);
            this.d_htExtraParams.put(string, extraParam2);
        }
    }

    public boolean destroy() {
        ExtraParam[] extraParamArray = this.getAllExtraParams();
        for (PyroMod pyroMod : this.getDomains()) {
            for (int i = 0; i < extraParamArray.length; ++i) {
                if (extraParamArray[i].d_sName.equals("CHARACTERISTIC_VELOCITY")) {
                    pyroMod.getMiscManager().getMiscRecord().setCharVel(null);
                    continue;
                }
                if (!extraParamArray[i].d_sName.equals("GAUGE_TEMPERATURE")) continue;
                pyroMod.getMiscManager().getMiscRecord().setGaugeTemp(null);
            }
        }
        return true;
    }

    public UnitDouble getDTSam() {
        return this.d_dtsam;
    }

    public void setDTSam(UnitDouble unitDouble) {
        this.d_dtsam = unitDouble;
        this.fireDomainEvent(new PyroDomainEvent(this, BNDFRecord.class, 5));
    }

    public String getQuantity() {
        return this.d_quantity;
    }

    public void setQuantity(String string) {
        this.d_quantity = string;
        this.fireDomainEvent(new PyroDomainEvent(this, BNDFRecord.class, 5));
    }

    public UnitDouble getExtraParam(String string) {
        for (PyroMod pyroMod : this.getDomains()) {
            if (string.equals("CHARACTERISTIC_VELOCITY")) {
                return pyroMod.getMiscManager().getMiscRecord().getCharVel();
            }
            if (!string.equals("GAUGE_TEMPERATURE")) continue;
            return pyroMod.getMiscManager().getMiscRecord().getGaugeTemp();
        }
        return ((ExtraParam)this.d_htExtraParams.get((Object)string)).d_udValue;
    }

    public int getExtraParamUnitType(String string) {
        return ((ExtraParam)this.d_htExtraParams.get((Object)string)).d_unitType;
    }

    public ExtraParam[] getAllExtraParams() {
        return this.d_htExtraParams.values().toArray(new ExtraParam[this.d_htExtraParams.size()]);
    }

    public void setExtraParam(String string, UnitDouble unitDouble, int n) {
        for (PyroMod pyroMod : this.getDomains()) {
            if (string.equals("CHARACTERISTIC_VELOCITY")) {
                pyroMod.getMiscManager().getMiscRecord().setCharVel(unitDouble);
            } else if (string.equals("GAUGE_TEMPERATURE")) {
                pyroMod.getMiscManager().getMiscRecord().setGaugeTemp(unitDouble);
            }
            ExtraParam extraParam = (ExtraParam)this.d_htExtraParams.get(string);
            if (extraParam == null) {
                extraParam = new ExtraParam(string, unitDouble, n);
                this.d_htExtraParams.put(string, extraParam);
                continue;
            }
            extraParam.d_udValue = unitDouble;
        }
        this.fireDomainEvent(new PyroDomainEvent(this, BNDFRecord.class, 5));
    }

    @Override
    public String getFDSType() {
        return "BNDF";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType("BNDF");
        fDSInputRecord.setValue("QUANTITY", this.d_quantity);
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        if (this.d_dtsam != null) {
            fDSInputRecord.setValue("DTSAM", new Double(this.d_dtsam.getValue(fdsSISystem.getTimeUnit())));
        }
        ExtraParam[] extraParamArray = this.getAllExtraParams();
        for (int i = 0; i < extraParamArray.length; ++i) {
            if (extraParamArray[i].d_sName.equals("CHARACTERISTIC_VELOCITY") || extraParamArray[i].d_sName.equals("GAUGE_TEMPERATURE")) continue;
            fDSInputRecord.setValue(extraParamArray[i].d_sName, new Double(extraParamArray[i].d_udValue.getValue(fdsSISystem.getUnit(extraParamArray[i].d_unitType))));
        }
        collection.add(fDSInputRecord);
    }

    @Override
    public String getTypeDescription() {
        return "Boundary Quantity";
    }

    static {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        d_ranges = new Hashtable(1);
        d_ranges.put("DTSAM", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), false));
    }

    public class ExtraParam
    implements Serializable {
        static final long serialVersionUID = 1L;
        int d_unitType;
        public UnitDouble d_udValue;
        public String d_sName;
        public double d_dValue;

        public ExtraParam(String string, UnitDouble unitDouble, int n) {
            this.d_udValue = unitDouble;
            this.d_sName = string;
            this.d_unitType = n;
        }
    }
}

