/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class BNDFList
extends APyroDomainManager<String, BNDFRecord>
implements Serializable {
    static final long serialVersionUID = 1L;
    private Hashtable<String, BNDFRecord> d_bndfs = new Hashtable();
    protected boolean d_bOutputEnabled = true;

    public BNDFList() {
    }

    public BNDFList(boolean bl) {
        this.d_bOutputEnabled = bl;
    }

    @Override
    public Collection<? extends BNDFRecord> toCollection() {
        return new PyroCollection<String, BNDFRecord>(this);
    }

    public boolean isOutputEnabled() {
        return this.d_bOutputEnabled;
    }

    public void setOutputEnabled(boolean bl) {
        this.d_bOutputEnabled = bl;
        this.fireDomainEvent(new PyroDomainEvent(this.toCollection(), BNDFRecord.class, 5));
    }

    @Override
    protected boolean add(BNDFRecord bNDFRecord) {
        if (this.d_bndfs.containsKey(bNDFRecord.getQuantity())) {
            return false;
        }
        super.add(bNDFRecord);
        this.d_bndfs.put(bNDFRecord.getQuantity(), bNDFRecord);
        this.fireDomainEvent(new PyroDomainEvent<BNDFList, BNDFRecord>(this, bNDFRecord, BNDFRecord.class, 3));
        return true;
    }

    @Override
    public BNDFRecord get(String string) {
        return this.d_bndfs.get(string);
    }

    @Override
    protected boolean remove(BNDFRecord bNDFRecord) {
        BNDFRecord bNDFRecord2 = this.get(bNDFRecord.getQuantity());
        if (bNDFRecord2 != null) {
            bNDFRecord2.destroy();
        }
        super.remove(bNDFRecord);
        this.fireDomainEvent(new PyroDomainEvent<BNDFList, BNDFRecord>(this, bNDFRecord, BNDFRecord.class, 4));
        return this.d_bndfs.remove(bNDFRecord.getQuantity()) != null;
    }

    public BNDFRecord[] toArray() {
        return this.d_bndfs.values().toArray(new BNDFRecord[this.d_bndfs.size()]);
    }

    public BNDFRecord[] toArray(BNDFRecord[] bNDFRecordArray) {
        return this.d_bndfs.values().toArray(bNDFRecordArray);
    }

    public static BNDFList fromLegacy(pyrosim.legacy_2006_2.legacy.BNDFList bNDFList) {
        BNDFList bNDFList2 = new BNDFList();
        for (BNDFRecord bNDFRecord : bNDFList.values()) {
            bNDFList2.add(bNDFRecord);
        }
        bNDFList2.setOutputEnabled(bNDFList.isOutputEnabled());
        return bNDFList2;
    }

    @Override
    public boolean contains(String string) {
        return this.d_bndfs.containsKey(string);
    }

    @Override
    public Iterator<BNDFRecord> iterator() {
        return this.d_bndfs.values().iterator();
    }

    @Override
    public int size() {
        return this.d_bndfs.size();
    }

    @Override
    public Class<BNDFRecord> getVClass() {
        return BNDFRecord.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public BNDFRecord get(BNDFRecord bNDFRecord) {
        return this.d_bndfs.get(bNDFRecord.getQuantity());
    }

    @Override
    public String describeObject(BNDFRecord bNDFRecord) {
        return bNDFRecord.getQuantity();
    }

    @Override
    public Task taskAdd(BNDFRecord bNDFRecord) {
        return this.taskAddAll((Collection<? extends BNDFRecord>)new VectorFromArray<BNDFRecord>(bNDFRecord));
    }

    @Override
    public Task taskAddAll(Collection<? extends BNDFRecord> collection) {
        return new APyroManAddTask<String, BNDFRecord>((IPyroManager)this, collection){

            @Override
            public boolean add(BNDFRecord bNDFRecord) {
                return BNDFList.this.add(bNDFRecord);
            }

            @Override
            public boolean remove(BNDFRecord bNDFRecord) {
                return BNDFList.this.remove(bNDFRecord);
            }
        };
    }

    @Override
    public Task taskRemove(BNDFRecord bNDFRecord, BNDFRecord bNDFRecord2) {
        return this.taskRemoveAll((List<BNDFRecord>)new VectorFromArray<BNDFRecord>(bNDFRecord), (List<BNDFRecord>)new VectorFromArray<BNDFRecord>(bNDFRecord2));
    }

    @Override
    public Task taskRemoveAll(List<BNDFRecord> list, List<BNDFRecord> list2) {
        return new APyroManReplaceTask<String, BNDFRecord>((IPyroManager)this, list, list2){

            @Override
            public boolean add(BNDFRecord bNDFRecord) {
                return BNDFList.this.add(bNDFRecord);
            }

            @Override
            public boolean remove(BNDFRecord bNDFRecord) {
                return BNDFList.this.remove(bNDFRecord);
            }
        };
    }

    @Override
    public boolean canMakeUnique(BNDFRecord bNDFRecord) {
        return false;
    }

    @Override
    public Task taskMakeUnique(BNDFRecord bNDFRecord) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.d_bndfs.isEmpty();
    }
}

