/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.util.Set;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AAlignedFDSObject;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public final class AlignedHole
extends AAlignedFDSObject {
    static final long serialVersionUID = 1L;
    private static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);

    public AlignedHole() {
        this(new UnitPoint3D(0.0, 0.0, 0.0, SI.METER), new UnitPoint3D(0.0, 0.0, 0.0, SI.METER));
    }

    public AlignedHole(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        this(unitPoint3D, unitPoint3D2, "Hole");
    }

    public AlignedHole(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string) {
        super(unitPoint3D, unitPoint3D2, string, null);
        this.setColor(null);
    }

    public static AlignedHole fromLegacy(pyrosim.legacy_2006_2.legacy.v16.AlignedHole alignedHole) {
        AlignedHole alignedHole2 = new AlignedHole();
        AAlignedFDSObject.fromLegacy(alignedHole, alignedHole2);
        return alignedHole2;
    }

    @Override
    protected void rotateFaces(Vector3d vector3d, UnitDouble unitDouble) {
    }

    @Override
    protected void mirrorFaces(int n, UnitDouble unitDouble) {
    }

    @Override
    public void imprint(Object object) {
        if (!(object instanceof AlignedHole)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        FDSObject fDSObject = (FDSObject)object;
        this.setColor(fDSObject.getColor());
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AlignedHole)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void setColor(Color color) {
        if (color != null) {
            super.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 102));
        } else {
            super.setColor(null);
        }
    }

    @Override
    public String getFDSType() {
        return "HOLE";
    }

    @Override
    protected void fillExtraRecords(FDSInputRecord fDSInputRecord) {
    }

    @Override
    protected void fillMaterialRecords(FDSInputRecord fDSInputRecord) {
    }

    @Override
    public void setMaterial(int n, Material material) {
    }

    @Override
    public Material getMaterial(int n) {
        return null;
    }

    @Override
    public void getGeometry(Geometry geometry) {
        Prism prism = new Prism(this.getMinPoint().getValue(Geometry.GEOM_LENGTH_UNIT), this.getMaxPoint().getValue(Geometry.GEOM_LENGTH_UNIT));
        if (this.getColor() != null) {
            prism.setColor(this.getColor());
        } else {
            prism.setColor(DEF_COLOR);
        }
        geometry.addPrism(prism);
    }

    @Override
    public String getTypeDescription() {
        return "Hole";
    }

    @Override
    public boolean dependsOnObject(IDependedOn iDependedOn) {
        if (iDependedOn instanceof Material) {
            return false;
        }
        return super.dependsOnObject(iDependedOn);
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> set, Class<IDependedOn> clazz) {
        if (Material.class.isAssignableFrom(clazz)) {
            return;
        }
        super.getObjectsDependedOn(set, clazz);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn iDependedOn, Object object) {
        if (iDependedOn instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnChanged(iDependedOn, object);
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn iDependedOn, IDependedOn iDependedOn2) {
        if (iDependedOn instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnReplaced(iDependedOn, iDependedOn2);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn iDependedOn, String string) {
        if (iDependedOn instanceof Material) {
            return null;
        }
        return super.taskUpdateBeforeDependedOnRenamed(iDependedOn, string);
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }
}

