/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AAlignedFDSObject;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public final class AlignedBlock
extends AAlignedFDSObject {
    static final long serialVersionUID = 1L;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = true;

    public AlignedBlock(Material material) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, SI.METER), new UnitPoint3D(0.0, 0.0, 0.0, SI.METER), material);
    }

    public AlignedBlock(String string, Material material) {
        super(string, material);
    }

    public AlignedBlock(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, Material material) {
        this(unitPoint3D, unitPoint3D2, "Obstruction", material);
    }

    public AlignedBlock(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string, Material material) {
        super(unitPoint3D, unitPoint3D2, string, material);
    }

    public AlignedBlock(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string, Color color, Material material) {
        super(unitPoint3D, unitPoint3D2, string, color, material);
    }

    public static AlignedBlock fromLegacy(pyrosim.legacy_2006_2.legacy.v16.AlignedBlock alignedBlock) {
        AlignedBlock alignedBlock2 = new AlignedBlock(alignedBlock.getMaterial());
        AAlignedFDSObject.fromLegacy(alignedBlock, alignedBlock2);
        alignedBlock2.d_permitHole = alignedBlock.permitsHole();
        alignedBlock2.d_sawtooth = alignedBlock.isSawtoothed();
        alignedBlock2.d_thicken = alignedBlock.isThickened();
        return alignedBlock2;
    }

    @Override
    protected void imprint(Object object) {
        if (!(object instanceof AlignedBlock)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        AlignedBlock alignedBlock = (AlignedBlock)object;
        this.d_thicken = alignedBlock.d_thicken;
        this.d_permitHole = alignedBlock.d_permitHole;
        this.d_sawtooth = alignedBlock.d_sawtooth;
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof AlignedBlock)) {
            return false;
        }
        AlignedBlock alignedBlock = (AlignedBlock)object;
        boolean bl = this.d_thicken == alignedBlock.d_thicken && this.d_permitHole == alignedBlock.d_permitHole && this.d_sawtooth == alignedBlock.d_sawtooth;
        return bl;
    }

    @Override
    public String getPropertyHashString() {
        String string = super.getPropertyHashString();
        string = string + this.d_permitHole + "," + this.d_thicken + "," + this.d_sawtooth + ";";
        return string;
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    protected void fillExtraRecords(FDSInputRecord fDSInputRecord) {
        fDSInputRecord.setValue("PERMIT_HOLE", new Boolean(this.d_permitHole));
        fDSInputRecord.setValue("SAWTOOTH", new Boolean(this.d_sawtooth));
        fDSInputRecord.setValue("THICKEN", new Boolean(this.d_thicken));
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public void setPermitsHole(boolean bl) {
        this.d_permitHole = bl;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setIsSawtoothed(boolean bl) {
        this.d_sawtooth = bl;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setIsThickened(boolean bl) {
        this.d_thicken = bl;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public String getTypeDescription() {
        return "Aligned Block";
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }
}

