/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.Activatable;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.HeatActivationEventList;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public abstract class ActivatableObject
extends ADomainObject<PyroMod>
implements Activatable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8389673050790027763L;
    private Vector<ActivationEventList> d_vAllEvents = new Vector();
    private boolean d_bCanBeActivatedByAnyHeatDetector = false;
    private boolean d_bCanBeDeactivatedByAnyHeatDetector = false;

    @Override
    public Object clone() {
        ActivatableObject activatableObject = (ActivatableObject)super.clone();
        activatableObject.d_vAllEvents = new Vector(this.d_vAllEvents.size());
        for (ActivationEventList activationEventList : this.d_vAllEvents) {
            activatableObject.d_vAllEvents.add((ActivationEventList)activationEventList.clone());
        }
        return activatableObject;
    }

    protected void fixSerializable() {
        if (this.d_vAllEvents == null) {
            this.d_vAllEvents = new Vector();
            this.d_bCanBeActivatedByAnyHeatDetector = false;
            this.d_bCanBeDeactivatedByAnyHeatDetector = false;
        }
    }

    @Override
    public void addDomain(PyroMod pyroMod) {
        super.addDomain(pyroMod);
        for (ActivationEventList activationEventList : this.d_vAllEvents) {
            activationEventList.addDomain(pyroMod);
        }
    }

    @Override
    public void removeDomain(PyroMod pyroMod) {
        super.removeDomain(pyroMod);
        for (ActivationEventList activationEventList : this.d_vAllEvents) {
            activationEventList.removeDomain(pyroMod);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ActivatableObject) {
            return ((ActivatableObject)object).d_vAllEvents.equals(this.d_vAllEvents) && ((ActivatableObject)object).d_bCanBeActivatedByAnyHeatDetector == this.d_bCanBeActivatedByAnyHeatDetector && ((ActivatableObject)object).d_bCanBeDeactivatedByAnyHeatDetector == this.d_bCanBeDeactivatedByAnyHeatDetector;
        }
        return false;
    }

    @Override
    public boolean addEvent(ActivationEvent activationEvent) {
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            if (activationEventList.getEventType() != activationEvent.getEventType()) continue;
            activationEventList.taskAddEvent(activationEvent).run();
            return true;
        }
        activationEventList = AbstractActivationEventList.createNewList(activationEvent.getEventType(), this.getDomains());
        activationEventList.taskAddEvent(activationEvent).run();
        this.d_vAllEvents.add(activationEventList);
        if (activationEvent.getEventType() == 1) {
            ((HeatActivationEventList)activationEventList).setCanBeTriggeredByAny(this.d_bCanBeActivatedByAnyHeatDetector, 0);
            ((HeatActivationEventList)activationEventList).setCanBeTriggeredByAny(this.d_bCanBeDeactivatedByAnyHeatDetector, 1);
        }
        return true;
    }

    @Override
    public boolean removeEvent(ActivationEvent activationEvent) {
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            if (activationEventList.getEventType() != activationEvent.getEventType()) continue;
            activationEventList.taskRemoveEvent(activationEvent).run();
            if (activationEventList.size() == 0) {
                this.d_vAllEvents.remove(i);
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeAllEvents() {
        this.d_vAllEvents.clear();
    }

    @Override
    public void removeEvents(int n) {
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            if (activationEventList.getEventType() != n) continue;
            this.d_vAllEvents.remove(i);
        }
    }

    @Override
    public ActivationEventList getEventsOfType(int n) {
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            if (activationEventList.getEventType() != n) continue;
            return activationEventList;
        }
        return AbstractActivationEventList.createNewList(n, this.getDomains());
    }

    @Override
    public ActivationEvent[] getAllEvents() {
        Vector<ActivationEvent> vector = new Vector<ActivationEvent>();
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            vector.addAll(activationEventList.getAllEvents());
        }
        return vector.toArray(new ActivationEvent[vector.size()]);
    }

    @Override
    public Vector getEventsSeparatedByType() {
        return this.d_vAllEvents;
    }

    @Override
    public void setCanBeTriggeredByAnyHeatDetector(boolean bl, int n) {
        HeatActivationEventList heatActivationEventList = (HeatActivationEventList)this.getEventsOfType(1);
        heatActivationEventList.setCanBeTriggeredByAny(bl, n);
        if (n == 0) {
            this.d_bCanBeActivatedByAnyHeatDetector = bl;
        } else {
            this.d_bCanBeDeactivatedByAnyHeatDetector = bl;
        }
    }

    @Override
    public boolean getCanBeTriggeredByAnyHeatDetector(int n) {
        if (n == 0) {
            return this.d_bCanBeActivatedByAnyHeatDetector;
        }
        return this.d_bCanBeDeactivatedByAnyHeatDetector;
    }

    public void initEvents() {
        if (this.d_vAllEvents == null) {
            this.d_vAllEvents = new Vector();
        }
    }

    @Override
    public Collection getEventInputRecords(FDSInputRecord fDSInputRecord) {
        Object object;
        Vector<FDSInputRecord> vector = new Vector<FDSInputRecord>();
        Map map = this.getEventInputRecordMap(1);
        if (this.getCanBeTriggeredByAnyHeatDetector(0)) {
            object = (String)map.get(new Integer(0));
            fDSInputRecord.setValue((String)object, "ALL");
            vector.add(fDSInputRecord);
            fDSInputRecord = (FDSInputRecord)fDSInputRecord.clone();
            fDSInputRecord.removeValue((String)object);
        }
        if (this.getCanBeTriggeredByAnyHeatDetector(1)) {
            object = (String)map.get(new Integer(1));
            fDSInputRecord.setValue((String)object, "ALL");
            vector.add(fDSInputRecord);
            fDSInputRecord = (FDSInputRecord)fDSInputRecord.clone();
            fDSInputRecord.removeValue((String)object);
        }
        object = null;
        Vector vector2 = this.getEventsSeparatedByType();
        for (int i = 0; i < vector2.size(); ++i) {
            object = (ActivationEventList)vector2.get(i);
            vector.addAll(object.getInputRecords(fDSInputRecord, this.getEventInputRecordMap(object.getEventType())));
        }
        return vector;
    }
}

